
close all ;
% Step 1: Load data 
load('MMF_transferFunctions_OM4_400m.mat');
load('DataBER_106.25G_OM4.mat');
load('DataLmax_106.25G_OM4.mat');

Lambdas =[850   880   910   940];
% Initialize an array to store the equivalent bandwidth for each fiber
NOM4 = size(Hf_MMF_OM4, 4);  % Number of fibers
equivalent_bandwidths = zeros(NOM4, 1);

% Select indices for the specific wavelength and laser
wavelength_index = 1;  % replace with the index of your selected wavelength
laser_index = 1;       % replace with the index of your selected laser

% Iterate over all fibers
for fiber_index = 1:NOM4
    % Extract the transfer function for this specific fiber
    TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

    % Calculate the equivalent bandwidth for the current fiber
    equivalent_bandwidths(fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
end

% Display the result for all fibers
for i = 1:NOM4
    fprintf('The equivalent bandwidth for fiber %d is %.2f Hz\n', i, equivalent_bandwidths(i));
end


% Assuming the dimensions for Hf_MMF_OM4 are [wavelengths, lasers, frequencies, fibers]
numWavelengths = size(Hf_MMF_OM4, 1);
numLasers = size(Hf_MMF_OM4, 2);
numFibers = size(Hf_MMF_OM4, 4);

% Initialize an array to store the equivalent bandwidths
equivalent_bandwidths_all = zeros(numWavelengths, numLasers, numFibers);
% Iterate over all wavelengths, lasers, and fibers
for wavelength_index = 1:numWavelengths
    for laser_index = 1:numLasers
        for fiber_index = 1:numFibers
            % Extract the transfer function for this specific combination
            TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

            % Calculate the equivalent bandwidth for the current combination
            equivalent_bandwidths_all(wavelength_index, laser_index, fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
            
        end
    end
end
% Reshape the 3D arrays into 1D vectors
vector_equiv = reshape(equivalent_bandwidths_all, [], 1);

% Display the size of the new vector to confirm the operation
disp(size(vector_equiv));



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5

% Assuming indices for lambda, laser, and equalizer are all 1

Lengths = [0 30 50 70 100 150 200 250 300 350 400];  % Distances in meters

% Extract the BER data for the specific setting across all fibers and distances
BER_400 = squeeze(BER_OM4(:, :, 1, :, 11));  % Resulting size should be [4x8x3766]


% Assuming TF is [Nlambda x Nlaser x Nfreq x NOM4]
[Nlambda, Nlaser, Nfreq, NOM4] = size(Hf_MMF_OM4);

% Initialize the equivalent bandwidth matrix
equivalent_bandwidths = zeros(Nlambda, Nlaser, NOM4);
for i = 1:Nlambda
    for j = 1:Nlaser
        for k = 1:NOM4
            % Extract the specific transfer function slice for the current fiber
            TF_slice = squeeze(Hf_MMF_OM4(i, j, :, k));
            
            % Calculate the equivalent bandwidth for the current slice
            equivalent_bandwidths(i, j, k) = calculateEquivalentBandwidth(TF_slice, freq);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%BER400m study 
% Assuming equivalent_bandwidth has the size [4 x 8 x 3766]
% BER_400 is already [4 x 8 x 3766]

numWavelengths = 4;
numLasers = 8;
numFibers = 3766;
correlation_matrix = zeros(numWavelengths, numLasers); % Store correlation coefficients

for i = 1:numWavelengths
    for j = 1:numLasers
        % Extract the data for each wavelength and laser combination
        current_BER = squeeze(BER_400(i, j, :));
        current_Bandwidth = squeeze(equivalent_bandwidths(i, j, :));
        
        % Calculate the correlation coefficient between current BER and Bandwidth
        correlation_matrix(i, j) = corr(current_BER, current_Bandwidth, 'Rows', 'complete');
    end
end

% Display the correlation matrix
disp(correlation_matrix);
% Using imagesc to create the heatmap
figure;
imagesc(correlation_matrix);
colorbar;
title('Heatmap of Correlation between BER and Equivalent Bandwidth');
xlabel('Laser Index');
ylabel('Wavelength Index');
set(gca, 'XTick', 1:numLasers, 'YTick', 1:numWavelengths);
colormap('jet'); % You can choose other colormaps like 'hot', 'cool', etc.

% Alternatively, using MATLAB's heatmap function
figure;
heatmap(correlation_matrix);
title('Heatmap of Correlation between BER and Equivalent Bandwidth');
xlabel('Laser Index');
ylabel('Wavelength Index');

%%%%%%%%%%%%%%%%Lmax study 

Lmax=squeeze(Lmax_OM4(:,:,1,:));

% Assuming equivalent_bandwidths is calculated and has size [4 x 8 x 3766]
% Lmax is extracted and has size [4 x 8 x 3766]
% Retrieve the size of the matrix for clarity and for use in loops
[Nlambda, Nlaser, NOM4] = size(Lmax);
correlation_matrix_Lmax_BW(:) = NaN;  % Initialize all to NaN

for i = 1:Nlambda
    for j = 1:Nlaser
        current_Lmax = squeeze(Lmax(i, j, :));
        current_Bandwidth = squeeze(equivalent_bandwidths(i, j, :));

        % Handling NaN and Inf values explicitly
        current_Lmax(isinf(current_Lmax)) = NaN;  % Replace Inf with NaN

        % Exclude any NaN values in the analysis
        valid_indices = ~isnan(current_Lmax) & ~isnan(current_Bandwidth);

        % Detailed diagnostics for the problematic index
        if i == 1 && j == 8
            disp(['Valid data points after handling NaN/Inf at (1, 8): ', num2str(sum(valid_indices))]);
            if sum(valid_indices) > 1
                disp(['Standard Deviation of Lmax at (1, 8): ', num2str(std(current_Lmax(valid_indices)))]);
            end
        end

        % Check for at least two valid data points with non-zero variance
        if sum(valid_indices) > 1 && std(current_Lmax(valid_indices)) > 0
            correlation_matrix_Lmax_BW(i, j) = corr(current_Lmax(valid_indices), current_Bandwidth(valid_indices));
        end
    end
end
% Using imagesc to create the heatmap
figure;
imagesc(correlation_matrix_Lmax_BW);
colorbar;
title('Heatmap of Correlation between Lmax and Equivalent Bandwidth');
xlabel('Laser Index');
ylabel('Wavelength Index');
xticks(1:numLasers);
yticks(1:numWavelengths);
colormap('jet'); % You can choose other colormaps like 'hot', 'cool', etc.

% Alternatively, using MATLAB's heatmap function for more intuitive labeling
figure;
heatmap (correlation_matrix_Lmax_BW);
title('Heatmap of Correlation between Lmax and Equivalent Bandwidth');
xlabel('Laser Index');
ylabel('Wavelength Index');
% Display the final updated correlation matrix
disp('Final updated Correlation matrix between Lmax and Equivalent Bandwidth:');
disp(correlation_matrix_Lmax_BW);
%%%%%%%%%%%%%%
% Assuming 'correlation_matrix_Lmax_BW' is the matrix from the heatmap
Nwavelength = 4; % Number of wavelengths
Nlaser = 8; % Number of lasers

% Compute average correlation for each wavelength across all lasers
wavelength_avgs = mean(correlation_matrix_Lmax_BW, 2);

% Compute average correlation for each laser across all wavelengths
laser_avgs = mean(correlation_matrix_Lmax_BW, 1);

% Prepare matrices for display
wavelength_avg_matrix = repmat(wavelength_avgs, 1, Nlaser); % Repeat the column vector across laser dimension
laser_avg_matrix = repmat(laser_avgs, Nwavelength, 1); % Repeat the row vector across wavelength dimension

% Display the matrices
disp('Matrix of Average Correlation for Each Wavelength:');
disp(wavelength_avg_matrix);

disp('Matrix of Average Correlation for Each Laser:');
disp(laser_avg_matrix);
%%%%%%%%%%
% Assuming 'correlation_matrix_Lmax_BW' is the matrix from the heatmap

% Initialize parameters
Nwavelength = 4; % Number of wavelengths
Nlaser = 8; % Number of lasers

% Compute average correlation for each wavelength across all lasers
wavelength_avgs = mean(correlation_matrix_Lmax_BW, 2);

% Compute average correlation for each laser across all wavelengths
laser_avgs = mean(correlation_matrix_Lmax_BW, 1);

% Create subplot for displaying the matrices and the vector side by side
figure;

% Plot 1: Heatmap for correlation matrix
subplot(1, 3, 1);
imagesc(correlation_matrix_Lmax_BW);
colorbar;
title('Heatmap of Correlation Lmax vs Equivalent Bandwidth');
xlabel('Laser Index');
ylabel('Wavelength Index');
xticklabels(1:Nlaser);
yticklabels(850:30:940); % Assuming these are the wavelengths in nm
colormap('jet');

% Plot 2: Average correlations per wavelength
subplot(1, 3, 2);
bar(wavelength_avgs);
title('Average Correlation per Wavelength');
xlabel('Wavelength Index');
ylabel('Average Correlation');
xticks(1:Nwavelength);
xticklabels({'850 nm', '880 nm', '910 nm', '940 nm'});

% Plot 3: Average correlations per laser
subplot(1, 3, 3);
bar(laser_avgs);
title('Average Correlation per Laser');
xlabel('Laser Index');
ylabel('Average Correlation');
xticks(1:Nlaser);
xticklabels(1:Nlaser);

% Adjust layout to avoid overlap
set(gcf, 'Position', [100, 100, 1200, 400]);  % Resize figure to make it wider


%%%%%%%%%%%%%%
% Create subplot for displaying the matrices and the vector side by side
figure;

% Plot 1: Heatmap for correlation matrix BER
subplot(1, 3, 1);
imagesc(correlation_matrix);
colorbar;
title('Heatmap of Correlation BER vs Equivalent Bandwidth');
xlabel('Laser Index');
ylabel('Wavelength Index');
xticklabels(1:Nlaser);
yticklabels(850:30:940); % Assuming these are the wavelengths in nm
colormap('jet');

% Plot 2: Average correlations per wavelength
subplot(1, 3, 2);
bar(wavelength_avgs);
title('Average Correlation per Wavelength');
xlabel('Wavelength Index');
ylabel('Average Correlation');
xticks(1:Nwavelength);
xticklabels({'850 nm', '880 nm', '910 nm', '940 nm'});

% Plot 3: Average correlations per laser
subplot(1, 3, 3);
bar(laser_avgs);
title('Average Correlation per Laser');
xlabel('Laser Index');
ylabel('Average Correlation');
xticks(1:Nlaser);
xticklabels(1:Nlaser);

% Adjust layout to avoid overlap
set(gcf, 'Position', [100, 100, 1200, 400]);  % Resize figure to make it wider
%%%%%%%%%%%%%
% Function to calculate the equivalent bandwidth
function equivalent_bandwidth = calculateEquivalentBandwidth(TF, freq)
    % Square the magnitude of the transfer function
    TF_squared = abs(TF).^2;

    % Integrate over frequency to find total power
    total_power = trapz(freq, TF_squared);

    % Calculate the equivalent bandwidth based on total power
    equivalent_bandwidth = total_power / max(TF_squared);
end
