close all ;
% Step 1: Load data 
load('MMF_transferFunctions_OM4_400m.mat');
load('DataBER_106.25G_OM4.mat');
load('DataLmax_106.25G_OM4.mat');
% Step 2: Extract relevant variables
Lambdas = Lambdas;
Laszers = Laser;
frequencies = freq;
Transfer_fct_MMF_OM4 = Hf_MMF_OM4;
EMB_OM4 = EMB_OM4;
Group_delay_OM4 = taug_OM4;
numWavelengths = size(Hf_MMF_OM4, 1);
numLasers = size(Hf_MMF_OM4, 2);
numFibers = size(Hf_MMF_OM4, 4);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
laser_idx = 1;
laser_index=1;
lambda_idx = 1;
fiber_index = 1;
wavelength_index=1;
            transfer_function = squeeze(Hf_MMF_OM4(lambda_idx, laser_idx, :, 1));

                % Step 4: Generate the plot
                figure;
                plot(freq, 10*log10(abs(transfer_function)));
                xlabel('Frequency');
                ylabel('Transfer Function');
                title('Transfer Function vs. Frequency at wavelength ',Lambdas(lambda_idx));
                grid on;
                             
% Set reference distance and reference transfer function at 400m for a specific laser and wavelength
Lref = 400; % Reference distance in meters
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
reference_TF_dB = 10*log10(reference_TF/max(reference_TF)); % Convert to dB normalized to max
%Prepare a plot
figure;
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

desired_distances=Lengths(2:end);
% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
    TF_scaled = interp1(freq_scaled, TF, freq, "linear");
    
    % Normalize to the maximum value at 400m
    TF_scaled_dB = 10*log10(abs(TF_scaled/max(reference_TF))); % Convert to dB normalized to max at 400m

    % Plot
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;




% Initialize an array to store the equivalent bandwidths
equivalent_bandwidths_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_3dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_5dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_10dB_all = zeros(numWavelengths, numLasers, numFibers);
% Iterate over all wavelengths, lasers, and fibers
for wavelength_index = 1:numWavelengths
    for laser_index = 1:numLasers
        for fiber_index = 1:numFibers
            % Extract the transfer function for this specific combination
            TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

            % Calculate the equivalent bandwidth for the current combination
            equivalent_bandwidths_all(wavelength_index, laser_index, fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
            bandwidths_3dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus3dBBandwidth(TF_selected, freq);
            bandwidths_5dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus5dBBandwidth(TF_selected, freq);
            bandwidths_10dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus10dBBandwidth(TF_selected, freq);
        end
    end
end
% Reshape the 3D arrays into 1D vectors
vector_equiv = reshape(equivalent_bandwidths_all, [], 1);
vector_3dB = reshape(bandwidths_3dB_all, [], 1);
vector_5dB = reshape(bandwidths_5dB_all, [], 1);
vector_10dB = reshape(bandwidths_10dB_all, [], 1);

% Display the size of the new vector to confirm the operation
disp(size(vector_equiv));
disp(size(vector_3dB));
disp(size(vector_5dB));
disp(size(vector_10dB));

%Lmax analysis :

Lmax_all= squeeze(Lmax_OM4(:, :, 1, :));
Lmax_all_vector = reshape(Lmax_all, [], 1);

% Create a logical index for non-NaN and non-Inf values
validIndex = ~(isnan(Lmax_all_vector) | isinf(Lmax_all_vector));

% Filter out NaN and Inf values from Lmax_all_vector
Lmax_all_vector_cleaned = Lmax_all_vector(validIndex);

% Apply the same valid index to the other vectors
vector_3dB_cleaned = vector_3dB(validIndex);
vector_5dB_cleaned = vector_5dB(validIndex);
vector_10dB_cleaned = vector_10dB(validIndex);
vector_equiv_cleaned = vector_equiv(validIndex);



% Assuming you have already calculated your bandwidths and stored them in variables:
% bandwidth_3dB, bandwidth_5dB, bandwidth_10dB, equivalent_bandwidth
% and you have the corresponding Lmax data in Lmax_data

% Combine the cleaned bandwidths into an input matrix X
X = [vector_3dB_cleaned, vector_5dB_cleaned, vector_10dB_cleaned, vector_equiv_cleaned];

% Define the corresponding Lmax as the output vector Y
Y = Lmax_all_vector_cleaned;

% Display the size of X and Y to confirm they match
disp(size(X));
disp(size(Y));


% Split the data into training (80%) and testing (20%) sets
cv = cvpartition(size(X,1),'HoldOut',0.2);
XTrain = X(training(cv),:);
YTrain = Y(training(cv),:);
XTest = X(test(cv),:);
YTest = Y(test(cv),:);


% Define the neural network with one hidden layer of 10 neurons
net = fitnet(10); % Adjust the number of neurons if needed

% Configure the training function (Levenberg-Marquardt backpropagation)
net.trainFcn = 'trainlm';

% Train the neural network
[net, tr] = train(net, XTrain', YTrain');

% Predict the output using the trained network
YPred = net(XTest');

% Calculate the prediction accuracy using Mean Squared Error (MSE)
mseError = mse(net, YTest', YPred);
fprintf('Mean Squared Error of the prediction: %f\n', mseError);

% Visualize the training performance
figure;
plotperform(tr);



% Example of new bandwidths for prediction
new_bandwidth_3dB = 15; % Example value for -3 dB bandwidth
new_bandwidth_5dB = 12; % Example value for -5 dB bandwidth
new_bandwidth_10dB = 9; % Example value for -10 dB bandwidth
new_equivalent_bandwidth = 20; % Example value for equivalent bandwidth

% Combine these into a single input vector
new_input = [new_bandwidth_3dB, new_bandwidth_5dB, new_bandwidth_10dB, new_equivalent_bandwidth];

% Use the trained network to predict Lmax
predicted_Lmax = net(new_input');

fprintf('The predicted Lmax is: %f\n', predicted_Lmax);



% Calculate the differences between predicted and actual Lmax values
differences = abs(YPred - YTest');

% Find the maximum difference
maxDifference = max(differences);

fprintf('Maximum Difference between Predicted and Actual Lmax: %f\n', maxDifference);

% Display some basic statistics about the differences
meanDifference = mean(differences);
stdDifference = std(differences);

fprintf('Mean Difference: %f\n', meanDifference);
fprintf('Standard Deviation of Differences: %f\n', stdDifference);

% Plot the differences
figure;
plot(YTest', differences, 'o');
xlabel('True Lmax');
ylabel('Absolute Difference (|True - Predicted|)');
title('Absolute Differences between True and Predicted Lmax');
grid on;

% Optionally, you can also plot a histogram of the differences
figure;
histogram(differences, 20); % 20 bins for the histogram
xlabel('Absolute Difference (|True - Predicted|)');
ylabel('Frequency');
title('Histogram of Absolute Differences');








% Function to calculate the -3dB bandwidth
function bandwidth_3dB = calculateMinus3dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -3dB from the peak
    within_3dB_indices = find(TF_dB >= max_TF_dB - 3);

    % Find the -3dB bandwidth, which is the difference between the first and last frequencies within the -3dB range
    if ~isempty(within_3dB_indices)
        bandwidth_3dB = freq(within_3dB_indices(end)) - freq(within_3dB_indices(1));
    else
        bandwidth_3dB = NaN; % Return NaN if there's no bandwidth within -3dB
    end
end
% Function to calculate the -5dB bandwidth
function bandwidth_5dB = calculateMinus5dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -5dB from the peak
    within_5dB_indices = find(TF_dB >= max_TF_dB - 5);

    % Find the -5dB bandwidth, which is the difference between the first and last frequencies within the -5dB range
    if ~isempty(within_5dB_indices)
        bandwidth_5dB = freq(within_5dB_indices(end)) - freq(within_5dB_indices(1));
    else
        bandwidth_5dB = NaN; % Return NaN if there's no bandwidth within -5dB
    end
end

% Function to calculate the -10dB bandwidth
function bandwidth_10dB = calculateMinus10dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -10dB from the peak
    within_10dB_indices = find(TF_dB >= max_TF_dB - 10);

    % Find the -10dB bandwidth, which is the difference between the first and last frequencies within the -10dB range
    if ~isempty(within_10dB_indices)
        bandwidth_10dB = freq(within_10dB_indices(end)) - freq(within_10dB_indices(1));
    else
        bandwidth_10dB = NaN; % Return NaN if there's no bandwidth within -10dB
    end
end




% Function to calculate the equivalent bandwidth
function equivalent_bandwidth = calculateEquivalentBandwidth(TF, freq)
    % Square the magnitude of the transfer function
    TF_squared = abs(TF).^2;

    % Integrate over frequency to find total power
    total_power = trapz(freq, TF_squared);

    % Calculate the equivalent bandwidth based on total power
    equivalent_bandwidth = total_power / max(TF_squared);
end




