close all ;
%Lmax
Lmax_all=Lmax_all_vector_cleaned ;
% Initialize the matrix
DB3_test = zeros(120507, 10);

% Assign each vector to a column of the matrix
DB3_test(:, 1) = A_30;
DB3_test(:, 2) = A_50;
DB3_test(:, 3) = A_70;
DB3_test(:, 4) = A_100;
DB3_test(:, 5) = A_150;
DB3_test(:, 6) = A_200;
DB3_test(:, 7) = A_250;
DB3_test(:, 8) = A_300;
DB3_test(:, 9) = A_350;
DB3_test(:, 10) = A_400;
DB3_test_GHZ=DB3_test./10^9;

% Calculate the correlation coefficients between each column of DB3_test and Lmax_all_vector
correlation_matrix = zeros(1, size(DB3_test_GHZ, 2));  % Initialize the correlation matrix

for i = 1:size(DB3_test_GHZ, 2)
    correlation_matrix(i) = corr(DB3_test_GHZ(:, i), Lmax_all);
end


% Assuming DB_equiv_test is defined as in your code
num_vectors = size(DB3_test_GHZ, 2);

% Initialize the MAPE matrix
mape_matrix = zeros(num_vectors, num_vectors);

% Calculate the MAPE between each pair of columns in DB_equiv_test
for i = 1:num_vectors
    for j = 1:num_vectors
        if i ~= j
            mape_matrix(i, j) = calculate_mape(DB3_test_GHZ(:, i), DB3_test_GHZ(:, j));
        end
    end
end

% Display the MAPE matrix
disp('MAPE matrix between each pair of vectors (percentage):');
disp(mape_matrix);

% Visualize the MAPE matrix using a heatmap
figure;
heatmap(mape_matrix, 'Colormap', parula, 'ColorbarVisible', 'on');
title('MAPE Matrix for DB3_test');

% Save the figure as a PNG file
saveas(gcf, 'MAPE_Matrix3db.png');







% Display the correlation matrix
disp('Correlation matrix between each A_30 to A_400 and Lmax:');
disp(correlation_matrix);
%cosine similarity=cos(θ)= a⋅b / ∥a∥∥b∥
%Cosine similarity provides a measure of similarity between vectors that is independent of their magnitude. 
% It ranges from -1 to 1, where 1 indicates maximum similarity.​

% Transpose the matrix to have vectors as rows for pdist function
A_T = DB3_test';

% Calculate pairwise cosine distances
cosineDistances3 = pdist(A_T, 'cosine');

% Convert to square form and cosine similarity
cosineSimilarityMatrix3 = 1 - squareform(cosineDistances3);

% Convert cosine similarity to percentage
cosineSimilarityPercentage3 = cosineSimilarityMatrix3 * 100;

% Display the cosine similarity percentage matrix
disp('Cosine Similarity Percentage Matrix:');
disp(cosineSimilarityPercentage3);

% Visualize the cosine similarity percentage matrix using a heatmap
figure;
heatmap(cosineSimilarityPercentage3);
title('Cosine Similarity Percentage Matrix for 3 db BW');

% Save the figure as a PNG file
saveas(gcf, 'CosineSimilarityMatrix 3 db.png');

% Initialize the matrix
DB5_test = zeros(120507, 10);

% Assign each vector to a column of the matrix
DB5_test(:, 1) = B_30;
DB5_test(:, 2) = B_50;
DB5_test(:, 3) = B_70;
DB5_test(:, 4) = B_100;
DB5_test(:, 5) = B_150;
DB5_test(:, 6) = B_200;
DB5_test(:, 7) = B_250;
DB5_test(:, 8) = B_300;
DB5_test(:, 9) = B_350;
DB5_test(:, 10) = B_400;




% Calculate the correlation coefficients between each column of DB3_test and Lmax_all_vector
correlation_matrix = zeros(1, size(DB5_test, 2));  % Initialize the correlation matrix

for i = 1:size(DB5_test, 2)
    correlation_matrix(i) = corr(DB5_test(:, i), Lmax_all);
end


% Assuming DB_equiv_test is defined as in your code
num_vectors = size(DB5_test, 2);

% Initialize the MAPE matrix
mape_matrix = zeros(num_vectors, num_vectors);

% Calculate the MAPE between each pair of columns in DB_equiv_test
for i = 1:num_vectors
    for j = 1:num_vectors
        if i ~= j
            mape_matrix(i, j) = calculate_mape(DB5_test(:, i), DB5_test(:, j));
        end
    end
end

% Display the MAPE matrix
disp('MAPE matrix between each pair of vectors (percentage):');
disp(mape_matrix);

% Visualize the MAPE matrix using a heatmap
figure;
heatmap(mape_matrix, 'Colormap', parula, 'ColorbarVisible', 'on');
title('MAPE Matrix for DB5_test');

% Save the figure as a PNG file
saveas(gcf, 'MAPE_Matrix5db.png');








% Transpose the matrix to have vectors as rows for pdist function
B_T = DB5_test';

% Calculate pairwise cosine distances
cosineDistances5 = pdist(B_T, 'cosine');

% Convert to square form and cosine similarity
cosineSimilarityMatrix5 = 1 - squareform(cosineDistances5);

% Convert cosine similarity to percentage
cosineSimilarityPercentage5 = cosineSimilarityMatrix5 * 100;

% Display the cosine similarity percentage matrix
disp('Cosine Similarity Percentage Matrix:');
disp(cosineSimilarityPercentage5);

% Visualize the cosine similarity percentage matrix using a heatmap
figure;
heatmap(cosineSimilarityPercentage5);
title('Cosine Similarity Percentage Matrix for 5 dB bw');

% Save the figure as a PNG file
saveas(gcf, 'CosineSimilarityMatrix 5 db.png');



% Initialize the matrix
DB10_test = zeros(120507, 10);

% Assign each vector to a column of the matrix
DB10_test(:, 1) = C_30;
DB10_test(:, 2) = C_50;
DB10_test(:, 3) = C_70;
DB10_test(:, 4) = C_100;
DB10_test(:, 5) = C_150;
DB10_test(:, 6) = C_200;
DB10_test(:, 7) = C_250;
DB10_test(:, 8) = C_300;
DB10_test(:, 9) = C_350;
DB10_test(:, 10) = C_400;


% Calculate the correlation coefficients between each column of DB3_test and Lmax_all_vector
correlation_matrix = zeros(1, size(DB10_test, 2));  % Initialize the correlation matrix

for i = 1:size(DB10_test, 2)
    correlation_matrix(i) = corr(DB10_test(:, i), Lmax_all);
end


% Assuming DB_equiv_test is defined as in your code
num_vectors = size(DB10_test, 2);

% Initialize the MAPE matrix
mape_matrix = zeros(num_vectors, num_vectors);

% Calculate the MAPE between each pair of columns in DB_equiv_test
for i = 1:num_vectors
    for j = 1:num_vectors
        if i ~= j
            mape_matrix(i, j) = calculate_mape(DB10_test(:, i), DB10_test(:, j));
        end
    end
end

% Display the MAPE matrix
disp('MAPE matrix between each pair of vectors (percentage):');
disp(mape_matrix);

% Visualize the MAPE matrix using a heatmap
figure;
heatmap(mape_matrix, 'Colormap', parula, 'ColorbarVisible', 'on');
title('MAPE Matrix for DB10_test');

% Save the figure as a PNG file
saveas(gcf, 'MAPE_Matrix10db.png');





% Transpose the matrix to have vectors as rows for pdist function
C_T = DB10_test';

% Calculate pairwise cosine distances
cosineDistances10 = pdist(C_T, 'cosine');

% Convert to square form and cosine similarity
cosineSimilarityMatrix10 = 1 - squareform(cosineDistances10);

% Convert cosine similarity to percentage
cosineSimilarityPercentage10 = cosineSimilarityMatrix10 * 100;

% Display the cosine similarity percentage matrix
disp('Cosine Similarity Percentage Matrix:');
disp(cosineSimilarityPercentage10);

% Visualize the cosine similarity percentage matrix using a heatmap
figure;
heatmap(cosineSimilarityPercentage10);
title('Cosine Similarity Percentage Matrix for 10 dB bw');


% Save the figure as a PNG file
saveas(gcf, 'CosineSimilarityMatrix 10 db.png');



% Initialize the matrix
DB_equiv_test = zeros(120507, 10);

% Assign each vector to a column of the matrix
DB_equiv_test(:, 1) = D_30;
DB_equiv_test(:, 2) = D_50;
DB_equiv_test(:, 3) = D_70;
DB_equiv_test(:, 4) = D_100;
DB_equiv_test(:, 5) = D_150;
DB_equiv_test(:, 6) = D_200;
DB_equiv_test(:, 7) = D_250;
DB_equiv_test(:, 8) = D_300;
DB_equiv_test(:, 9) = D_350;
DB_equiv_test(:, 10) = D_400;



% Calculate the correlation coefficients between each column of DB3_test and Lmax_all_vector
correlation_matrix = zeros(1, size(DB_equiv_test, 2));  % Initialize the correlation matrix

for i = 1:size(DB_equiv_test, 2)
    correlation_matrix(i) = corr(DB_equiv_test(:, i), Lmax_all);
end

% Display the correlation matrix
disp('Correlation matrix between each A_30 to A_400 and Lmax:');
disp(correlation_matrix);


% Transpose the matrix to have vectors as rows for pdist function
D_T = DB_equiv_test';

% Calculate pairwise cosine distances
cosineDistances_equiv = pdist(D_T, 'cosine');

% Convert to square form and cosine similarity
cosineSimilarityMatrix_equiv = 1 - squareform(cosineDistances_equiv);

% Convert cosine similarity to percentage
cosineSimilarityPercentage_equiv = cosineSimilarityMatrix_equiv * 100;

% Display the cosine similarity percentage matrix
disp('Cosine Similarity Percentage Matrix:');
disp(cosineSimilarityPercentage_equiv);

% Visualize the cosine similarity percentage matrix using a heatmap
figure;
heatmap(cosineSimilarityPercentage_equiv);
title('Cosine Similarity Percentage Matrix for equivalent  bw');

% Save the figure as a PNG file
saveas(gcf, 'CosineSimilarityMatrix equivalent.png');


% Assuming Lmax_all_vector and DB_equiv_test are already defined as in your code

% Calculate the correlation coefficients between each column of DB_equiv_test and Lmax_all_vector
correlation_matrix = zeros(1, size(DB_equiv_test, 2));  % Initialize the correlation matrix

for i = 1:size(DB_equiv_test, 2)
    correlation_matrix(i) = corr(DB_equiv_test(:, i), Lmax_all);
end

% Display the correlation matrix
disp('Correlation matrix between each D_30 to D_400 and Lmax:');
disp(correlation_matrix);

% Transpose the matrix to have vectors as rows for pdist function
D_T = DB_equiv_test';

% Calculate pairwise cosine distances
cosineDistances_equiv = pdist(D_T, 'cosine');

% Convert to square form and cosine similarity
cosineSimilarityMatrix_equiv = 1 - squareform(cosineDistances_equiv);

% Convert cosine similarity to percentage
cosineSimilarityPercentage_equiv = cosineSimilarityMatrix_equiv * 100;

% Display the cosine similarity percentage matrix
disp('Cosine Similarity Percentage Matrix:');
disp(cosineSimilarityPercentage_equiv);

% Visualize the cosine similarity percentage matrix using a heatmap
figure;
heatmap(cosineSimilarityPercentage_equiv);
title('Cosine Similarity Percentage Matrix for Equivalent D');

% Save the figure as a PNG file
saveas(gcf, 'CosineSimilarityMatrix_equiv.png');

% Plot the vectors to visualize their similarity
figure;
hold on;
for i = 1:size(DB_equiv_test, 2)
    plot(DB_equiv_test(:, i));
end
plot(Lmax_all, 'k', 'LineWidth', 2);  % Plot Lmax_all in black with a thicker line
hold off;
title('Vectors D_30 to D_400 and Lmax');
legend('D_30', 'D_50', 'D_70', 'D_100', 'D_150', 'D_200', 'D_250', 'D_300', 'D_350', 'D_400', 'Lmax');
xlabel('Index');
ylabel('Value');

% Save the vector plot as a PNG file
saveas(gcf, 'VectorPlot_equiv.png');

% Assuming DB_equiv_test is defined as in your code
num_vectors = size(DB_equiv_test, 2);

% Initialize the MAPE matrix
mape_matrix = zeros(num_vectors, num_vectors);

% Calculate the MAPE between each pair of columns in DB_equiv_test
for i = 1:num_vectors
    for j = 1:num_vectors
        if i ~= j
            mape_matrix(i, j) = calculate_mape(DB_equiv_test(:, i), DB_equiv_test(:, j));
        end
    end
end

% Display the MAPE matrix
disp('MAPE matrix between each pair of vectors (percentage):');
disp(mape_matrix);

% Visualize the MAPE matrix using a heatmap
figure;
heatmap(mape_matrix, 'Colormap', parula, 'ColorbarVisible', 'on');
title('MAPE Matrix for DB_equiv_test');

% Save the figure as a PNG file
saveas(gcf, 'MAPE_Matrix.png');



% Function to calculate MAPE
function mape = calculate_mape(vector1, vector2)
    % Ensure the vectors are of the same length
    if length(vector1) ~= length(vector2)
        error('Vectors must be of the same length');
    end
    
    % Calculate the absolute percentage error for each element
    absolute_percentage_errors = abs((vector1 - vector2) ./ vector1) * 100;
    
    % Calculate the mean absolute percentage error
    mape = mean(absolute_percentage_errors, 'omitnan');
end