clearvars
close all

weekFolder = "NBL_New_29-07-2024\";
mySheet = "NBL 400 MIM\Endurance 3V"; % change this when sample changes
shape = "h"; % "h" or "sq"
diam = 200;

% seg_time = 500e-6; % 1 kHz
seg_time = 100e-6; % 5 kHz
% seg_time = 50e-6; % 10 kHz
% seg_time = 25e-6; % 20 kHz
% seg_time = 10e-6; % 50 kHz

myFolder = "\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - PUND\" + weekFolder + mySheet;
extension = "\*.xls";
myFiles = dir(myFolder + extension); % list of all files
Cycles = zeros([length(myFiles) 1]);
Endurance = zeros([length(myFiles) 2]);
I_all = zeros([400 length(myFiles)]);
P_all = zeros([400 length(myFiles)]);

% naming for excel sheet
mySheet = join(split(mySheet,'\'));
mySheet = erase(mySheet, "Endurance ");


for i=1:length(myFiles)
    tbl = readtable(fullfile(myFolder, myFiles(i).name)); % get data
    V = tbl{:,"Voltage1"};
    I = tbl{:,"Current1"};

    % figure(3)
    % p3 = plot(V,I);
    % hold on

    nm = split(myFiles(i).name);
    nmm = split(nm(end-1),'_');
    Cycles(i) = string(nmm(end));

    if shape == "sq"
        area = (diam*1E-6)^2;
    else
        area = pi*(diam*1E-6/2)^2;
    end

    l = length(V);
    V_clean = V(l/4+1:3*l/4);
    I_clean = [I(1:l/4)-I(l/4+1:l/2);I(l/2+1:3*l/4)-I(3*l/4+1:l)]; % remove measurement noise

    P = -cumtrapz(I_clean)*(1E6)*(seg_time)/100/(area*(1E4)); % get polarization by integration

    avg_top = (P(1,:)+P(end,:))/2; % average distance of the discontinuity around zero
    shift = (avg_top+min(P))/2; % to place the center of the curve in the origin

    P_shift = P - shift;
    Endurance(i,:) = [max(P_shift) min(P_shift)]; % save both absolute max and the average
    I_all(:,i) = I_clean;
    P_all(:,i) = P_shift;

  
    figure(1)
    p1 = plot(V_clean,I_clean*1e6);
    hold on

    figure(2)
    p2 = plot(V_clean,P_shift);
    hold on
end

[Cycles,b]=sort(Cycles); % a = freq(b); b is a vector of freq's indices ordered according to the sort function
Endurance = Endurance(b,:); % now Pmax is reordered in the same way

figure(3)
semilogx(nonzeros(Cycles),nonzeros(Endurance(:,1)),'*')
axis padded

writematrix([Endurance Cycles],"NBL_new_Endurance.xls",'Sheet',mySheet+"_endurance") % save into excel file
writematrix([P_all V_clean],"NBL_new_Endurance.xls",'Sheet',mySheet+"_P") % save into excel file
writematrix([I_all V_clean],"NBL_new_Endurance.xls",'Sheet',mySheet+"_I") % save into excel file

