clearvars
close all

myFolder = "\\cubitus\Master2_NanoElec\NPezzato\VT-FETs\LogicCells\2024-07-18_DG-SP01-A1\";
myFiles_osc = dir(myFolder + "Oscillo\*.csv"); % oscillo's data
myFiles_kei = dir(myFolder + "Keithley\*.xls"); % Keithley's data

qd = "\\cubitus\Master2_NanoElec\NPezzato\VT-FETs\LogicCells\2024-07-18_DG-SP01-A1\QuickDraw - copy.xlsx";
com_file = "\\cubitus\Master2_NanoElec\NPezzato\VT-FETs\LogicCells\2024-07-18_DG-SP01-A1\Screening_LogicCells_Mesures.xlsx";

mySample = "2024-07-18_DG-SP01-A1";

comments = readtable(com_file,"Sheet",mySample);%,"Range","M"); % read file with the comments

for i=1:length(myFiles_osc)

    % 5 coloumns: time v1 v2 v3 v4 = time A B Y trigger
    tbl = readtable(fullfile(myFolder+"Oscillo", myFiles_osc(i).name)); % get oscillo's data
    writetable(tbl,qd,"Sheet","Oscillo"); % write on Quickdraw

    tbl = readtable(fullfile(myFolder+"Keithley", myFiles_kei(i).name)); % read Keithley's data
    writetable(tbl,qd,"Sheet","Keithley"); % write on Quickdraw

    tbl = readtable(qd,"Sheet","Treatment",'UseExcel',1); % read treated data
    % UseExcel needed to update the excel file

    figure(i) % plot
    p = plot(tbl{:,1},tbl{:,2},tbl{:,1},tbl{:,3},tbl{:,1},tbl{:,4});
    p(1).LineWidth = 2;
    p(2).LineWidth = 2;
    p(3).LineWidth = 2;

    str = ["#"+num2str(comments{i,1},'%02i') comments{i,"Device"} comments{i,"Freq__Hz_"}+" Hz" num2str(comments{i,"R_L___"}/1e3)+" kΩ" "V\_A/B "+comments{i,"V_A_V_"} comments{i,"Vd_V_"} "*"+comments{i,"Comment"}+"*"]; % #01 Int p-NAND: 10Hz, 100kΩ, V_A/B 0/-1V, Vd -1V \n Y always 0
    title(join(str,', ')) % from the comments' file
    axis padded
    legend(tbl.Properties.VariableNames(2:4),"Location","southoutside","Orientation","horizontal")
end

