clearvars
close all

%{
This code expects a name of the file that ends like this: "... nbl_600_h200_50k 29-07-2024.xls"
It distinguishes each part of the file's name using the spaces; it skips the
last part (hence the date) and reads the run name (nbl_600_h200_50k), of which it uses only
the last part (50k): the frequency used.
If it doesn't work you have to change either the name or the code
%}

weekFolder = "NBL_New_29-07-2024\";
mySheet = "NBL 500 MIM\Sw time 3V"; % this will become the name of the excel sheet
r = 1e6; % resize of current when plotted
shape = "h"; % "h" or "sq"
diam = 200;
n_meas = 100;
volt = "3V"; % it will be inserted in the coloumn name

myFolder = "\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - PUND\" + weekFolder + mySheet;
extension = "\*.xls";
myFiles = dir(myFolder + extension); % list of all files

%% Initialization
Pmax = zeros([length(myFiles) 2]);
freq = zeros([length(myFiles) 1]);
vtypes = strings([1 2]);
vtypes(1:end) = "double";
T = table('Size', [length(myFiles), 2],'VariableTypes',vtypes);
T_sort = T;

T.Properties.VariableNames(:,1:2) = {char("f_"+volt), char("P_"+volt)};

%% Calculation
for i=1:length(myFiles)
    tbl = readtable(fullfile(myFolder, myFiles(i).name)); % get data
    % V = tbl{201:600,"Voltage1"};
    V = tbl{:,"Voltage1"};
    I = tbl{:,"Current1"};

    %% get freq from the name
    name = split(myFiles(i).name);
    meas = split(name(end-1),'_'); % NBL_600f_5.5V_1k

    raw_freq = meas(end);
    if ~isempty(find(char(raw_freq)=='k',1)) % if there's a k
        f = sscanf(string(raw_freq),"%d");
        freq(i) = f*1e3;
    elseif ~isempty(find(char(raw_freq)=='M',1)) % if there's a M
        f = sscanf(string(raw_freq),"%d");
        freq(i) = f*1e6;
    else
        freq(i) = str2double(raw_freq);
    end

    %% Calculation
    l = length(V);
    V_clean = V(l/4+1:3*l/4);
    I_clean = [I(1:l/4)-I(l/4+1:l/2);I(l/2+1:3*l/4)-I(3*l/4+1:l)]; % remove measurement noise

    if shape == "sq"
        area = (diam*1E-6)^2;
    else
        area = pi*(diam*1E-6/2)^2;
    end

    P = -cumtrapz(I_clean)*(1E6)*(1/freq(i)/2)/n_meas/(area*(1E4)); % get polarization by integration
    % pi*(diam/2)^2 if circle
    % (side)^2 if square

    %% Shifting
    avg_top = (P(1,:)+P(end,:))/2; % average distance of the discontinuity around zero
    shift = (avg_top+min(P))/2; % to place the center of the curve in the origin
    
    %otherwise
    [mymax,ind_max] = max(I_clean); % find max and min of I
    [mymin,ind_min] = min(I_clean);
    % shift = (P(ind_max)+P(ind_min)/2); % shift P so that P(Vmax) = 0; average in case P(Vmax) != P(Vmin)

    P_shift = P - shift;
    T{i,1:2} = [1/freq(i) max(P_shift)];
    % [freq(i)/1e3 V_clean(ind_max) V_clean(ind_min) max(P_shift)]

    tb = nonzeros(T{:,1});
    [T_sort{1:length(tb),1},b]=sort(tb);
    T_sort{1:length(tb),2} = T{b,2};


    %% Plotting
    figure(i)
    plot(V_clean,I_clean*r,'LineWidth',4)
    nnn = split(myFiles(i).name);
    title(join(split(nnn(end-1),'_')));
    xlabel("V [V]")
    ylabel("I [µA]")
    axis padded

    figure(i*100)
    plot(V_clean,P_shift,'LineWidth',4)
    title(join(split(nnn(end-1),'_')));
    xlabel("V [V]")
    ylabel("P [µC/cm^2]")
    axis padded
end
T_sort.Properties.VariableNames = T.Properties.VariableNames;

%% SORTING
[a,b]=sort(freq); % a = freq(b); b is a vector of freq's indices ordered according to the sort function
Pmax = Pmax(b,:); % now Pmax is reordered in the same way

figure(111)
semilogx(nonzeros(T_sort{:,1}),nonzeros(T_sort{:,2}),'-*')
axis padded

%% SAVE
mySheet = join(split(mySheet,'\')); % removes the '\' that is not accepted in the name in excel
% writetable(T_sort,"new_NBL.xls",'Sheet',mySheet)

