clearvars
close all

%{
%% Single measure
% modify and copy-paste in the command window
% in the workspace window (down left) there will be all the variables,
% by double-clicking on them another window is opened with the value,
% you can copy-paste like excel/origin

tbl = readtable(""); % get data
diam = ; % pi*(diam/2)^2 if circle
freq = ;
n_meas = ;

V = tbl{:,"Voltage1"};
I = tbl{:,"Current1"};

l = length(V);
V_clean = V(l/4+1:3*l/4);
I_clean = [I(1:l/4)-I(l/4+1:l/2);I(l/2+1:3*l/4)-I(3*l/4+1:l)]; % remove measurement noise

P = -cumtrapz(I_clean)*(1E6)*(1/freq/2)/n_meas/(pi*(diam/2*1E-6)^2*(1E4)); % get polarization by integration

avg_top = (P(1,:)+P(end,:))/2; % average distance of the discontinuity around zero
shift = (avg_top+min(P))/2; % to place the center of the curve in the origin

P_shift = P - shift;

figure(1)
plot(V_clean,I_clean*1e6)
figure(2)
plot(V_clean,P_shift)

writematrix([V_clean I_clean P_shift],"NBL_samples.xls",'Sheet',"") % saves into excel file

% alternatively
tbl = readtable("\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - PUND\NBL_New_29-07-2024\MIS\Run4 08-01-2024.xls"); % get data

V = tbl{:,"Voltage1"};
I = tbl{:,"Current1"};

figure(1)
plot(V,I*1e6)
%}

%% Multiple measures
mysample = "NBL_New_29-07-2024\MIS";
myFolder = "\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - PUND\" + mysample;
myFiles = dir(myFolder + "\*.xls");

diam = 200; % pi*(diam/2)^2 if circle
freq = 2e3;
n_meas = 100;

% by putting diam or freq = [100 200 300 ...]; you create a vector of them
% then you have to put diam(i) of freq(i) every time they appear
% in this way you can apply this loop to measurements made with different diam or freq (or both)
% you only have to put the values in the correct order
% to check the order of the files you can click on the myFiles variable after a first run

I_all = zeros([400 length(myFiles)]);
P_all = zeros([400 length(myFiles)]);

%% Calculation
for i=1:5%length(myFiles)
    tbl = readtable(fullfile(myFolder, myFiles(i).name)); % get data

    V = tbl{:,"Voltage1"};
    I = tbl{:,"Current1"};

    % l = length(V);
    % V_clean = V(l/4+1:3*l/4);
    % I_clean = [I(1:l/4)-I(l/4+1:l/2);I(l/2+1:3*l/4)-I(3*l/4+1:l)]; % remove measurement noise
    % 
    % P = -cumtrapz(I_clean)*(1E6)*(1/freq/2)/n_meas/(pi*(diam(i)/2*1E-6)^2*(1E4)); % get polarization by integration
    % % pi*(diam/2)^2 if circle
    % 
    % avg_top = (P(1,:)+P(end,:))/2; % average distance of the discontinuity around zero
    % shift = (avg_top+min(P))/2; % to place the center of the curve in the origin
    % 
    % P_shift = P - shift;
    % 
    % I_all(:,i) = I_clean;
    % P_all(:,i) = P_shift;
    
    %% Plotting
    % figure(i)
    % plot(V_clean,I_clean*1e6,'LineWidth',2)
    name = split(myFiles(i).name);
    % title(name(end-1))
    % xlabel("Voltage [V]")
    % ylabel("Current [µA]")
    % xlim padded;
    % ylim padded;
    % % hold on
    % 
    % figure(i*100) 
    % plot(V_clean,P_shift,'LineWidth',2)
    % title(name(end-1))
    % xlabel("Voltage [V]")
    % ylabel("Polarisation [µC/cm^2]")
    % xlim padded;
    % ylim padded;
    % % hold on

    figure(1)%(i*1000)
    plot(V,I*1e3,'LineWidth',4)
    title(join(split(name(end-1),'_')))
    hold on
    axis padded
end

% writematrix([P_all V_clean],".xls",'Sheet',"") % save into excel file
% writematrix([I_all V_clean],".xls",'Sheet',"") % save into excel file
% it saves P or I for each column, putting the voltage at the last column


