clearvars
close all

% this script is used for endurance tests done all in once, so everything
% will be saved in the same file
% through the number of measurement and the iterations it should
% distinguish the different measurements

weekFolder = "MIM\";
mySheet = ""; % change this when sample changes

diam = 200;
shape = "h"; % "h" or "sq"
seg_time = 10e-6; % 50 kHz
n_meas = 25;
iterations = 9; % different cycles applied (1e0 then 1e1 then 1e2 cycles are 3 iterations)

len_clean = n_meas*4;
len = len_clean*2;

% myFolder = "\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - PUND\" + weekFolder + mySheet;
% extension = "\*.xls";
% myFiles = dir(myFolder + extension); % list of all files
Cycles = zeros([iterations 1]);
Endurance = zeros([iterations 2]);
I_all = zeros([len_clean iterations]);
P_all = zeros([len_clean iterations]);

tbl = readtable("\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - PUND\MIM\FILENAME.xls"); % get data

for i=1:len:len*iterations

    range = i+(len-1);
    j = range/len;

    V = tbl{i:range,"Voltage1"};
    I = tbl{i:range,"Current1"};

    if i > 1
        Cycles(j) = double("1e"+string(range/len));
    else
        Cycles(1) = 1;
    end

    if shape == "sq"
        area = (diam*1E-6)^2;
    else
        area = pi*(diam*1E-6/2)^2;
    end

    l = length(V);
    V_clean = V(l/4+1:3*l/4);
    I_clean = [I(1:l/4)-I(l/4+1:l/2);I(l/2+1:3*l/4)-I(3*l/4+1:l)]; % remove measurement noise
    
    P = -cumtrapz(I_clean)*(1E6)*(seg_time)/n_meas/(area*(1E4)); % get polarization by integration

    avg_top = (P(1,:)+P(end,:))/2; % average distance of the discontinuity around zero
    shift = (avg_top+min(P))/2; % to place the center of the curve in the origin

    P_shift = P - shift;

    Endurance(j,:) = [max(P_shift) min(P_shift)]; % save both absolute max and the average
    I_all(:,j) = I_clean;
    P_all(:,j) = P_shift;

    if j > 7
        c = '--';
    else
        c = '-';
    end

    figure(1)
    p1 = plot(V_clean,I_clean,c);
    hold on

    % figure(j)
    % p1 = plot(V,I,c);
    % hold on

    figure(2)
    p2 = plot(V_clean,P_shift,c);
    hold on
end

mySheet = join(split(mySheet,'\'));
writematrix([Endurance Cycles],".xls",'Sheet',"") % save into excel file
writematrix([P_all V_clean],".xls",'Sheet',"") % save into excel file
writematrix([I_all V_clean],".xls",'Sheet',"") % save into excel file


