clearvars

myFolder = "\\cubitus\Master2_NanoElec\NPezzato\Ferroelectric\Meas - DHM\" + ""; % put here the final folder

myFiles = dir(myFolder + "\*.xls");

freq = 1E3;
diam = 100;
n_meas = 100;

names = strings([length(myFiles) 1]);
info = zeros([length(myFiles) 3]);
vtypes = strings([1 length(myFiles)*3]);
vtypes(1:end) = "double";
T = table('Size', [400, length(myFiles)*3],'VariableTypes',vtypes);

for i=1:length(myFiles)
    tbl = readtable(fullfile(myFolder, myFiles(i).name)); % get data

    name = split(myFiles(i).name);
    names(i) = name(end-1);

    nm = split(names(i),'_');
    % diam = sscanf(nm(end),"%*c%d");

    V = tbl{1:end-2,"Voltage1"};
    I = tbl{1:end-2,"Current1"};

    P = cumtrapz(I)*(1E6)*(1/freq/4)/n_meas/(pi*(diam/2*1E-6)^2*(1E4)); % get polarization by integration
    % P = tbl{1:400,"PR_H200"};
    
    avg_top = (P(1,:)+P(end,:))/2; % average distance of the discontinuity around zero
    shift = (avg_top+min(P))/2; % to place the center of the curve in the origin
    
    P_shift = P - shift;

    [val1, ind1] = max(I);
    [val2, ind2] = min(I);
    info(i,:) = [V(ind1) V(ind2) max(P_shift)]; % Coercive voltages and Pmax

    if nm(1) == "F600f"
        c = 'b';
    elseif nm(1) == "F500"
        c = 'r';
    elseif nm(1) == "F700"
        c = 'g';
    else
        c = 'm';
    end

    % if max(I*1e6) < 3000 && max(V) > 6.6 % to avoid burnt contacts

        % T(:,3*i-2:3*i) = table(V, I, P_shift);
        % T.Properties.VariableNames(:,3*i-2:3*i) = {char("V_"+nm(2)+"_"+num2str(i)), char("I_"+nm(2)+"_"+num2str(i)), char("P_"+nm(2)+"_"+num2str(i))};
    
        figure(i)
        plot(V,I*1e6,c)
        hold on
        title(join(split(names(i),'_')))
    
        figure(i*100)
        plot(V,P_shift,c)
        hold on
    
        % figure(3)
        % plot(V,P)
        % hold on

    % end
end

