% DTRW: Descrete time Random Walk, 380x380 pixels in order to make it
% correspond to the set up of the data acquisition; 


%%%%%%%%%%%%%%%%Labeling of the edges of the square%%%%%%%%%%%%%%%%%%%%%%%%

%       (0,380)               edge 3              (380,380)
%               -----------------------------------
%               |                                 |
%               |                                 |
%               |                                 |
%            e  |                                 |  e
%            d  |                                 |  d
%            g  |                                 |  g
%            e  |                                 |  e
%               |                                 |
%            4  |                                 |  2
%               |                                 |
%               |                                 |
%               |                                 |
%               -----------------------------------
%        (0,  0)               edge 1              (380,  0)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%Labeling of the corners%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%       (0,380)               edge 3              (380,380)
%               -----------------------------------
%               |         |             |         |
%               |   CS34  |             |   CS23  |
%               |         |             |         |
%            e  |----------             ----------|  e
%            d  |                                 |  d
%            g  |                                 |  g
%            e  |                                 |  e
%               |  CS41E3                         |
%            4  |----------             ----------|  2
%               |         |             |         |
%               |   CS41  |             |   CS12  |
%               |         |             |         |
%               -----------------------------------
%        (0,  0)               edge 1              (380,  0)

%%%%%%%%%%%%%              CS: Corner Square               %%%%%%%%%%%%%%%%
%%%%%%%%%%% Labeling of the cornersquare : for instance, CS41E3 %%%%%%%%%%%
%%%%%%%%%%  the first 2 numbers refers to which edges its shares %%%%%%%%%%
%%%%%%%%% with the giant square, while the last one is the number %%%%%%%%%
%%%%%%%%%% label of its own edge following the rule of the giant %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%  square's edges labeling  %%%%%%%%%%%%%%%%%%%%%%%%%%

t_max = 100000;
l = 40;
epsilon = 1;

Centroid = zeros(t_max,2);
 
%Unecessary passages to achieve a complete unbias choice of the first
%position of the centroid 
random_x = rand;
while random_x == 0.5000
    random_x = rand;
end
random_y = rand;
while random_y == 0.5000
    random_y = rand;
end

%Choice of the centroid at time 1
Centroid(1,1) = 41;%round(380*random_x);
Centroid(1,2) = 42;%round(380*random_y);

for t = 2:t_max
    
    CS41E2 = 0;
    CS41E3 = 0;
    CS12E3 = 0;
    CS12E4 = 0;
    CS23E1 = 0;
    CS23E4 = 0;
    CS34E1 = 0;
    CS34E2 = 0;

    %Check that if the point is in the border of the square
    if mod(Centroid(t-1,1),380)*mod(Centroid(t-1,2),380) == 0

        %Check if the point-1 belongs to edge 1 or 4 (corners included)
        if Centroid(t-1,1)*Centroid(t-1,2) == 0

            %Check on the borders

            %Check if the point belongs to 0 x ]0,380[ (proper edge 4)
            if Centroid(t-1,1) == 0 && mod(Centroid(t-1,2),380) ~= 0

                %Check if the point is in the corner of the squares 41 or 34
                if Centroid(t-1,2) == l
                    CS41E3 = 1;
                elseif Centroid(t-1,2) == 380 - l
                    CS34E1 = 1;
                end

             [Centroid(t,1),Centroid(t,2)] = GoUpDownRight(Centroid(t-1,1), Centroid(t-1,2), epsilon, CS34E1, CS41E3);

            %Check if the point belongs to ]0,380[ x 0 (proper edge 1)
            elseif mod(Centroid(t-1,1),380) ~= 0 && Centroid(t-1,2) == 0

                %Check if the point is in the corner of the squares 41 or 12
                if Centroid(t-1,1) ~= l
                    CS41E2 = 1;
                elseif Centroid(t-1,1)  == 380-l
                    CS12E4 = 1;
                end

                [Centroid(t,1),Centroid(t,2)] = GoUpLeftRight(Centroid(t-1,1), Centroid(t-1,2), epsilon, CS41E2, CS12E4);

            %Check on the corners

            %Check if the point is the origin
            elseif Centroid(t-1,1) == 0 && Centroid(t-1,2) == 0
                [Centroid(t,1),Centroid(t,2)] = GoUpRight(Centroid(t-1,1), Centroid(t-1,2));
            
            %Check if the point is (0,380)
            elseif Centroid(t-1,1) == 0 && Centroid(t-1,2) == 380
                [Centroid(t,1),Centroid(t,2)] = GoDownRight(Centroid(t-1,1), Centroid(t-1,2));

            %Check if the point is (380,0)
            elseif Centroid(t-1,1) == 380 && Centroid(t-1,2) == 0
                [Centroid(t,1),Centroid(t,2)] = GoUpLeft(Centroid(t-1,1), Centroid(t-1,2));
            else
                printf('Ops! Error occur on the if of edges 1 or 4')
            end
        end

        %Check if the point belongs to edge 2 or 3 (corners escluded)
        if Centroid(t-1,1) == 380 || Centroid(t-1,2) == 380

            %Check on the borders

            %Check if the point belongs to 380 x ]0,380[ (proper edge 2)
            if Centroid(t-1,1) == 380 && mod(Centroid(t-1,2),380) ~= 0

                %Check if the point is in the corner of the squares 12 or 23
                if Centroid(t-1,2) == l
                    CS12E3 = 1;
                elseif Centroid(t-1,2) == 380 - l
                    CS23E1 = 1;
                end

                [Centroid(t,1),Centroid(t,2)] = GoUpDownLeft(Centroid(t-1,1), Centroid(t-1,2), epsilon, CS12E3, CS23E1);

            %Check if the point belongs to ]0,380[ x 380 (proper edge 3)
            elseif mod(Centroid(t-1,1),380) ~= 0 && Centroid(t-1,2) == 380

                %Check if the point is in the corner of the squares 23 or 34
                if Centroid(t-1,1) == l
                    CS34E2 = 1;
                elseif Centroid(t-1,1) == 380 - l
                    CS23E4 = 1;
                end

                [Centroid(t,1),Centroid(t,2)] = GoDownLeftRight(Centroid(t-1,1), Centroid(t-1,2), epsilon, CS34E2, CS23E4);

            %Check if the point is (380,380)
            elseif Centroid(t-1,1) == 380 && Centroid(t-1,2) == 380
                [Centroid(t,1),Centroid(t,2)] = GoDownLeft(Centroid(t-1,1),Centroid(t-1,2));

            %Check if the point is (0,380)
            %elseif Centroid(t-1,1) == 0 && Centroid(t-1,2) == 380
            %Already done in t-1he previous check on edge 1 and 3 

            %Check if the point is (380,0)
            %elseif Centroid(t-1,1) == 380 && Centroid(t-1,2) == 0
            %Already done in t-1he previous check on edge 1 and 3
                
            %else
            %    fprintf('Ops! Error occur on the if of edges 2 or 3')
            end
  
        end
    %If the point is NOT on the borders of the square, then it's free to
    %chose all 4 directions and can happened in the edges of one of the 4 
    % subsquare
    else 

        %Check if the point is in one of the edges of the 4 subsquare
        if Centroid(t-1,1) > 0 && Centroid(t-1,1) < l

            if Centroid(t-1,2) == l
                CS41E3 = 1;
            elseif Centroid(t-1,2) == 380 - l
                CS34E1 = 1;
            end

        elseif Centroid(t-1,1) == l

            if Centroid(t-1,2) > 0 && Centroid(t-1,2) < l
                CS41E2 = 1;
            elseif Centroid(t-1,2) == l
                CS41E2 = 1;
                CS41E3 = 1;
            elseif Centroid(t-1,2) == 380 - l
                CS34E1 = 1;
                CS34E2 = 1;
            elseif Centroid(t-1,2) > 380 - l && Centroid(t-1,2) < 380
                CS34E2 = 1;
            end

        elseif Centroid(t-1,1) == 380 - l
            
            if Centroid(t-1,2) > 0 && Centroid(t-1,2) < l
                CS12E4 = 1;
            elseif Centroid(t-1,2) == l
                CS12E4 = 1;
                CS12E3 = 1;
            elseif Centroid(t-1,2) == 380 - l
                CS23E1 = 1;
                CS23E4 = 1;
            elseif Centroid(t-1,2) > 380 - l && Centroid(t-1,2) < 380
                CS23E4 = 1;
            end

        elseif Centroid(t-1,1) > 380 - l && Centroid(t-1,1) < 380
            
            if Centroid(t-1,2) == l
                CS12E3 = 1;
            elseif Centroid(t-1,2) == 380 - l
                CS23E1 = 1;
            end
        end

        [Centroid(t,1),Centroid(t,2)] = Go4directions( Centroid(t-1,1), Centroid(t-1,2), epsilon, ...
                                                       CS41E2, CS41E3, CS12E3, CS12E4, CS23E1, CS23E4, CS34E2, CS34E1);
    end

end

plot(Centroid(:,1),Centroid(:,2),'b')
xlim([0 380])
ylim([0 380])