%% Make data from the RW model

%Choice of model one want to implement
Model_unrestricted_RW = true;
Model_classic         = false;
Model_wall_still      = true;
Model_wall_move       = true;
Model_corner          = false;
Model_real_data       = false;

%number of desired RW
number_of_RW = 100;
%sampling of RW
sampling     = 25;

addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Workspace\All_data');
load('data_processed_steps_average_1.mat', 'Cell', 'Cell_Steps_filtered', 'index_over_threshold_Cell_1', 'average_steps_cell1','average_steps_No_Cell1', 'filename_filtered','Initial_points', 'vector_of_bins', 'Cell_Steps','Cell_name_boolean','Cell_number_video','Cell_video_position');
%number of time steps EACH RW will have
number_of_time_steps = average_steps_cell1;

if Model_unrestricted_RW || Model_classic || Model_wall_still || Model_wall_move || Model_corner
    
    DataAll = struct();

    %Create the vector of initial points for each RW (each model will have the
    %same initial points), such initial points are imported from true data.
    %Random picks of the initial points from the experiments
    Initial_points = round(Initial_points);
    num_Picks = number_of_RW;
    indices = randi(length(Initial_points), 1, num_Picks);
    InitialPointRW = Initial_points(:,indices);

    clear indices num_Picks

    %Stilness probability (p_still = 0.2 is the unbias stillness, while p = 0
    % is the case when stillness is not considered among the acitons)
    p_still = 0:0.1:0.7;

    %Parameter that will be implemented if p = 0. It will devide 2 cases:
    % if stillness_occur = 0, it means that the cell will NEVER stop
    % if stillness_occur = 1, it means that the cell can have p_still ~= 0
    % along the walls
    stillness_occur = true;
end

if Model_real_data
    % molecules determines how manhy action is allow each step: 4 means I
    % have 4 direction to go, 6 means each direction is 60 degree to its
    % neighbor
    molecule = 4; %4 6;
    %Number of phases: 1 means everything is the same in the MSD of the RW,
    %while 2 means I have 2 regimes: superdiffusive and subdiffusive (accor-
    % ding to Jerison and Quake's paper).
    phases    = 1; %1 2;
end

if Model_unrestricted_RW

    DataAll.ClassicRWUnrestricted = struct();
    model                         = 0;

    for i = 1:number_of_RW
        [x, y] = RW_Unrestricted([0;0], sampling, number_of_time_steps,0);

        DataAll.ClassicRWUnrestricted.(['RW', num2str(i)]).x = x;
        DataAll.ClassicRWUnrestricted.(['RW', num2str(i)]).y = y;
    end
end

%The model of choice is the classical RW
if Model_classic

    DataAll.ClassicRW = struct();
    model             = 1;

    for i = 1:number_of_RW

        [x, y] = RW(InitialPointRW(:,i), sampling, number_of_time_steps, 0, stillness_occur, model, 0, 0);

        DataAll.ClassicRW.(['RW', num2str(i)]).x = x;
        DataAll.ClassicRW.(['RW', num2str(i)]).y = y;
    end

end




%The model of choice is Model 1 (read in "RW.m" the details of implementation)
if Model_wall_still
    for j = 1:length(p_still)
        DataAll.Model_wall_still.(['alpha',num2str(j)]) = struct();
        model = 2;

        for i = 1:number_of_RW

            [x, y] = RW(InitialPointRW(:,i), sampling, number_of_time_steps, p_still(j), stillness_occur, model, 0, 0);

            DataAll.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x = x;
            DataAll.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y = y;
        end
    end
end

%The model of choice is Model 2 (read in "RW.m" the details of implementation)
if Model_wall_move
    for j = 1:length(p_still)
        %DataAll.Model_wall_move.(['alpha_',num2str(j)]) = struct();
        model = 3;

        for i = 1:number_of_RW

            [x, y] = RW(InitialPointRW(:,i), sampling, number_of_time_steps, p_still(j), stillness_occur, model, 0, 0);

            DataAll.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x = x;
            DataAll.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y = y;
        end
    end
end

%The model of choice is Model with the corner (read in "RW.m" the details
%of implementation)
if Model_corner
    for j = 1:length(p_still)
        model = 4;

        %Bias in the corner parameters:
        % bias of the probability if the point is on one edge of the 4 corners.
        % 0 <= epsilon <= 1
        % 0 means completely unbias RW.
        % 1 means the cell is trapped in the corner and it will perfomed RW
        % without ever lived that corner
        epsilon_values = 0:0.2:1;

        % The four corners will have the same length
        % 1 <= corner_length < 190
        % need to implement the case of corner_length = 190
        corner_length_values = 90:30:150;

        for epsilon = epsilon_values
            for corner_length = corner_length_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                DataAll.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]) = struct();
            end
        end

        for epsilon = epsilon_values
            for corner_length = corner_length_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                for i = 1:number_of_RW

                    [x, y] = RW(InitialPointRW(:,i), sampling, number_of_time_steps, p_still(j), stillness_occur, model,corner_length, epsilon);

                    DataAll.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x = x;
                    DataAll.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y = y;
                end
            end
        end

    end
end

index_sampling = 0:sampling:(sampling*number_of_time_steps-1);
index_sampling = index_sampling + ones(1,number_of_time_steps);

Data = struct();

if Model_unrestricted_RW

    Data.ClassicRWUnrestricted = struct();

    for i = 1:number_of_RW

        Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x = DataAll.ClassicRWUnrestricted.(['RW', num2str(i)]).x(index_sampling);
        Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y = DataAll.ClassicRWUnrestricted.(['RW', num2str(i)]).y(index_sampling);
    end

end


if Model_classic

    Data.ClassicRW = struct();

    for i = 1:number_of_RW

        Data.ClassicRW.(['RW', num2str(i)]).x = DataAll.ClassicRW.(['RW', num2str(i)]).x(index_sampling);
        Data.ClassicRW.(['RW', num2str(i)]).y = DataAll.ClassicRW.(['RW', num2str(i)]).y(index_sampling);
    end

end


if Model_wall_still
    for j = 1:length(p_still)
        Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]) = struct();

        for i = 1:number_of_RW

            Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x = DataAll.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x(index_sampling);
            Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y = DataAll.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y(index_sampling);
        end
    end
end

if Model_wall_move
    for j = 1:length(p_still)
        Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]) = struct();

        for i = 1:number_of_RW

            Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x = DataAll.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x(index_sampling);
            Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y = DataAll.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y(index_sampling);
        end
    end
end

if Model_corner
    for j = 1:length(p_still)

        for epsilon = epsilon_values
            for corner_length = corner_length_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]) = struct();
            end
        end

        for epsilon = epsilon_values
            for corner_length = corner_length_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                for i = 1:number_of_RW

                    Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x = ...
                        DataAll.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x(index_sampling);
                    Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y = ...
                        DataAll.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y(index_sampling);
                end
            end
        end
    end
end

%Model 5
if Model_real_data

    Data.Model_real_data = struct();
    model                = 5;
    k = 1;

    addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\RW');
    [index_for_simulation, index_for_steps, Cell_Steps_for_simulation, filename_for_simulation] = choice_of_data_for_simulation();

    number_of_time_steps_real_data = [average_steps_cell1*ones(1,sum(index_for_steps==1)),average_steps_No_Cell1*ones(1,sum(index_for_steps==2))];

    for j = index_for_simulation
                
        theta = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta; 
        
        format short
        direction = zeros(1,molecule);

        %probability of directions
        if molecule == 4

            edges = [0, pi/4, 3*pi/4, 5*pi/4, 7*pi/4, 2*pi];

            for i = 1:length(theta)
                if ((edges(1) <= theta(i)) &&  (theta(i) <= edges(2))) || ((edges(end-1) < theta(i)) && (theta(i) <= edges(end)))
                    direction(1) = direction(1) + 1;
                elseif (edges(2) < theta(i)) &&  (theta(i) <= edges(3))
                    direction(2) = direction(2) + 1;
                elseif (edges(3) < theta(i)) &&  (theta(i) <= edges(4))
                    direction(3) = direction(3) + 1;
                else %(edges(4) < theta(i)) &&  (theta(i) <= edges(5))
                    direction(4) = direction(4) + 1;
                end
            end
        elseif molecule == 6

            edges = [0, pi/6, 3*pi/6, 5*pi/6, 7*pi/6, 9*pi/6, 11*pi/6, 2*pi];

            for i = 1:length(theta)
                if ((edges(1) <= theta(i)) &&  (theta(i) <= edges(2))) || ((edges(end-1) < theta(i)) && (theta(i) <= edges(end)))
                    direction(1) = direction(1) + 1;
                elseif (edges(2) < theta(i)) &&  (theta(i) <= edges(3))
                    direction(2) = direction(2) + 1;
                elseif (edges(3) < theta(i)) &&  (theta(i) <= edges(4))
                    direction(3) = direction(3) + 1;
                elseif (edges(4) < theta(i)) &&  (theta(i) <= edges(5))
                    direction(4) = direction(4) + 1;
                elseif (edges(5) < theta(i)) &&  (theta(i) <= edges(6))
                    direction(5) = direction(5) + 1;
                else %(edges(5) < theta(i)) &&  (theta(i) <= edges(6))
                    direction(6) = direction(6) + 1;
                end
            end 

        else %More options of molecules can be added
        return 
        end
        
        direction = direction/sum(direction);

        V = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).V;
        %Distribution of speeds in phases
        if phases == 1

            speed = zeros(2, length(vector_of_bins));
            [speed(1,:),speed(2,:)] = hist(V, vector_of_bins);

            speed(1,:) = speed(1,:)/sum(speed(1,:));

        elseif phases == 2
            speed = zeros(4, length(vector_of_bins));
            [speed(1,:),speed(2,:)] = hist( V(    1:(Cell_Steps(j)-expected_time_mitosis(j)-1)), vector_of_bins );
            [speed(3,:),speed(4,:)] = hist( V( (Cell_Steps(j)-expected_time_mitosis(j)):end   ), vector_of_bins );

            speed(1,:) = speed(1,:)/sum(speed(1,:));
            speed(3,:) = speed(3,:)/sum(speed(3,:));

        else %In case of the 3 phases possibility
            return
        end

        for i = 1:number_of_RW
            [x, y] = RW_real_data( direction, speed, number_of_time_steps_real_data(k) );

            Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x = x;
            Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y = y;
        end
        k = k + 1;
    end
end
%%
clear x y k i j model index_sampling V speed DataAll