%% gamma^* VS gamma^star

main_RW();

% get the MSD

addpath('C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Info_centroidi_da_Excel')

t = 1:1:number_of_time_steps-1;

if Model_unrestricted_RW
    for i = 1:number_of_RW

        Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD = Calculate_MSD( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, ...
                                                                             Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y );

    end
end

% Gamma * 1 and 2
gamma_asterisk = zeros(2,number_of_RW);

for i = 1:number_of_RW

    p = polyfit( log(t(  2:round(length(t)/2))), ...
                 log(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD(2:round(length(t)/2))), 1);
    gamma_asterisk(1,i) = p(1);
    %Data.ClassicRWUnrestricted.alpha_asterisk_1_distribution_MSD = exp(p(2));

    p = polyfit( log(t(  round(length(t)/2:end))), ...
                 log(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD(round(length(t)/2:end))), 1);
    gamma_asterisk(2,i) = p(1);
    %Data.ClassicRWUnrestricted.alpha_asterisk_2_distribution_MSD = exp(p(2));
    clear p;

end
gamma_asterisk_1 = sum(gamma_asterisk(1,:))/number_of_RW; 
gamma_asterisk_2 = sum(gamma_asterisk(2,:))/number_of_RW; 

%Gamma star 1 and 2
MSD = zeros(1, number_of_time_steps-1);

% Compute mean square displacement (MSD)
for k = 1:number_of_time_steps-1
    for i = 1:number_of_RW
        MSD(k) = MSD(k) + Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD(k);
    end
    MSD(k) = MSD(k) / number_of_RW;
end

% Filter zero MSD values
t(MSD == 0) = [];
vector_MSD_non_zero = MSD(MSD ~= 0);

% Fit the distribution into 2 sections
p = polyfit(log(t(1:round(length(t)/2))), log(vector_MSD_non_zero(1:round(length(t)/2))), 1);
Data.ClassicRWUnrestricted.gamma_star_1_distribution_MSD = p(1);
Data.ClassicRWUnrestricted.alpha_star_1_distribution_MSD = exp(p(2));

p = polyfit(log(t(round(length(t)/2):end)), log(vector_MSD_non_zero(round(length(t)/2):end)), 1);
Data.ClassicRWUnrestricted.gamma_star_2_distribution_MSD = p(1);
Data.ClassicRWUnrestricted.alpha_Star_2_distribution_MSD = exp(p(2));

diff_1 = Data.ClassicRWUnrestricted.gamma_star_1_distribution_MSD - gamma_asterisk_1;
diff_2 = Data.ClassicRWUnrestricted.gamma_star_2_distribution_MSD - gamma_asterisk_2;