function [Column1, Column2] = RW_real_data(p_directions, info_v, number_of_time_steps)

Centroid(1,1) = 0;
Centroid(1,2) = 0;

if length(info_v(:,1)) == 2 %phase = 1

    for t= 2:number_of_time_steps

        if length(p_directions) == 4

            [Centroid(t,1), Centroid(t,2)] = Go4Directions_real_data(Centroid(t-1,1), Centroid(t-1,2), p_directions,  info_v(1,:), info_v(2,:));
        
        elseif length(p_directions) == 6

            [Centroid(t,1), Centroid(t,2)] = Go6Directions_real_data(Centroid(t-1,1), Centroid(t-1,2), p_directions,  info_v(1,:), info_v(2,:));
        
        else %possible other options for directions

            return 
        end
    end

elseif length(info_v(:,1)) == 4 %phase = 2

    for t= 2:round(number_of_time_steps/2)

        if length(p_directions) == 4

            [Centroid(t,1), Centroid(t,2)] = Go4Directions_real_data(Centroid(t-1,1), Centroid(t-1,2), p_directions, info_v(1,:), info_v(2,:));
       
        elseif length(p_directions) == 6

            [Centroid(t,1), Centroid(t,2)] = Go6Directions_real_data(Centroid(t-1,1), Centroid(t-1,2), p_directions, info_v(1,:), info_v(2,:));
       
        else %possible other options for directions
            return
        end
    end

    for t= round(number_of_time_steps/2)+1:number_of_time_steps

        if length(p_directions) == 4
        
            [Centroid(t,1), Centroid(t,2)] = Go4Directions_real_data(Centroid(t-1,1), Centroid(t-1,2), p_directions, info_v(3,:), info_v(4,:));
       
        elseif length(p_directions) == 6
       
            [Centroid(t,1), Centroid(t,2)] = Go6Directions_real_data(Centroid(t-1,1), Centroid(t-1,2), p_directions, info_v(3,:), info_v(4,:));
      
        else %possible other options for directions
            return
        end
    end
else %possibity of other phases
    return
end

Column1 = Centroid(:,1);
Column2 = Centroid(:,2);