function One_big_plot_speed_RW(Data, model, i, j, p_still, abs_speed, interval, sampling, filename_for_simulation, molecule, phases, save_images)

if model == 0

    % Define the desired figure name and dimensions
    figureName = ['Speeds_unrestricted_RW_', num2str(i), '_sampling_', num2str(sampling)];
    figureWidth = 1200; % in pixels
    figureHeight = 800; % in pixels

    % Create the figure with the specified dimensions
    hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

    %Create the first subplot
    subplot(2, 2, 1);
    plot(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y, 'bo');
    hold on 
    plot(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x(1), Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y(1), 'r*');
    hold on 
    plot(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x(end), Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y(end), 'g*');    
    xlabel('X');
    ylabel('Y');

    % Create the second subplot
    subplot(2, 2, 2);
    histogram(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).V, interval);
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('V');
    grid on;

    % Create the third subplot
    subplot(2, 2, 3);
    if abs_speed
        histogram(abs(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vx), interval);
    else
        histogram(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vx, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vx');
    grid on;

    % Create the third subplot
    subplot(2, 2, 4);
    if abs_speed
        histogram(abs(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vy), interval);
    else
        histogram(Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vy, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vy');
    grid on;

    if abs_speed
        StrTitle = 'Speeds (abs) of RW n° ' ;
    else
        StrTitle = 'Speeds (no abs) of RW n° ' ;
    end

    StrTitle = [StrTitle, num2str(i),  ' Classic no restricted ', 'sampling: ', num2str(sampling)] ;
    % Add a title above all the subplots
    sgtitle(hFig, StrTitle);

    if save_images == 1

        if abs_speed
            % Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRWUnrestricted\speeds_One_big_plot\abs\',figureName,'.png']); % Save the figure as an image
        else
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRWUnrestricted\speeds_One_big_plot\no_abs\',figureName,'.png']); % Save the figure as an image
        end
    end
end

if model == 1
    % Define the desired figure name and dimensions
    figureName = ['Speeds_RW_', num2str(i), '_sampling_', num2str(sampling)];
    figureWidth = 1200; % in pixels
    figureHeight = 800; % in pixels

    % Create the figure with the specified dimensions
    hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

    %Create the first subplot
    subplot(2, 2, 1);
    plot(Data.ClassicRW.(['RW', num2str(i)]).x, Data.ClassicRW.(['RW', num2str(i)]).y, 'bo');
    hold on 
    plot(Data.ClassicRW.(['RW', num2str(i)]).x(1), Data.ClassicRW.(['RW', num2str(i)]).y(1), 'r*');
    hold on 
    plot(Data.ClassicRW.(['RW', num2str(i)]).x(end), Data.ClassicRW.(['RW', num2str(i)]).y(end), 'g*');
    xlabel('X');
    ylabel('Y');

    % Create the second subplot
    subplot(2, 2, 2);
    histogram(Data.ClassicRW.(['RW', num2str(i)]).V, interval);
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('V');
    grid on;

    % Create the third subplot
    subplot(2, 2, 3);
    if abs_speed
        histogram(abs(Data.ClassicRW.(['RW', num2str(i)]).Vx), interval);
    else
        histogram(Data.ClassicRW.(['RW', num2str(i)]).Vx, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vx');
    grid on;

    % Create the third subplot
    subplot(2, 2, 4);
    if abs_speed
        histogram(abs(Data.ClassicRW.(['RW', num2str(i)]).Vy), interval);
    else
        histogram(Data.ClassicRW.(['RW', num2str(i)]).Vy, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vy');
    grid on;

    if abs_speed
        StrTitle = 'Speeds (abs) of RW n° ' ;
    else
        StrTitle = 'Speeds (no abs) of RW n° ' ;
    end

    StrTitle = [StrTitle, num2str(i),  ' Classic ', 'sampling: ', num2str(sampling)] ;
    % Add a title above all the subplots
    sgtitle(hFig, StrTitle);

    if save_images == 1

        if abs_speed
            % Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRW\speeds_One_big_plot\abs\',figureName,'.png']); % Save the figure as an image
        else
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRW\speeds_One_big_plot\no_abs\',figureName,'.png']); % Save the figure as an image
        end
    end
end
if model == 2
        % Define the desired figure name and dimensions
    figureName = ['Speeds_stillness_RW_', num2str(i), '_alpha_',num2str(p_still),'_sampling_', num2str(sampling)];
    figureWidth = 1200; % in pixels
    figureHeight = 800; % in pixels

    % Create the figure with the specified dimensions
    hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

    %Create the first subplot
    subplot(2, 2, 1);
    plot(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, 'bo');
    hold on 
    plot(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x(1), Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y(1), 'r*');
    hold on 
    plot(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x(end), Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y(end), 'g*');
    xlabel('X');
    ylabel('Y');

    % Create the second subplot
    subplot(2, 2, 2);
    histogram(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).V, interval);
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('V');
    grid on;

    % Create the third subplot
    subplot(2, 2, 3);
    if abs_speed
        histogram(abs(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx), interval);
    else
        histogram(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vx');
    grid on;

    % Create the third subplot
    subplot(2, 2, 4);
    if abs_speed
        histogram(abs(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy), interval);
    else
        histogram(Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vy');
    grid on;

    if abs_speed
        StrTitle = 'Speeds (abs) of RW n° ' ;
    else
        StrTitle = 'Speeds (no abs) of RW n° ' ;
    end

    StrTitle = [StrTitle, num2str(i),  ' stillness wall, alpha = ',num2str(p_still) ,' sampling: ', num2str(sampling)] ;
    % Add a title above all the subplots
    sgtitle(hFig, StrTitle);

    if save_images == 1

        if abs_speed
            % Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_still\speeds_One_big_plot\abs\',figureName,'.png']); % Save the figure as an image
        else
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_still\speeds_One_big_plot\no_abs\',figureName,'.png']); % Save the figure as an image
        end
    end
end
if model == 3
      % Define the desired figure name and dimensions
    figureName = ['Speeds_moving_RW_', num2str(i), '_alpha_',num2str(p_still),'_sampling_', num2str(sampling)];
    figureWidth = 1200; % in pixels
    figureHeight = 800; % in pixels

    % Create the figure with the specified dimensions
    hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

    %Create the first subplot
    subplot(2, 2, 1);
    plot(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, 'bo');
    hold on 
    plot(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x(1), Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y(1), 'r*');
    hold on 
    plot(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x(end), Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y(end), 'g*');
    xlabel('X');
    ylabel('Y');

    % Create the second subplot
    subplot(2, 2, 2);
    histogram(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).V, interval);
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('V');
    grid on;

    % Create the third subplot
    subplot(2, 2, 3);
    if abs_speed
        histogram(abs(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx), interval);
    else
        histogram(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vx');
    grid on;

    % Create the third subplot
    subplot(2, 2, 4);
    if abs_speed
        histogram(abs(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy), interval);
    else
        histogram(Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vy');
    grid on;

    if abs_speed
        StrTitle = 'Speeds (abs) of RW n° ' ;
    else
        StrTitle = 'Speeds (no abs) of RW n° ' ;
    end

    StrTitle = [StrTitle, num2str(i),  ' moving wall, alpha = ',num2str(p_still) ,' sampling: ', num2str(sampling)] ;
    % Add a title above all the subplots
    sgtitle(hFig, StrTitle);

    if save_images == 1

        if abs_speed
            % Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_move\speeds_One_big_plot\abs\',figureName,'.png']); % Save the figure as an image
        else
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_move\speeds_One_big_plot\no_abs\',figureName,'.png']); % Save the figure as an image
        end
    end

end
if model == 4

end

if model == 5

    % Define the desired figure name and dimensions
    figureName = ['Speeds simulation ', num2str(i), ' molecule =  ', num2str(molecule),' phase(s) = ',num2str(phases), ' ', filename_for_simulation];
    figureWidth = 1200; % in pixels
    figureHeight = 800; % in pixels

    % Create the figure with the specified dimensions
    hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

    %Create the first subplot
    subplot(2, 2, 1);
    plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x, Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y, 'bo');
    hold on 
    plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x(1), Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y(1), 'r*');
    hold on
    plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x(end), Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y(end), 'g*');
    xlabel('X');
    ylabel('Y');

    % Create the second subplot
    subplot(2, 2, 2);
    histogram(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).V, interval);
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('V');
    grid on;

    % Create the third subplot
    subplot(2, 2, 3);
    if abs_speed
        histogram(abs(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).Vx), interval);
    else
        histogram(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).Vx, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vx');
    grid on;

    % Create the third subplot
    subplot(2, 2, 4);
    if abs_speed
        histogram(abs(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).Vy), interval);
    else
        histogram(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).Vy, interval);
    end
    %ylim([0 700]);
    ylabel("frequency");
    xlabel('Vy');
    grid on;

    if abs_speed
        StrTitle = 'Speeds (abs) of simulation n° ' ;
    else
        StrTitle = 'Speeds (no abs) of simulation n° ' ;
    end

    StrTitle = [StrTitle, num2str(i), ' molecule =  ', num2str(molecule),' phase(s) = ',num2str(phases), ' ', filename_for_simulation] ;
    % Add a title above all the subplots
    sgtitle(hFig, StrTitle);

    if save_images == 1
        % Saving the figure
        saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_real_data\',figureName,'.png']); % Save the figure as an image
    end
end
