function One_big_plot_RW(Data, model, index_for_simulation, filename_for_simulation, i, file, interval, save_images, molecule, phases)

if model==0
elseif model == 1
elseif model == 2
elseif model == 3
elseif model == 4
elseif model == 5

    if phases == 2
        mitosis_time = length(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).dMSD_mitosis);
    end

    % Define the desired figure name and dimensions
    figureName = ['Simulation of ', filename_for_simulation, ' RW n° ', num2str(i)];
    figureWidth = 1200; % in pixels
    figureHeight = 800; % in pixels

    % Create the figure with the specified dimensions
    hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
    
    %first subplot
    subplot(2, 2, 1);

    if phases == 1
        plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x, Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y, 'bo');
    elseif phases == 2
        plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x(1:end-mitosis_time), Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y(1:end-mitosis_time), 'bo');
        hold on
        plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x(end-mitosis_time+1:end), Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y(end-mitosis_time+1:end), 'ro');
    else %other phases possibilities
    end
    hold on 
    plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x(1), Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y(1), 'r*');
    hold on
    plot(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).x(end), Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).y(end), 'g*');
    xlabel('X');
    ylabel('Y');

    % Create the second subplot
    subplot(2, 2, 2);
    if phases == 1
        histogram(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).V, interval);
    %ylim([0 700]);

    elseif phases == 2
        histogram(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).V(1:end-mitosis_time), interval);
    else %other phases possibilites
    end
    ylabel("frequency");
    xlabel('V');
    grid on;

    % Create the third subplot
    subplot(2, 2, 3);
    if phases == 1
        loglog(2:1:length(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD),Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD(2:end), 'bo');
    elseif phases == 2
        loglog(2:1:length(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD(1:end-mitosis_time)),Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD(2:end-mitosis_time), 'bo');
        hold on
        loglog( length(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD(1:end-mitosis_time)):1:length(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD), ...
                Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).MSD(end-mitosis_time:end), 'ro');
    else %
    end
    xlabel('t');
    ylabel('MSD');

    if phases == 2
        % Create the fourth subplot
        subplot(2, 2, 4);
        histogram(Data.Model_real_data.(filename_for_simulation).(['RW', num2str(i)]).V(end-mitosis_time+1:end), interval);
        ylabel("frequency");
        xlabel('V');
        grid on;
    end
    StrTitle = ['RW', num2str(i), ' molecule =  ', num2str(molecule),' phase(s) = ',num2str(phases), ' ', filename_for_simulation] ;
    % Add a title above all the subplots
    sgtitle(hFig, StrTitle);

    if save_images == 1
        % Saving the figure
        saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_real_data\',figureName,'.png']); % Save the figure as an image
    end
end