function [cX, cY] = GoUpLeftRight(x, y, p_still, stillness_occur, model, epsilon, CS41E2, CS12E4)

% The cell is on edge 1, so it can only have 3+1 options: 
% go up
% go left
% go right
% stay still

%model classic RW 
if model == 0 || model == 1
    if p_still + stillness_occur == 0
        P_up    = 0.3333;
        P_left  = 0.3333;
        P_right = 0.3333;
       %P_still = 0;
    else
        P_up    = 0.25;
        P_left  = 0.25;
        P_right = 0.25;
       %P_still = 0.25;
    end
end

%model stillness on wall
if model == 2
    if p_still + stillness_occur == 0
    P_up    = 0.2500;
    P_left  = 0.3750;
    P_right = 0.3750;
   %P_still = 0;
    else
    P_up    = 0.25*(1-p_still);
    P_left  = 0.25*(1-p_still);
    P_right = 0.25*(1-p_still);
    %P_still = p_still + 0.25*(1-p_still);    
    end
end

%model moving along the wall
if model == 3
    if p_still + stillness_occur == 0
    P_up    = 0.3333*(1-p_still);
    P_left  = 0.5000*(1-p_still);
    P_right = 0.5000*(1-p_still);
    %P_still = 0;  
    else
    P_up    = 0.2500*(1-p_still);
    P_left  = 0.3750*(1-p_still);
    P_right = 0.3750*(1-p_still);
    %P_still = p_still;    
    end

end

%model 4 corners
if model == 4
    if p_still + stillness_occur == 0
        P_up    = 0.3333 + 0.1111*epsilon;
        P_left  = 0.3333*(1+0.3333*epsilon*CS41E2 - epsilon*CS12E4);
        P_right = 0.3333*(1+0.3333*epsilon*CS12E4 - epsilon*CS41E2);
       %P_still = 0;
    else
        P_up    = 0.3125*(1-p_still)*(1+0.3333*epsilon);
        P_left  = 0.3125*(1-p_still)*(1+0.3333*epsilon*CS41E2 - epsilon*CS12E4);
        P_right = 0.3125*(1-p_still)*(1+0.3333*epsilon*CS12E4 - epsilon*CS41E2);
       %P_still = p_still + 0.625*(1-p_still)*(1+1.667*epsilon);
    end
end


random_variable = rand;

% 3 values are escluded from the pool to have fair probabilities (for the unbias DTRW the value are 1/4, 2/4 and 3/4)
while random_variable == P_up || random_variable == P_up + P_left || random_variable == P_up + P_left + P_right
    random_variable = rand;
end

if random_variable < P_up

    %going up
    cX = x;
    cY = y + 1;

elseif random_variable > P_up && random_variable < P_up + P_left

    %going left
    cX = x - 1;
    cY = y;

elseif random_variable > P_up + P_left && random_variable < P_up + P_left + P_right

    %going right
    cX = x + 1;
    cY = y;

elseif random_variable > P_up + P_left + P_right

    %stay still
    cX = x;
    cY = y;
    
end