function [cX, cY] = GoUpLeft(x,y, p_still, stillness_occur, model)

% The cell is in (380, 0), so it can only have 2+1 options: 
% go up
% go left
% stay still

%model classic RW
if model == 0 || model == 1

    if p_still == 0
        if stillness_occur
            P_up    = 0.3333;
            P_left  = 0.3333;
           %P_still = 0.3333;
        end
    else
        P_up    = 0.5000;
        P_left  = 0.5000;
       %P_still = 0;
    end

%model stillness on wall  
elseif model == 2

    if p_still == 0
        if stillness_occur
            P_up    = 0.25*(1 - p_still);
            P_left  = 0.25*(1 - p_still);
           %P_still = 0.50*(1 + p_still);
        end
    else
        P_up    = 0.5000;
        P_left  = 0.5000;
       %P_still = 0;
    end
%model moving along the wall
elseif model == 3

    if p_still == 0
        if stillness_occur
            P_up    = 0.50*(1 - p_still);
            P_left  = 0.50*(1 - p_still);
           %P_still = p_still;
        end
    else
        P_up    = 0.5000;
        P_left  = 0.5000;
       %P_still = 0;
    end
%model 4 corners
elseif model == 4

    P_up    = 0.3333;
    P_left  = 0.3333;
   %P_still = 0.3333;
end

random_variable = rand;

% 1/3 and 2/3 are escluded from the pool to have fair probabilities
while random_variable == P_up || random_variable == P_up + P_left
    random_variable = rand;
end

if random_variable < P_up

    %going up
    cX = x;
    cY = y + 1;

elseif random_variable >  P_up && random_variable < P_up + P_left

    %going left
    cX = x - 1;
    cY = y;
    
else %random_varialbe > P_up + P_left

    %stay still
    cX = x;
    cY = y;
    
end