function [cX, cY] = GoUpDownLeft(x, y, p_still, stillness_occur, model, epsilon, CS12E3, CS23E1)

% The cell is on edge 2, so it can only have 3+1 options: 
% go up
% go down
% go left
% stay still

%model classic RW 
if model == 0 || model == 1
    if p_still + stillness_occur == 0
        P_up    = 0.3333;
        P_down  = 0.3333;
        P_left  = 0.3333;
       %P_still = 0;
    else
        P_up    = 0.25;
        P_down  = 0.25;
        P_left  = 0.25;
       %P_still = 0.25;
    end
end

%model stillness on wall
if model == 2
    if p_still + stillness_occur == 0
    P_up    = 0.3750;
    P_down  = 0.3750;
    P_left  = 0.2500;
   %P_still = 0;
    else
    P_up    = 0.25*(1-p_still);
    P_down  = 0.25*(1-p_still);
    P_left  = 0.25*(1-p_still);
   %P_still = p_still + 0.25*(1-p_still);    
    end
end

%model moving along the wall
if model == 3
    if p_still + stillness_occur == 0
    P_up    = 0.3750;
    P_down  = 0.3750;
    P_left  = 0.2500;
   %P_still = 0;  
    else
    P_up    = 0.3750*(1-p_still);
    P_down  = 0.3750*(1-p_still);
    P_left  = 0.2500*(1-p_still);
   %P_still = p_still;    
    end

end

%model 4 corners
if model == 4
    if p_still + stillness_occur == 0
        P_up    = 0.3333*(1+0.3333*epsilon*CS23E1 - epsilon*CS12E3);
        P_down  = 0.3333*(1+0.3333*epsilon*CS12E3 - epsilon*CS23E1);
        P_left  = 0.3333 + 0.1111*epsilon;
       %P_still = 0;
    else
        P_up    = 0.3125*(1-p_still)*(1+0.3333*epsilon*CS23E1 - epsilon*CS12E3);
        P_down  = 0.3125*(1-p_still)*(1+0.3333*epsilon*CS12E3 - epsilon*CS23E1);
        P_left  = 0.3125*(1-p_still)*(1+0.3333*epsilon);
       %P_still = p_still + 0.625*(1-p_still)*(1+1.667*epsilon);
    end
end

random_variable = rand;

% 3 values are escluded from the pool to have fair probabilities (for the unbias DTRW the value are 1/4, 2/4 and 3/4)
while random_variable == P_up || random_variable == P_up + P_down || random_variable == P_up + P_down + P_left
    random_variable = rand;
end

if random_variable < P_up

    %going up
    cX = x;
    cY = y + 1;

elseif random_variable > P_up && random_variable < P_up + P_down

    %going down
    cX = x;
    cY = y - 1;

elseif random_variable > P_up + P_down && random_variable < P_up + P_down + P_left

    %going left
    cX = x - 1;
    cY = y;

elseif random_variable > P_up + P_down + P_left

    %stay still
    cX = x;
    cY = y;
    
end