function [cX, cY] = GoDownRight(x,y, p_still, stillness_occur, model)

% The cell is in (0, 380), so it can only have 2+1 options: 
% go down
% go right
% stay still

%model classic RW
if model == 0 || model == 1

    if p_still == 0
        if stillness_occur
            P_down  = 0.3333;
            P_right = 0.3333;
           %P_still = 0.3333;
        end
    else
        P_down  = 0.5000;
        P_right = 0.5000;
       %P_still = 0;
    end

%model stillness on walls
elseif model == 2

    if p_still == 0
        if stillness_occur
            P_down  = 0.25*(1 - p_still);
            P_right = 0.25*(1 - p_still);
           %P_still = 0.50*(1 + p_still);
        end
    else
        P_down  = 0.5000;
        P_right = 0.5000;
       %P_still = 0;
    end
%model moving along the walls
elseif model == 3

    if p_still == 0
        if stillness_occur
            P_down  = 0.50*(1 - p_still);
            P_right = 0.50*(1 - p_still);
           %P_still = p_still;
        end
    else
        P_down  = 0.5000;
        P_right = 0.5000;
       %P_still = 0;
    end
%model 4 corners
elseif model == 4

    P_down  = 0.3333;
    P_right = 0.3333;
   %P_still = 0.3333;
end

random_variable = rand;

% 1/3 and 2/3 are escluded from the pool to have fair probabilities
while random_variable == P_down || random_variable == P_down + P_right
    random_variable = rand;
end

if random_variable < P_down

    %going down
    cX = x;
    cY = y - 1;

elseif random_variable > P_down && random_variable < P_down + P_right

    %going right
    cX = x + 1;
    cY = y ;
    
else %random_varialbe >  P_down + P_right

    %stay still
    cX = x;
    cY = y;
    
end