function [cX, cY] = Go4directions(x, y, p_still, stillness_occur, model, epsilon, CS41E2, CS41E3, CS12E3, CS12E4, CS23E1, CS23E4, CS34E2, CS34E1)

% The cell is inside the square, so it can only have 4+1 options: 
% go up
% go down
% go left
% go right
% stay still

%model classic RW, stillness on wall and movement on wall
if model == 0 || model == 1 || model == 2 || model == 3

    P_move = 0.25*(1-p_still);

    P_up    = P_move;
    P_down  = P_move;
    P_left  = P_move;
    P_right = P_move;
   %P_still = p_still;

end

%model of the 4 corners
if model == 4

    epsilon12 = 1; CP12 = 0;
    epsilon23 = 1; CP23 = 0;
    epsilon34 = 1; CP34 = 0;
    epsilon41 = 1; CP41 = 0;

    if CS41E2 == 1 &&  CS41E3 == 1

        if p_still+stillness_occur == 0
            epsilon41 = 3/2;
        else
            epsilon41 = 4/3;
        end
        CP41 = 1;
    end

    if CS12E3 == 1 &&  CS12E4 == 1

        if p_still+stillness_occur == 0
            epsilon12 = 3/2;
        else
            epsilon12 = 4/3;
        end
        CP12 = 1;
    end

    if CS23E1 == 1 &&  CS23E4 == 1

        if p_still+stillness_occur == 0
            epsilon23 = 3/2;
        else
            epsilon23 = 4/3;
        end
        CP23 = 1;
    end

    if CS34E1 == 1 &&  CS34E2 == 1

        if p_still+stillness_occur == 0
            epsilon34 = 3/2;
        else
            epsilon34 = 4/3;
        end
        CP34 = 1;
    end

if p_still+stillness_occur == 0
    P_move = 0.25;
    P_remaining = 0.3333;
else
    P_move = 0.25*(1-p_still);
    P_remaining = 0.25;
end

 P_up    = P_move*( 1 + P_remaining*epsilon*epsilon12*epsilon23*epsilon34*epsilon41*(CS41E2*(1-CP41) + CS12E4*(1-CP12) + CS23E1 + CS23E4 + CS34E1 + CS34E2) - epsilon*(CS41E3 + CS12E3) );
 P_down  = P_move*( 1 + P_remaining*epsilon*epsilon12*epsilon23*epsilon34*epsilon41*(CS41E2 + CS41E3 + CS12E3 + CS12E4 + CS23E4*(1-CP23) + CS34E2*(1-CP34)) - epsilon*(CS23E1 + CS34E1) );
 P_left  = P_move*( 1 + P_remaining*epsilon*epsilon12*epsilon23*epsilon34*epsilon41*(CS41E2 + CS41E3 + CS12E3*(1-CP12) + CS23E1*(1-CP23) + CS34E1 + CS34E2) - epsilon*(CS12E4 + CS23E4) );
 P_right = P_move*( 1 + P_remaining*epsilon*epsilon12*epsilon23*epsilon34*epsilon41*(CS41E3*(1-CP41) + CS12E3 + CS12E4 + CS23E1 + CS23E4 + CS34E1*(1-CP34)) - epsilon*(CS41E2 + CS34E2) );
%P_still = p_still + P_move*P_remaining*epsilon*epsilon12*epsilon23*epsilon34*epsilon41*(CS41E2 + CS41E3 + CS12E3 + CS12E4 + CS23E1 + CS23E4 + CS34E1 + CS34E2);

end

random_variable = rand;

% 4 values are escluded from the pool to have fair probabilities (for the unbias DTRW the value are 1/5, 2/5, 3/5 and 4/5)
excluded_values = [P_up, P_up + P_down, P_up + P_down + P_left, P_up + P_down + P_left + P_right];

while ismember(random_variable, excluded_values)
    random_variable = rand;
end


% % 4 values are escluded from the pool to have fair probabilities (for the unbias DTRW the value are 1/5, 2/5, 3/5 and 4/5)
% while random_variable == P_up || random_variable == P_up + P_down || random_variable == P_up + P_down + P_left || random_variable == P_up + P_down + P_left + P_right
%     random_variable = rand;
% end

if random_variable < P_up

    %going up
    cX = x;
    cY = y + 1;

elseif (random_variable > P_up) && (random_variable <  P_up + P_down)

    %going down
    cX = x;
    cY = y - 1;

elseif (random_variable >  P_up + P_down) && (random_variable < P_up + P_down + P_left)

    %going left
    cX = x - 1;
    cY = y;

elseif (random_variable > P_up + P_down + P_left) && (random_variable < P_up + P_down + P_left + P_right)

    %going right
    cX = x + 1;
    cY = y;

elseif (random_variable > P_up + P_down + P_left + P_right)

    %stay still
    cX = x;
    cY = y;

end