function [cX,cY] = Go4Directions_real_data(x,y, p_directions, p_v, v)

% The cell is inside the square, so it can only have 4+1 options: 
% go East
% go North
% go West
% go South
% stay still (if the length of the speed is zero)

excluded_values_directions = zeros(1, length(p_directions));

for j = 1:length(p_directions)
    excluded_values_directions = excluded_values_directions + [zeros(1, j-1), p_directions(j)*ones(1,(length(p_directions)-(j-1)))];
end

random_variable_directions = rand;
while ismember(random_variable_directions, excluded_values_directions)
    random_variable_directions = rand;
end

a = find(excluded_values_directions > random_variable_directions);
index_directions = a(1);

excluded_values_speed = zeros(1, length(p_v));

for j = 1:length(p_v)
    excluded_values_speed = excluded_values_speed + [zeros(1, j-1), p_v(j)*ones(1,(length(p_v)-(j-1)))];
end

random_variable_v = rand;
while ismember(random_variable_v, excluded_values_speed)
    random_variable_v = rand;
end

a = find(excluded_values_speed > random_variable_v);
index_speed = a(1);

%go East
if index_directions == 1
    cX = x + v(index_speed);
    cY = y;
end

%go North
if index_directions == 2
    cX = x;
    cY = y + v(index_speed);
end
 
%go West
if index_directions == 3
    cX = x - v(index_speed);
    cY = y;
end

%go South
if index_directions == 4
    cX = x;
    cY = y - v(index_speed);
end
 







