%% Make data from the DTRW model

addpath('C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\T_cells\DTRW')

Data = struct();

%number of desired DTRW
number_of_RW = 35;

%Bias in the corner parameters: 
%
% bias of the probability if the point is on one edge of the 4 corners.
% 0 <= epsilon <= 1 
% 0 means completely unbias DTRW.
% 1 means the cell is trapped in the corner and it will perfomed DTRW
% without ever lived that corner
epsilon_values = 0:0.25:1;
%
% The four corners will have the same length 
% 1 <= corner_length < 190
% need to implement the case of corner_length = 190
corner_length_values = 120:30:180;

%number of time steps EACH DTRW will have
number_of_time_steps = 10000;

for corner_length = corner_length_values
    for epsilon = epsilon_values
        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
        for i = 1:number_of_RW
            [x, y] = DTRW(number_of_time_steps, corner_length, epsilon);
            Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x = x;
            Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y = y;
        end
    end
end


%% clear unnecessary values
clear epsilon corner_length epsilon_str i x y

%% Statistics 
addpath('C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\T_cells\Codici_Matlab\Info_centroidi_da_Excel')

% Acquisition of statistics: 1 means will acquire, 0 will not
A_MD  = 0;
A_MSD = 1;
A_V   = 0;
A_Vx  = 0;
A_Vy  = 0;
% Acquisition of Vx or Vy with only the modulus
A_V_abs = 1;


%% Acquisition of the features MD and/or MSD
%boolean needed:
%A_MD
%A_MSD

if A_MD && A_MSD 

    for i= 1:number_of_RW

        for corner_length = corner_length_values
            for epsilon = epsilon_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                for i = 1:number_of_RW

                    [Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MD, ...
                     Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD] = Calculate_MD_MSD( Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                                                                                                        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

                end
            end
        end
    end
else
    if A_MD
        for i= 1:number_of_RW

            for corner_length = corner_length_values
                for epsilon = epsilon_values
                    epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                    for i = 1:number_of_RW

                        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD = Calculate_MD( Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                                                                                                      Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

                    end
                end
            end
        end
   
    elseif A_MSD % Acquisition of only MSD
        for corner_length = corner_length_values
            for epsilon = epsilon_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                for i = 1:number_of_RW

                    Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD = Calculate_MSD( Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                                                                                                   Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

                end
            end
        end
    else %otherwise
    end
end


%% Acquisition of the features Vx and/or Vy or V+Vx+Vy
%Boolean needed:
%A_Vx
%A_Vy
%A_V

if A_V 

    for i= 1:number_of_RW

       [ Data.(['RW',num2str(i)]).Vx, ...
         Data.(['RW',num2str(i)]).Vy, ...
         Data.(['RW',num2str(i)]).V   ] = Calculate_V( Data.(['RW',num2str(i)]).x, Data.(['RW',num2str(i)]).y, A_V_abs );
    end

else
    if A_Vx || A_Vy
        if A_Vx
            for i= 1:number_of_RW

                Data.(['RW',num2str(i)]).Vx = Calculate_Vx( Data.(['RW',num2str(i)]).x, Data.(['RW',num2str(i)]).y, A_V_abs);
            end
        end
        if A_Vy % Acquisition of only Vy
            for i= 1:number_of_RW

                Data.(['RW',num2str(i)]).Vy = Calculate_Vy( Data.(['RW',num2str(i)]).x, Data.(['RW',num2str(i)]).y, A_V_abs);
            end
        end
    end
end

%% Clear unnecessary values
clear A_V_abs A_V A_Vx A_Vy A_MD A_MSD corner_length epsilon_str epsilon i 

%% plot of the first DTRW for each set of parameters


DTRW_data = struct();

for corner_length = corner_length_values
    for epsilon = epsilon_values

        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'

        %Copy the MSD we want to plot and collecting how many 0s we have
        % k is the count for the shift of index we need
        k = 0;
    
        index_MSD_zero = zeros(1,number_of_time_steps);

        t = 1:1:number_of_time_steps;

        for j = 1:number_of_time_steps

            if Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).MSD(j) == 0
                index_MSD_zero(j) = j;
                t(j) = [];
                k = k+1;
            else
                single_vector_MSD_non_zero(j-k) = Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).MSD(j);
            end
        end

        DTRW_data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).MSD_cleared = single_vector_MSD_non_zero;
        DTRW_data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).t_cleared   = t;
        clear single_vector_MSD_non_zero;
    end
end

%% Cleaning unnecessary variables
clear colours_plots corner_length epsilon epsilon_str i j k t
%% Plot of them in a single window

colours_plots = rand(length(epsilon_values), 3);
legendString = cell(1, length(epsilon_values));

i = 1;

for corner_length = corner_length_values
    figure(i)
    hold on
    
    for j = 1:length(epsilon_values)
        epsilon = epsilon_values(j);
        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'

        loglog( DTRW_data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).t_cleared, ...
                DTRW_data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).MSD_cleared, ...
               'Color', colours_plots(j,:), 'LineWidth', 2);

        epsilon_str = strrep(num2str(epsilon), '_', '.'); % Replace '_' with '.'
        legendString{j} = ['epsilon= ', epsilon_str];
    end

    titleString = ['Length ', num2str(corner_length)];
    title(titleString)
    xlabel('time')
    ylabel('MSD')
    legend(legendString)

    hold off
    
    i = i + 1;
end

%%
clear corner_length epsilon epsilon_str i j legendString random_color titleString 


%% plot of the distribution mean of the MSD with the t

%colours_plots = rand(length(epsilon_values), 3);

f = 1;

for corner_length = corner_length_values

    figure(f);
    hold on;
    
    legendString = cell(1, length(epsilon_values)); % Initialize legendString for each corner_length
    
    for j_epsilon = 1:length(epsilon_values)

        epsilon = epsilon_values(j_epsilon);
        MSD = zeros(1, number_of_time_steps);
        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
        
        % Compute mean square displacement (MSD)
        for k = 1:number_of_time_steps
            for i = 1:number_of_RW
                MSD(k) = MSD(k) + Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD(k);
            end
            MSD(k) = MSD(k) / number_of_RW;
        end

        % Filter zero MSD values
        t = 1:number_of_time_steps;
        t(MSD == 0) = [];
        vector_MSD_non_zero = MSD(MSD ~= 0);

        % Plot MSD
        legendString{j_epsilon} = ['epsilon = ', strrep(num2str(epsilon), '_', '.')]; % Update legendString
        loglog(t, vector_MSD_non_zero, 'Color', colours_plots(j_epsilon,:), 'LineWidth', 2);
        
        % Fit the distribution into 2 sections
        p = polyfit(log(t(1:round(length(t)/2))), log(vector_MSD_non_zero(1:round(length(t)/2))), 1);
        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).gamma1_distribution_MSD = p(1);
        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).alpha1_distribution_MSD = exp(p(2));


        p = polyfit(log(t(round(length(t)/2):end)), log(vector_MSD_non_zero(round(length(t)/2):end)), 1);
        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).gamma2_distribution_MSD = p(1);
        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).alpha2_distribution_MSD = exp(p(2));
    end
    
    % Set title, labels, and legend
    title(['Length ', num2str(corner_length)]);
    xlabel('time');
    ylabel('MSD');
    legend(legendString, 'Location', 'Best');
    
    hold off;
    
    f = f + 1;
end


% %% find the biggest MSD (useless??)
% % finding the biggest MSD 
% MSD_max = 0;
% 
% for i = 1:number_of_RW
%     for j= 1:number_of_time_steps
%         if MSD_max < Data.(['RW',num2str(i)]).MSD(j)
%             MSD_max = Data.(['RW',num2str(i)]).MSD(j);
%         end
%     end
% end

