%% Make data from the RW model
addpath('C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\RW')

main_RW();

%% clear unnecessary values
clear epsilon corner_length epsilon_str x y i j model

%% Statistics 

addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Info_centroidi_da_Excel')

% Acquisition of statistics: 1 means will acquire, 0 will not
A_MD  = 0;
A_MSD = 1;
A_V   = 1;
A_Vx  = 1;
A_Vy  = 1;
% Acquisition of Vx or Vy with only the modulus
A_V_abs = 0;


%% Acquisition of the features MD and/or MSD
%boolean needed:
%A_MD
%A_MSD

if A_MD && A_MSD

    if Model_unrestricted_RW
        for i = 1:number_of_RW

            [Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MD, ...
             Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD] = Calculate_MD_MSD( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, ...
                                                                                      Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y );

        end
    end
    if Model_classic
        for i = 1:number_of_RW

            [Data.ClassicRW.(['RW', num2str(i)]).MD, ...
             Data.ClassicRW.(['RW', num2str(i)]).MSD] = Calculate_MD_MSD( Data.ClassicRW.(['RW', num2str(i)]).x, ...
                                                                          Data.ClassicRW.(['RW', num2str(i)]).y );

        end
    end

    if Model_wall_still

        for j = 1:length(p_still)
            for i = 1:number_of_RW

                [Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).MD, ...
                 Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).MSD] =  ...
                    ...
                                       Calculate_MD_MSD( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                         Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

            end
        end
    end

        if Model_wall_move
        
            for j = 1:length(p_still)
                for i = 1:number_of_RW

                    [Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).MD, ...
                     Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).MSD] =  ...
                        ...
                                          Calculate_MD_MSD( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                            Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

                end
            end
        end

    if Model_corner

        for corner_length = corner_length_values
            for epsilon = epsilon_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                for i = 1:number_of_RW

                    [Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MD, ...
                     Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD] = ...
                     ... 
                                     Calculate_MD_MSD( Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                       Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

                end
            end
        end
    end

    if Model_real_data

        for k = 1:length(index_for_simulation)
            for i = 1:number_of_RW

                [Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).MD, ...
                 Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).MSD] = Calculate_MD_MSD( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                                   Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y );

            end
        end
    end

else
    if A_MD
        
      if Model_unrestricted_RW
        for i = 1:number_of_RW

            Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MD = Calculate_MD( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, ...
                                                                               Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y );

        end
      end

      if Model_classic
        for i = 1:number_of_RW

            Data.ClassicRW.(['RW', num2str(i)]).MD = Calculate_MD( Data.ClassicRW.(['RW', num2str(i)]).x, ...
                                                                   Data.ClassicRW.(['RW', num2str(i)]).y );

        end
      end

      if Model_wall_still
          for j = 1:length(p_still)
              for i = 1:number_of_RW

                  Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).MD = ...
                   ....
                                       Calculate_MD( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                     Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

              end
          end
      end

        if Model_wall_move
            for j = 1:length(p_still)
                for i = 1:number_of_RW

               Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).MD = ...
                 ....
                                      Calculate_MD( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                    Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

                end
            end
        end

      if Model_corner

            for corner_length = corner_length_values
                for epsilon = epsilon_values
                    epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                    for i = 1:number_of_RW

                        Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MD = Calculate_MD( Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                                                                                                                                         Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

                    end
                end
            end
      end

    if Model_real_data
        
       for k = 1:length(index_for_simulation)
            for i = 1:number_of_RW

                Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).MD = Calculate_MD( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                            Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y );

            end
        end
    end   

    elseif A_MSD % Acquisition of only MSD

       if Model_unrestricted_RW
        for i = 1:number_of_RW

            Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD = Calculate_MSD( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, ...
                                                                                 Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y );

        end
       end

       if Model_classic
        for i = 1:number_of_RW

            Data.ClassicRW.(['RW', num2str(i)]).MSD = Calculate_MSD( Data.ClassicRW.(['RW', num2str(i)]).x, ...
                                                                     Data.ClassicRW.(['RW', num2str(i)]).y );

        end
      end

      if Model_wall_still
          for j = 1:length(p_still)
              for i = 1:number_of_RW

                  Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).MSD = ...
                   ....
                                       Calculate_MSD( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                      Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

              end
          end
      end

        if Model_wall_move
            for j = 1:length(p_still)
                for i = 1:number_of_RW

               Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).MSD = ...
                 ....
                                      Calculate_MSD( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                     Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

                end
            end
        end

        if Model_corner
            for corner_length = corner_length_values
                for epsilon = epsilon_values
                    epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                    for i = 1:number_of_RW

                    Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD = ...
                        ...
                                      Calculate_MSD( Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                     Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

                    end
                end
            end
        end

    if Model_real_data
        
        for k = 1:length(index_for_simulation)
            for i = 1:number_of_RW

                Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).MSD = Calculate_MSD( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                              Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y );

            end
        end
    end         
    else %otherwise
    end
end



%% Acquisition of the features Vx and/or Vy or V+Vx+Vy
%Boolean needed:
%A_Vx
%A_Vy
%A_V

if A_V
    if Model_unrestricted_RW
        for i= 1:number_of_RW

            [ Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vx, ...
              Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vy, ...
              Data.ClassicRWUnrestricted.(['RW', num2str(i)]).V   ] = Calculate_V( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y, A_V_abs );
        end
    end

    if Model_classic
        for i= 1:number_of_RW

            [ Data.ClassicRW.(['RW', num2str(i)]).Vx, ...
              Data.ClassicRW.(['RW', num2str(i)]).Vy, ...
              Data.ClassicRW.(['RW', num2str(i)]).V   ] = Calculate_V( Data.ClassicRW.(['RW', num2str(i)]).x, Data.ClassicRW.(['RW', num2str(i)]).y, A_V_abs );
        end
    end

    if Model_wall_still
        for j = 1:length(p_still)
            for i= 1:number_of_RW

            [ Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx, ...
              Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy, ...
              Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).V   ] =  ...
              ...
                                     Calculate_V( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                  Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, A_V_abs );
            end
        end
    end

    if Model_wall_move
        for j = 1:length(p_still)
            for i= 1:number_of_RW

               [ Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx, ...
                 Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy, ...
                 Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).V   ] =  ...
                ...
                                     Calculate_V( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                  Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, A_V_abs );
            end
        end
    end

    if Model_corner

        for corner_length = corner_length_values
            for epsilon = epsilon_values
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                for i = 1:number_of_RW

                    [Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).Vx, ...
                     Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).Vy, ...
                     Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).V ] = ...
                        ...
                        Calculate_V( Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                     Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y, ...
                                     A_V_abs);

                end
            end
        end
    end

    if Model_real_data
        
        for k = 1:length(index_for_simulation)
            for i = 1:number_of_RW

               [ Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).Vx, ...
                 Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).Vy, ...
                 Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).V   ] = Calculate_V( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                               Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y, ...
                                                                                                               A_V_abs);

            end
        end
    end 
else
    if A_Vx || A_Vy

        if A_Vx

            if Model_unrestricted_RW
                for i= 1:number_of_RW

                    Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vx = Calculate_Vx( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, ...
                                                                                       Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y, ...
                                                                                       A_V_abs );

                end
            end

            if Model_classic
                for i= 1:number_of_RW

                    Data.ClassicRW.(['RW', num2str(i)]).Vx = Calculate_Vx( Data.ClassicRW.(['RW', num2str(i)]).x, ...
                                                                           Data.ClassicRW.(['RW', num2str(i)]).y, ...
                                                                           A_V_abs );

                end
            end

            if Model_wall_still

                for j =1:length(p_still)
                    for i= 1:number_of_RW

                      Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx = Calculate_Vx( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                                                                           Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, ...
                                                                                                           A_V_abs );
    
                    end
                end

            end

            if Model_wall_move

                for j =1:length(p_still)
                    for i= 1:number_of_RW

                      Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx = Calculate_Vx( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                                                                          Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, ...
                                                                                                          A_V_abs );
    
                    end
                end
                
            end

            if Model_corner

                for corner_length = corner_length_values
                    for epsilon = epsilon_values
                        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                        for i = 1:number_of_RW

                            Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).Vx = ...
                                ...
                                               Calculate_Vx(  Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                              Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y, ...
                                                               A_V_abs);

                        end
                    end
                end
            end

            if Model_real_data

                for k = 1:length(index_for_simulation)
                    for i = 1:number_of_RW

                        Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).Vx = Calculate_Vx( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                                    Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y, ...
                                                                                                                    A_V_abs);

                    end
                end
            end

        end

        if A_Vy % Acquisition of only Vy

            %model classic unrestricted
            if Model_unrestricted_RW
                for i= 1:number_of_RW

                    Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vy = Calculate_Vy( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y, A_V_abs );

                end
            end
            
            % Model classic
            if Model_classic
                for i= 1:number_of_RW

                    Data.ClassicRW.(['RW', num2str(i)]).Vy = Calculate_Vy( Data.ClassicRW.(['RW', num2str(i)]).x, Data.ClassicRW.(['RW', num2str(i)]).y, A_V_abs );

                end
            end

            if Model_wall_still

                for j =1:length(p_still)
                    for i= 1:number_of_RW

                      Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy = Calculate_Vy( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                                                                           Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, ...
                                                                                                           A_V_abs );
    
                    end
                end

            end

            if Model_wall_move

                for j =1:length(p_still)
                    for i= 1:number_of_RW

                      Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy = Calculate_Vy( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                                                                                          Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y, ...
                                                                                                          A_V_abs );
    
                    end
                end
                
            end
            if Model_corner

                for corner_length = corner_length_values
                    for epsilon = epsilon_values
                        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
                        for i = 1:number_of_RW

                            Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).Vy = ...
                                ...
                                               Calculate_Vy(  Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                                              Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y, ...
                                                               A_V_abs);

                        end
                    end
                end
            end

            if Model_real_data

                for k = 1:length(index_for_simulation)
                    for i = 1:number_of_RW

                        Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).Vy = Calculate_Vy( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                                    Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y, ...
                                                                                                                    A_V_abs);
  
                    end
                end
            end
        end
    end
end
%% Calculus of the dMSD 
addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Analysis_of_statistics')

if Model_unrestricted_RW
    for i = 1:number_of_RW

        Data.ClassicRWUnrestricted.(['RW', num2str(i)]).dMSD = Calculate_dMSD( Data.ClassicRWUnrestricted.(['RW', num2str(i)]).x, ...
                                                                               Data.ClassicRWUnrestricted.(['RW', num2str(i)]).y );

    end
end

if Model_classic
    for i = 1:number_of_RW

        Data.ClassicRW.(['RW', num2str(i)]).dMSD = Calculate_dMSD( Data.ClassicRW.(['RW', num2str(i)]).x, ...
                                                                   Data.ClassicRW.(['RW', num2str(i)]).y );

    end
end

if Model_wall_still
    for j = 1:length(p_still)
        for i = 1:number_of_RW

            Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).dMSD = ...
                ....
                Calculate_dMSD( Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

        end
    end
end

if Model_wall_move
    for j = 1:length(p_still)
        for i = 1:number_of_RW

            Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).dMSD = ...
                ....
                Calculate_dMSD( Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).x, ...
                                Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).y );

        end
    end
end

if Model_corner
    for corner_length = corner_length_values
        for epsilon = epsilon_values
            epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'
            for i = 1:number_of_RW

                Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).dMSD = ...
                    ...
                    Calculate_dMSD( Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).x, ...
                                    Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).y );

            end
        end
    end
end
if Model_real_data
    if phases == 1
    for k = 1:length(index_for_simulation)
        for i = 1:number_of_RW

            Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).dMSD = Calculate_dMSD( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                            Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y );

        end
    end
    elseif phases == 2
        %starting_point_mitosis = Cell_Steps - expected_time_mitosis';
        for k = 1:length(index_for_simulation) 
            for i = 1:number_of_RW

                Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).dMSD = Calculate_dMSD( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x, ...
                                                                                                                Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y);
                Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).dMSD_mitosis = Calculate_dMSD( Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).x(number_of_time_steps_real_data(k)-expected_time_mitosis(index_for_simulation(k)):end), ...
                                                                                                                        Data.Model_real_data.([filename_for_simulation{k}]).(['RW', num2str(i)]).y(number_of_time_steps_real_data(k)-expected_time_mitosis(index_for_simulation(k)):end) );
                

            end
        end
    end
end

%% Clear unnecessary values
clear corner_length epsilon_str epsilon i k

%% Model_classic with no restriction: Plot of MSDs in a single window for the Classic RW unrestricted
plot_single = 1;
plot_mean   = 0;
save_images = 0;
t = 1:1:number_of_time_steps-1;
%Number of single RW to show
NumRWsingle = round(number_of_RW/5);

if Model_unrestricted_RW

    if plot_single == 1 %plot single MSDs   


        colours_plots = rand(NumRWsingle, 3);
        legendString = cell(1, length(NumRWsingle));
        figureName = [num2str(NumRWsingle),' classic RWs '];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

        for i = 1:NumRWsingle
            loglog(t, Data.ClassicRWUnrestricted.(['RW', num2str(i)]).MSD, ...
                  'Color', colours_plots(i,:), 'LineWidth', 2);
            legendString{i} = ['RW n° ', num2str(i)];

            hold on

        end

        %title(titleString)
        xlabel('time')
        ylabel('MSD')
        legend(legendString)

        hold off
        % Add a title above all the subplots
        sgtitle(hFig, [num2str(NumRWsingle), ' classic RW with sampling = ', num2str(sampling)]);
        strTitle = [num2str(NumRWsingle), ' classic RW with sampling = ', num2str(sampling)];
        %Example: Saving the figure
        saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRWUnrestricted\', strTitle,'.png']); % Save the figure as an image
    end

    % plot of the distribution mean of the MSD with the t
    if plot_mean == 1
        %colours_plots = rand(length(epsilon_values), 3);
        figureName = ['Mean distribution of MSD with n = ', num2str(number_of_RW), ', classic RW, sampling = ', num2str(sampling)];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
        

                dMSD = zeros(1, number_of_time_steps-1);

                % Compute mean square displacement (MSD)
                for k = 1:number_of_time_steps-1
                    for i = 1:number_of_RW
                        dMSD(k) = dMSD(k) + Data.ClassicRWUnrestricted.(['RW', num2str(i)]).dMSD(k);
                    end
                    dMSD(k) = dMSD(k) / number_of_RW;
                end

                % Plot MSD
                loglog(t(2:end), dMSD(2:end), 'LineWidth', 2);
                hold on 
                % Fit the distribution into 2 sections
                p = polyfit(log(t(2:end)), log(dMSD(2:end)), 1);
                Data.ClassicRWUnrestricted.gamma1_distribution_dMSD = p(1);
                Data.ClassicRWUnrestricted.alpha1_distribution_dMSD = exp(p(2));
                y = exp(p(2)).*t.^p(1);
                loglog(t(2:end),y(2:end),'r')

                p = polyfit(log(t(round(length(t)/2):end)), log(dMSD(round(length(t)/2):end)), 1);
                Data.ClassicRWUnrestricted.gamma2_distribution_dMSD = p(1);
                Data.ClassicRWUnrestricted.alpha2_distribution_dMSD = exp(p(2));


            % Set title, labels, and legend
            figureName = [figureName, ' \gamma = ', num2str(Data.ClassicRWUnrestricted.gamma1_distribution_dMSD)];
            title(figureName);
            xlabel('time');
            ylabel('<MSD>');
            figureName = ['Mean distribution of MSD with n = ', num2str(number_of_RW), ', classic RW, sampling = ', num2str(sampling)];
            if save_images == 1
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRWUnrestricted\', figureName,'.png']); % Save the figure as an image
            end

    end
end

%% Model_classic: Plot of MSDs in a single window for the Classic RW
plot_single = 1;
plot_mean   = 0;
save_images = 1;

t = 1:1:number_of_time_steps-1;
%Number of single RW to show
NumRWsingle = round(number_of_RW/5);

if Model_classic

    if plot_single == 1 %plot single MSDs   \

        colours_plots = rand(NumRWsingle, 3);
        legendString = cell(1, length(NumRWsingle));
        figureName = [num2str(NumRWsingle),' classic RWs '];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);


        for i = 1:NumRWsingle
            loglog(t(2:end), Data.ClassicRW.(['RW', num2str(i)]).MSD(2:end), ...
                  'Color', colours_plots(i,:), 'LineWidth', 2);
            legendString{i} = ['RW n° ', num2str(i)];
            hold on

        end

        %title(titleString)
        xlabel('time')
        ylabel('MSD')
        legend(legendString, 'Location', 'northwest')

        hold off
        % Add a title above all the subplots
        sgtitle(hFig, [num2str(NumRWsingle), ' classic RW with sampling = ', num2str(sampling)]);
        strTitle = [num2str(NumRWsingle), ' classic RW with sampling = ', num2str(sampling)];
        %Example: Saving the figure
        saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRW\', strTitle,'.png']); % Save the figure as an image
    end

    % plot of the distribution mean of the MSD with the t
    if plot_mean == 1
        %colours_plots = rand(length(epsilon_values), 3);
        figureName = ['Mean distribution of MSD with n = ', num2str(number_of_RW), ', classic RW, sampling = ', num2str(sampling)];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
 
                dMSD = zeros(1, number_of_time_steps-1);

                % Compute mean square displacement (MSD)
                for k = 1:number_of_time_steps-1
                    for i = 1:number_of_RW
                        dMSD(k) = dMSD(k) + Data.ClassicRW.(['RW', num2str(i)]).dMSD(k);
                    end
                    dMSD(k) = dMSD(k) / number_of_RW;
                end


                % Plot MSD
                loglog(t(2:end), dMSD(2:end), 'LineWidth', 2);

                % Fit the distribution into 2 sections
                p = polyfit(log(t(2:round(length(t)/2))), log(dMSD(2:round(length(t)/2))), 1);
                Data.ClassicRW.gamma1_distribution_dMSD = p(1);
                Data.ClassicRW.alpha1_distribution_dMSD = exp(p(2));


                p = polyfit(log(t(round(length(t)/2):end)), log(dMSD(round(length(t)/2):end)), 1);
                Data.ClassicRW.gamma2_distribution_dMSD = p(1);
                Data.ClassicRW.alpha2_distribution_dMSD = exp(p(2));


            % Set title, labels, and legend
            figureName = [figureName, ', \gamma_1 = ', num2str(Data.ClassicRW.gamma1_distribution_dMSD)];
            title(figureName);
            xlabel('time');
            ylabel('<MSD>');
            figureName = ['Mean distribution of MSD with n = ', num2str(number_of_RW), ', classic RW, sampling = ', num2str(sampling)];
            if save_images == 1
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRW\', figureName,'.png']); % Save the figure as an image
            end

    end
end


%% Model_wall_still: Plot of MSDs in a single window 

plot_single = 0;
plot_mean   = 1;
save_images = 1;

t = 1:1:number_of_time_steps-1;
%Number of single RW to show
NumRWsingle = round(number_of_RW/5);

if Model_wall_still

     %plot of some single RW with fixed parameters
    if plot_single == 1
        % 
        % for i = 1:length(p_still)
        %     for ii= 1:NumRWsingle %da togliere
        %         index_MSD_zero = zeros(1,number_of_time_steps);
        %         k = 0;
        %         t = 1:1:number_of_time_steps-1;
        %         for j = 1:number_of_time_steps-1
        % 
        %             if Data.Model_wall_still.(['alpha',num2str(i)]).(['RW', num2str(ii)]).MSD(j) == 0
        %                 index_MSD_zero(j) = j;
        %                 t(j) = [];
        %                 k = k+1;
        %             else
        %                 single_vector_MSD_non_zero(j-k) = Data.Model_wall_still.(['alpha',num2str(i)]).(['RW', num2str(ii)]).MSD(j);
        %             end
        %         end
        % 
        %         DTRW_data.Model_wall_still.(['alpha',num2str(i)]).(['RW', num2str(ii)]).MSD_cleared = single_vector_MSD_non_zero;
        %         DTRW_data.Model_wall_still.(['alpha',num2str(i)]).(['RW', num2str(ii)]).t_cleared   = t;
        %         clear single_vector_MSD_non_zero;
        %     end
        % end

        colours_plots = rand(NumRWsingle*length(p_still), 3);
        legendString  = cell(1, NumRWsingle);

        c = 1;

        for i = 1:length(p_still)

            figureName   = ['RW Model wall still, alpha = ', num2str(p_still(i))];
            figureWidth  = 1200; % in pixels
            figureHeight = 800; % in pixels
            hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
            

            for ii= 1:NumRWsingle

                loglog( t(2:end), Data.Model_wall_still.(['alpha',num2str(i)]).(['RW', num2str(ii)]).MSD(2:end), ...
                        'Color', colours_plots(c,:), 'LineWidth', 2);

                legendString{ii} = ['RW n° ', num2str(ii)];
                c = c+1;
                hold on
            end

            titleString = ['RW Model wall still, \alpha = ', num2str(p_still(i))];
            title(titleString)
            xlabel('time')
            ylabel('MSD')
            legend(legendString, 'Location', 'northwest')

            hold off
            if save_images == 1
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_still\', figureName,'.png']); % Save the figure as an image
            end

        end
    end

    % plot of the distribution mean of the MSD with the t
    if plot_mean == 1

        colours_plots = rand(length(p_still), 3);
        legendString  = cell(1, length(p_still));
        j_alpha = 1;

        figureName   = ['RW Model wall still mean distribution with ', num2str(length(p_still)), ' different alphas, sampling = ', num2str(sampling)];
        figureWidth  = 1200; % in pixels
        figureHeight = 800; % in pixels
        hFig         = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
        hold on

        for i = 1:length(p_still)

                dMSD = zeros(1, number_of_time_steps-1);
                % Compute mean square displacement (MSD)
                for k = 1:number_of_time_steps-1
                    for ii = 1:number_of_RW
                        dMSD(k) = dMSD(k) + Data.Model_wall_still.(['alpha',num2str(i)]).(['RW', num2str(ii)]).dMSD(k);
                    end
                    dMSD(k) = dMSD(k) / number_of_RW;
                end

                % Plot MSD
                legendString{j_alpha} = ['\alpha = ', num2str(p_still(i))]; % Update legendString
                
                loglog(t(2:end), dMSD(2:end), 'Color', colours_plots(j_alpha,:), 'LineWidth', 2);

                j_alpha = j_alpha + 1;

                % Fit the distribution into 2 sections
                p = polyfit(log(t(2:end)), log(dMSD(2:end)), 1);
                Data.Model_wall_still.(['alpha',num2str(i)]).gamma1_distribution_dMSD = p(1);
                Data.Model_wall_still.(['alpha',num2str(i)]).alpha1_distribution_dMSD = exp(p(2));

                %p = polyfit(log(t(round(length(t)/2):end)), log(dMSD(round(length(t)/2):end)), 1);
                %Data.Model_wall_still.(['alpha',num2str(i)]).gamma2_distribution_dMSD = p(1);
                %Data.Model_wall_still.(['alpha',num2str(i)]).alpha2_distribution_dMSD = exp(p(2));
        end

        % Set title, labels, and legend
        title(figureName);
        xlabel('time');
        ylabel('<MSD>');
        legend(legendString, 'Location', 'Best');
        hold off;

        figureName = ['RW_still_mean_distributionsSampling', num2str(sampling)];
        if save_images == 1
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_still\', figureName,'.png']); % Save the figure as an image
        end

    end
end

%% Model_wall_move: Plot of MSDs in a single window 

plot_single = 0;
plot_mean   = 1;
save_images = 1;

t = 1:1:number_of_time_steps-1;
%Number of single RW to show
NumRWsingle = round(number_of_RW/5);

if Model_wall_move

     %plot of some single RW with fixed parameters
    if plot_single == 1

        colours_plots = rand(NumRWsingle*length(p_still), 3);
        legendString  = cell(1, NumRWsingle);

        c = 1;

        for i = 1:length(p_still)

            figureName   = ['RW Model wall still, alpha = ', num2str(p_still(i))];
            figureWidth  = 1200; % in pixels
            figureHeight = 800; % in pixels
            hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

            for ii= 1:NumRWsingle

                loglog( t(2:end), Data.Model_wall_move.(['alpha',num2str(i)]).(['RW', num2str(ii)]).MSD(2:end), ...
                        'Color', colours_plots(c,:), 'LineWidth', 2);

                legendString{ii} = ['RW n° ', num2str(ii)];
                c = c+1;
                hold on
            end

            titleString = ['RW Model wall still, \alpha = ', num2str(p_still(i))];
            title(titleString)
            xlabel('time')
            ylabel('MSD')
            legend(legendString, 'Location', 'Best')

            hold off
            if save_images == 1
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_move\', figureName,'.png']); % Save the figure as an image
            end

        end
    end

    % plot of the distribution mean of the MSD with the t
    if plot_mean == 1

        colours_plots = rand(length(p_still), 3);
        legendString  = cell(1, length(p_still));
        j_alpha = 1;

        figureName   = ['RW Model wall still mean distribution with ', num2str(length(p_still)), ' different alphas, sampling = ', num2str(sampling)];
        figureWidth  = 1200; % in pixels
        figureHeight = 800; % in pixels
        hFig         = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
        hold on

        for i = 1:length(p_still)

                dMSD = zeros(1, number_of_time_steps-1);
                % Compute mean square displacement (MSD)
                for k = 1:number_of_time_steps-1
                    for ii = 1:number_of_RW
                        dMSD(k) = dMSD(k) + Data.Model_wall_move.(['alpha',num2str(i)]).(['RW', num2str(ii)]).dMSD(k);
                    end
                    dMSD(k) = dMSD(k) / number_of_RW;
                end

                % Plot MSD
                legendString{j_alpha} = ['\alpha = ', num2str(p_still(i))]; % Update legendString
                
                loglog(t(2:end), dMSD(2:end), 'Color', colours_plots(j_alpha,:), 'LineWidth', 2);

                j_alpha = j_alpha + 1;
                    
                % Fit the distribution into 2 sections
                p = polyfit(log(t(2:end)), log(dMSD(2:end)), 1);
                Data.Model_wall_move.(['alpha',num2str(i)]).gamma1_distribution_dMSD = p(1);
                Data.Model_wall_move.(['alpha',num2str(i)]).alpha1_distribution_dMSD = exp(p(2));

                %p = polyfit(log(t(round(length(t)/2):end)), log(dMSD(round(length(t)/2):end)), 1);
                %Data.Model_wall_move.(['alpha',num2str(i)]).gamma2_distribution_dMSD = p(1);
                %Data.Model_wall_move.(['alpha',num2str(i)]).alpha2_distribution_dMSD = exp(p(2));
        end

        % Set title, labels, and legend
        title(figureName);
        xlabel('time');
        ylabel('<MSD>');
        legend(legendString, 'Location', 'Best');
        hold off;

        figureName = ['RW_still_mean_distributionsSampling', num2str(sampling)];
        if save_images == 1
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_move\', figureName,'.png']); % Save the figure as an image
        end

    end
end



%% Model_corner: plot of the first RW for each set of parameters 

if Model_corner
t = 1:1:number_of_time_steps-1;

 %plot of some single RW with fixed parameters
    if plot_single == 1
        colours_plots = rand(length(epsilon_values), 3);
        legendString = cell(1, length(epsilon_values));

        i = 1;

        for corner_length = corner_length_values
            figure(i)
            hold on

            for j = 1:length(epsilon_values)
                epsilon = epsilon_values(j);
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'

                loglog( Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).t, ...
                        Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(1)]).MSD, ...
                        'Color', colours_plots(j,:), 'LineWidth', 2);

                epsilon_str = strrep(num2str(epsilon), '_', '.'); % Replace '_' with '.'
                legendString{j} = ['epsilon= ', epsilon_str];
            end

            titleString = ['Length ', num2str(corner_length)];
            title(titleString)
            xlabel('time')
            ylabel('MSD')
            legend(legendString)

            hold off

            i = i + 1;
        end
    end



    % plot of the distribution mean of the MSD with the t
    if plot_mean == 1
        %colours_plots = rand(length(epsilon_values), 3);

        f = 1;


        for corner_length = corner_length_values

            figure(f);
            hold on;

            legendString = cell(1, length(epsilon_values)); % Initialize legendString for each corner_length

            for j_epsilon = 1:length(epsilon_values)

                epsilon = epsilon_values(j_epsilon);
                dMSD = zeros(1, number_of_time_steps-1);
                epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'

                % Compute mean square displacement (MSD)
                for k = 1:number_of_time_steps
                    for i = 1:number_of_RW
                        dMSD(k) = dMSD(k) + Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).dMSD(k);
                    end
                    dMSD(k) = dMSD(k) / number_of_RW;
                end

                % Plot MSD
                legendString{j_epsilon} = ['epsilon = ', strrep(num2str(epsilon), '_', '.')]; % Update legendString
                loglog(t, dMSD, 'Color', colours_plots(j_epsilon,:), 'LineWidth', 2);

                % Fit the distribution into 2 sections
                p = polyfit(log(t(1:round(length(t)/2))), log(dMSD(1:round(length(t)/2))), 1);
                Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).gamma1_distribution_dMSD = p(1);
                Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).alpha1_distribution_dMSD = exp(p(2));


                p = polyfit(log(t(round(length(t)/2):end)), log(dMSD(round(length(t)/2):end)), 1);
                Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).gamma2_distribution_dMSD = p(1);
                Data.Model_corner.(['alpha',num2str(j)]).(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).alpha2_distribution_dMSD = exp(p(2));
            end

            % Set title, labels, and legend
            title(['Length ', num2str(corner_length)]);
            xlabel('time');
            ylabel('<MSD>');
            legend(legendString, 'Location', 'Best');

            hold off;

            f = f + 1;
        end


        % %% find the biggest MSD (useless??)
        % % finding the biggest MSD
        % MSD_max = 0;
        %
        % for i = 1:number_of_RW
        %     for j= 1:number_of_time_steps
        %         if MSD_max < Data.(['RW',num2str(i)]).MSD(j)
        %             MSD_max = Data.(['RW',num2str(i)]).MSD(j);
        %         end
        %     end
        % end
    end

end

%% Model_real_data: Plot of MSDs 
plot_single = 1;
plot_mean   = 0;
save_images = 1;


%Number of single RW to show
NumRWsingle = round(number_of_RW/5);

if Model_real_data

    for file = 1:length(index_for_simulation)

        t = 1:1:number_of_time_steps_real_data(file)-1;

        if plot_single == 1 %plot single MSDs

            colours_plots = rand(NumRWsingle, 3);
            legendString = cell(1, length(NumRWsingle));
            figureName = [num2str(NumRWsingle),' classic RWs '];
            figureWidth = 1200; % in pixels
            figureHeight = 800; % in pixels
            hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

            for i = 1:NumRWsingle
                loglog( t, Data.Model_real_data.([filename_for_simulation{file}]).(['RW', num2str(i)]).MSD, ...
                       'Color', colours_plots(i,:), 'LineWidth', 2);
                legendString{i} = ['RW n° ', num2str(i)];

                hold on

            end

            %title(titleString)
            xlabel('time')
            ylabel('MSD')
            legend(legendString)

            hold off
            % Add a title above all the subplots
            sgtitle(hFig, [num2str(NumRWsingle), ' simulations with ',num2str(molecule),' molecule and ',num2str(phases), ' phase(s). Sample from ',filename_for_simulation{file}]);
            strTitle = [num2str(NumRWsingle), ' simulations with ',num2str(molecule),' molecule and ',num2str(phases), ' phase(s). Sample from ',filename_for_simulation{file}];
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_real_data\', strTitle,'.png']); % Save the figure as an image
        end

        % plot of the distribution mean of the MSD with the t
        if plot_mean == 1
            %colours_plots = rand(length(epsilon_values), 3);
            figureName = ['Mean distribution of MSD with n = ', num2str(number_of_RW), ', simulations with ',num2str(molecule),' molecule and ',num2str(phases), 'phase(s). Sample from ',filename_for_simulation{file}];
            figureWidth = 1200; % in pixels
            figureHeight = 800; % in pixels
            hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);
            

            dMSD = zeros(1, number_of_time_steps_real_data(file)-1);

            % Compute mean square displacement (MSD)
            for k = 1:number_of_time_steps_real_data(file)-1
                for i = 1:number_of_RW
                    dMSD(k) = dMSD(k) + Data.Model_real_data.([filename_for_simulation{file}]).(['RW', num2str(i)]).dMSD(k);
                end
                dMSD(k) = dMSD(k) / number_of_RW;
            end

            % Plot MSD
            loglog(t, dMSD, 'LineWidth', 2);
            hold on
            if phases == 1
            p = polyfit(log(t(2:end)), log(dMSD(2:end)), 1);
            Data.Model_real_data.([filename_for_simulation{file}]).gamma_distribution_dMSD = p(1);
            Data.Model_real_data.([filename_for_simulation{file}]).alpha_distribution_dMSD = exp(p(2));  
            %y = exp(p(2)).*t.^p(1);
            %loglog(t,y,'r--');
            elseif phases == 2
            % Compute mean square displacement during mitosis (MSD)
            dMSD_mitosis = zeros(1, expected_time_mitosis(index_for_simulation(file))-1);

            for k = 1:length(dMSD_mitosis)
                for i = 1:number_of_RW
                    dMSD_mitosis(k) = dMSD_mitosis(k) + Data.Model_real_data.([filename_for_simulation{file}]).(['RW', num2str(i)]).dMSD_mitosis(k);
                end
                dMSD_mitosis(k) = dMSD_mitosis(k) / number_of_RW;
            end

            % Fit the distribution into 2 sections
            p = polyfit(log(t(2:(number_of_time_steps_real_data(file)-expected_time_mitosis(index_for_simulation(file))-1))), log(dMSD(2:(number_of_time_steps_real_data(file)-expected_time_mitosis(index_for_simulation(file))-1))), 1);
            Data.Model_real_data.([filename_for_simulation{file}]).gamma1_distribution_dMSD = p(1);
            Data.Model_real_data.([filename_for_simulation{file}]).alpha1_distribution_dMSD = exp(p(2));

            p = polyfit(log(t(2:expected_time_mitosis(index_for_simulation(file))-1)), log(dMSD_mitosis(2:end)), 1);
            Data.Model_real_data.([filename_for_simulation{file}]).gamma2_distribution_dMSD = p(1);
            Data.Model_real_data.([filename_for_simulation{file}]).alpha2_distribution_dMSD = exp(p(2));
            end
           
            % Set title, labels, and legend
            if phases == 1
            figureName = [figureName, ', \gamma = ', num2str(Data.Model_real_data.([filename_for_simulation{file}]).gamma_distribution_dMSD)];                
            elseif phases == 2
            figureName = [figureName, ', \gamma_1 = ', num2str(Data.Model_real_data.([filename_for_simulation{file}]).gamma1_distribution_dMSD), ' \gamma_2 = ', num2str(Data.Model_real_data.([filename_for_simulation{file}]).gamma2_distribution_dMSD)];
            end
            title(figureName);
            xlabel('time');
            ylabel('<MSD>');
            if save_images
                figureName = ['Mean distribution of MSD with n = ', num2str(number_of_RW), ', simulations with ',num2str(molecule),' molecule and ',num2str(phases), ' phase(s). Sample from ',filename_for_simulation{file}];
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_real_data\', figureName,'.png']); % Save the figure as an image
            end
        end

    end
end




%%
clear corner_length epsilon epsilon_str i ii j k j_alpha legendString random_color titleString c f colours_plots figureHeight figureName figureWidth hFig index_MSD_zero RW_data 
clear t vector_MSD_non_zero NumRWsingle
clear plot_mean plot_single save_images p

%%Plot of Speeds
%% Model_classic with no restriction: Plot of speeds in a single window for the Classic RW unrestricted

save_images = 1;
plot_single = 1;
plot_all    = 0;
% plots of Vx and Vy with or without the sign 
abs_speed   = 0;

% bins for speeds

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end

if Model_unrestricted_RW

    model = 0;

    if plot_single %plot single speeds

        for i = 1:1%number_of_RW

            p                       = 0;
            j                       = 0;
            filename_for_simulation = 0;
            molecule                = 0;
            phases                  = 0;
            One_big_plot_speed_RW(Data, model, i, j, p, abs_speed, vector_of_bins,filename_for_simulation, sampling, molecule, phases, save_images);

        end
    end

    if plot_all

        V_all =  [];
        Vx_all = [];
        Vy_all = [];

        for i = 1:number_of_RW
            V_all  = [V_all  Data.ClassicRWUnrestricted.(['RW', num2str(i)]).V ];
            Vx_all = [Vx_all Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vx];
            Vy_all = [Vy_all Data.ClassicRWUnrestricted.(['RW', num2str(i)]).Vy];
        end

        % Define the desired figure name and dimensions
        figureName = ['All_speed_unrestricted_RW_sampling_', num2str(sampling)];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels

        % Create the figure with the specified dimensions
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

        % Create subplot
        subplot(2, 2, 1);
        if abs_speed
            histogram(abs(V_all), vector_of_bins);
        else
            histogram(V_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('V');
        grid on;

        % Create subplot
        subplot(2, 2, 2);
        if abs_speed
            histogram(abs(Vx_all), vector_of_bins);
        else
            histogram(Vx_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('Vx');
        grid on;  

        % Create subplot
        subplot(2, 2, 3);
        if abs_speed
            histogram(abs(Vy_all), vector_of_bins);
        else
            histogram(Vy_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('Vx');
        grid on;  
        
    end
    if abs_speed
        StrTitle = ['All speeds (abs) in one plot, unrestricted RW (total RW = ', num2str(number_of_RW),'), sampling = ', num2str(sampling)];
    else
        StrTitle = ['All speeds (no abs) in one plot, unrestricted RW (total RW = ', num2str(number_of_RW),'), sampling = ', num2str(sampling)];
    end
    sgtitle(StrTitle);

    if save_images == 1
        %Example: Saving the figure
        saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRWUnrestricted\speeds_all\', figureName,'.png']); % Save the figure as an image
    end

end

%% Model_classic : Plot of speeds in a single window for the Classic RW 

save_images = 1;
plot_single = 1;
plot_all    = 0;

% plots of Vx and Vy with or without the sign 
abs_speed   = 0;

% bins for speeds

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end

if Model_classic

    model = 1;

    if plot_single %plot single speeds

        for i = 1:1%number_of_RW

            p                       = 0;
            j                       = 0;
            filename_for_simulation = 0;
            molecule                = 0;
            phases                  = 0;
            One_big_plot_speed_RW(Data, model, i, j, p, abs_speed, vector_of_bins, sampling, filename_for_simulation, molecule, phases, save_images);

        end
    end

    if plot_all

        V_all =  [];
        Vx_all = [];
        Vy_all = [];

        for i = 1:number_of_RW
            V_all  = [V_all  Data.ClassicRW.(['RW', num2str(i)]).V ];
            Vx_all = [Vx_all Data.ClassicRW.(['RW', num2str(i)]).Vx];
            Vy_all = [Vy_all Data.ClassicRW.(['RW', num2str(i)]).Vy];
        end

        % Define the desired figure name and dimensions
        figureName = ['All_speed_RW_sampling_', num2str(sampling)];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels

        % Create the figure with the specified dimensions
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

        % Create subplot
        subplot(2, 2, 1);
        if abs_speed
            histogram(abs(V_all), vector_of_bins);
        else
            histogram(V_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('V');
        grid on;

        % Create subplot
        subplot(2, 2, 2);
        if abs_speed
            histogram(abs(Vx_all), vector_of_bins);
        else
            histogram(Vx_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('Vx');
        grid on;  

        % Create subplot
        subplot(2, 2, 3);
        if abs_speed
            histogram(abs(Vy_all), vector_of_bins);
        else
            histogram(Vy_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('Vx');
        grid on;  
        
    end
    if abs_speed
        StrTitle = ['All speeds (abs) in one plot,  RW (total RW = ', num2str(number_of_RW),'), sampling = ', num2str(sampling)];
    else
        StrTitle = ['All speeds (no abs) in one plot,  RW (total RW = ', num2str(number_of_RW),'), sampling = ', num2str(sampling)];
    end
    sgtitle(StrTitle);

    if save_images == 1
        %Example: Saving the figure
        saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\ClassicRW\speeds_all\', figureName,'.png']); % Save the figure as an image
    end

end
%% Model_stillness_wall: Plot of speeds in a single window 

save_images = 1;
plot_single = 1;
plot_all    = 0;

% plots of Vx and Vy with or without the sign 
abs_speed   = 0;

% bins for speeds

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end

if Model_wall_still

    model = 2;

    if plot_single %plot single speeds
        for j = 1:length(p_still)
            for i = 1:2%number_of_RW

                filename_for_simulation = 0;
                molecule                = 0;
                phases                  = 0;
                One_big_plot_speed_RW(Data, model, i, j, p_still(j), abs_speed, vector_of_bins, sampling, filename_for_simulation, molecule, phases, save_images);

            end
        end
    end

    if plot_all

        for j = 1:length(p_still)

            V_all =  [];
            Vx_all = [];
            Vy_all = [];


            for i = 1:number_of_RW
                V_all  = [V_all  Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).V ];
                Vx_all = [Vx_all Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx];
                Vy_all = [Vy_all Data.Model_wall_still.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy];
            end

            % Define the desired figure name and dimensions
            figureName = ['All_speed_stillness_wall_alpha_',num2str(p_still(j)),'_sampling_', num2str(sampling)];
            figureWidth = 1200; % in pixels
            figureHeight = 800; % in pixels

            % Create the figure with the specified dimensions
            hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

            % Create subplot
            subplot(2, 2, 1);
            if abs_speed
                histogram(abs(V_all), vector_of_bins);
            else
                histogram(V_all, vector_of_bins);
            end
            %ylim([0 7e4]);
            ylabel("frequency");
            xlabel('V');
            grid on;

            % Create subplot
            subplot(2, 2, 2);
            if abs_speed
                histogram(abs(Vx_all), vector_of_bins);
            else
                histogram(Vx_all, vector_of_bins);
            end
            %ylim([0 7e4]);
            ylabel("frequency");
            xlabel('Vx');
            grid on;

            % Create subplot
            subplot(2, 2, 3);
            if abs_speed
                histogram(abs(Vy_all), vector_of_bins);
            else
                histogram(Vy_all, vector_of_bins);
            end
            %ylim([0 7e4]);
            ylabel("frequency");
            xlabel('Vx');
            grid on;

            if abs_speed
                StrTitle = ['All speeds (abs) in one plot, stillness wall (total RW = ', num2str(number_of_RW),'), alpha = ', num2str(p_still(j)), ' sampling = ', num2str(sampling)];
            else
                StrTitle = ['All speeds (no abs) in one plot, stillness wall (total RW = ', num2str(number_of_RW),'), alpha = ', num2str(p_still(j)), ' sampling = ', num2str(sampling)];
            end
            sgtitle(StrTitle);

            if save_images
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_still\speed_all\', figureName,'.png']); % Save the figure as an image
            end
        end
    end
end
%% Model_move_wall: Plot of speeds in a single window 

save_images = 1;
plot_single = 1;
plot_all    = 0;

% plots of Vx and Vy with or without the sign 
abs_speed   = 0;

% bins for speeds

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end
vector_of_bins = linspace(0,25,interval_speed);
if Model_wall_move

    model = 3;

    if plot_single %plot single speeds
        for j = 1:length(p_still)
            for i = 1:2%number_of_RW
                
                filename_for_simulation = 0;
                molecule                = 0;
                phases                  = 0;
                One_big_plot_speed_RW(Data, model, i, j, p_still(j), abs_speed, vector_of_bins, sampling, filename_for_simulation, molecule, phases, save_images);

            end
        end
    end

    if plot_all

        for j = 1:length(p_still)

            V_all =  [];
            Vx_all = [];
            Vy_all = [];


            for i = 1:number_of_RW
                V_all  = [V_all  Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).V ];
                Vx_all = [Vx_all Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vx];
                Vy_all = [Vy_all Data.Model_wall_move.(['alpha',num2str(j)]).(['RW', num2str(i)]).Vy];
            end

            % Define the desired figure name and dimensions
            figureName = ['All_speed_moving_wall_alpha_',num2str(p_still(j)),'_sampling_', num2str(sampling)];
            figureWidth = 1200; % in pixels
            figureHeight = 800; % in pixels

            % Create the figure with the specified dimensions
            hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

            % Create subplot
            subplot(2, 2, 1);
            if abs_speed
                histogram(abs(V_all), vector_of_bins);
            else
                histogram(V_all, vector_of_bins);
            end
            %ylim([0 7e4]);
            ylabel("frequency");
            xlabel('V');
            grid on;

            % Create subplot
            subplot(2, 2, 2);
            if abs_speed
                histogram(abs(Vx_all), vector_of_bins);
            else
                histogram(Vx_all, vector_of_bins);
            end
            %ylim([0 7e4]);
            ylabel("frequency");
            xlabel('Vx');
            grid on;

            % Create subplot
            subplot(2, 2, 3);
            if abs_speed
                histogram(abs(Vy_all), vector_of_bins);
            else
                histogram(Vy_all, vector_of_bins);
            end
            %ylim([0 7e4]);
            ylabel("frequency");
            xlabel('Vx');
            grid on;

            if abs_speed
                StrTitle = ['All speeds (abs) in one plot, moving wall (total RW = ', num2str(number_of_RW),'), alpha = ', num2str(p_still(j)), ' sampling = ', num2str(sampling)];
            else
                StrTitle = ['All speeds (no abs) in one plot, moving wall (total RW = ', num2str(number_of_RW),'), alpha = ', num2str(p_still(j)), ' sampling = ', num2str(sampling)];
            end
            sgtitle(hFig, StrTitle);

            if save_images
                %Example: Saving the figure
                saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_wall_move\speed_all\', figureName,'.png']); % Save the figure as an image
            end
        end
    end
end

%% Model_real_data: Plot of speeds in a single window 

save_images = 1;
plot_single = 1;
plot_all    = 0;

% plots of Vx and Vy with or without the sign 
abs_speed   = 0;

% bins for speeds

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end

if Model_real_data

    model = 5;

    if plot_single %plot single speeds
        for file = 1:length(filename_for_simulation)
            for i = 1:2%number_of_RW

                p         = 0;
                j         = 0;
                sampling  = 0;

                One_big_plot_speed_RW(Data, model, i, j, p, abs_speed, vector_of_bins, sampling, filename_for_simulation{file}, molecule, phases, save_images);

            end
        end
    end

    if plot_all

        V_all =  [];
        Vx_all = [];
        Vy_all = [];

        for file = 1:length(filename_for_simulation)
            for i = 1:number_of_RW
                V_all  = [V_all  Data.Model_real_data.([filename_for_simulation{file}]).(['RW', num2str(i)]).V ];
                Vx_all = [Vx_all Data.Model_real_data.([filename_for_simulation{file}]).(['RW', num2str(i)]).Vx];
                Vy_all = [Vy_all Data.Model_real_data.([filename_for_simulation{file}]).(['RW', num2str(i)]).Vy];
            end
        end

        % Define the desired figure name and dimensions
        figureName = ['All_speed_Model_real_data_', num2str(sampling)];
        figureWidth = 1200; % in pixels
        figureHeight = 800; % in pixels

        % Create the figure with the specified dimensions
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

        % Create subplot
        subplot(2, 2, 1);
        if abs_speed
            histogram(abs(V_all), vector_of_bins);
        else
            histogram(V_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('V');
        grid on;

        % Create subplot
        subplot(2, 2, 2);
        if abs_speed
            histogram(abs(Vx_all), vector_of_bins);
        else
            histogram(Vx_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('Vx');
        grid on;

        % Create subplot
        subplot(2, 2, 3);
        if abs_speed
            histogram(abs(Vy_all), vector_of_bins);
        else
            histogram(Vy_all, vector_of_bins);
        end
        %ylim([0 7e4]);
        ylabel("frequency");
        xlabel('Vx');
        grid on;

        if abs_speed
            StrTitle = ['All speeds (abs) in one plot,  total simulations = ', num2str(number_of_RW),' molecule ',num2str(molecule),', and ',num2str(phases), ' phase(s)'];
        else
            StrTitle = ['All speeds (no abs) in one plot, total simulations = ', num2str(number_of_RW),' molecule ',num2str(molecule),' and ',num2str(phases), ' phase(s)'];
        end

        sgtitle(hFig, StrTitle);

        if save_images == 1
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\HUAWEI\Desktop\Materials for final thesis\RW\Images_RW\Model_real_data\', figureName,'.png']); % Save the figure as an image
        end
    end
end
%% Model_real_data: One big plot
save_images = 1;
interval_speed   = 25;
vector_of_bins = linspace(0,25,interval_speed);


if Model_real_data

    model = 5;

    for file = 1:length(index_for_simulation)
        for i = 1:3%number_of_RW
            One_big_plot_RW(Data, model, index_for_simulation(file),filename_for_simulation{file}, i, file, vector_of_bins, save_images, molecule, phases);
        end
    end
end