%% plot of the distribution mean of the MSD with the t (written by me)

%colours_plots = rand(length(epsilon_values), 3);
legendString = cell(1, length(epsilon_values));

f = 1;

for corner_length = corner_length_values

    figure(f)
    hold on

    for j = 1:length(epsilon_values)

        epsilon = epsilon_values(j);
        MSD = zeros(1,number_of_time_steps);

        epsilon_str = strrep(num2str(epsilon), '.', '_'); % Replace '.' with '_'

        for k = 1:number_of_time_steps

            for i = 1:number_of_RW
                MSD(k) = MSD(k) + Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).(['RW', num2str(i)]).MSD(k);
            end
            MSD(k) = MSD(k)/number_of_RW;
        end

        %Copy the MSD we want to plot and collecting how many 0s we have
        k = 0;
        t = 1:1:number_of_time_steps;

        for j = 1:number_of_time_steps

            if MSD(j) == 0
                index_MSD_zero(j) = j;
                t(j) = [];
                k = k+1;
            else
                vector_MSD_non_zero(j-k) = MSD(j);
            end
        end
 
        epsilon_str = strrep(num2str(epsilon), '_', '.'); % Replace '_' with '.'
        legendString{j} = ['epsilon= ', epsilon_str];
        loglog(t,vector_MSD_non_zero,'Color', colours_plots(j,:), 'LineWidth', 2)

        hold off

        f = f + 1;

        p = polyfit(log(t), log(vector_MSD_non_zero),1);
        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).gamma_distribution_MSD = p(1);
        Data.(['length', num2str(corner_length)]).(['epsilon', epsilon_str]).alpha_distribution_MSD = exp(p(2));
        clear vector_MSD_non_zero

    end
end
