%% Animation
X_corner = [0:1:40, 40*ones(1,40)];
Y_corner = [40*ones(1,40), 40:-1:0];
figure; % Create a new figure
for t = 1:2000
    cla; % Clear the current axes
    
    % Plot all centroids up to time t
    plot(Centroid(1:t, 1), Centroid(1:t, 2), 'Color', 'b', 'LineWidth', 1.5); % Thin line
    hold on
    plot(X_corner, Y_corner, 'Color', 'g');
    
    % Plot the current centroid point
    hold on;
    plot(Centroid(t, 1), Centroid(t, 2), 'o', 'MarkerSize', 5, 'MarkerFaceColor', 'r', 'MarkerEdgeColor', 'r', 'LineWidth', 2); % Thicker line and marker
    hold off;
    
    % Additional plot settings (if needed)
    xlabel('X');
    ylabel('Y');
    xlim([0,50]);
    ylim([0,50]);
    title('Animated Plot DTRW with epsilon = 1 and corner length = 40');
    
    % Pause to display the current frame
    pause(0.001); % Adjust the duration as needed
end
