function plot_centroids_path(Cell, Cell_name_boolean, Cell_number_video, Cell_video_position, Animation)

steps = length(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX);

if Animation

    %Imaging of the path in the well of the cells

    %double plot
    t = tiledlayout(1,2);


    titleString = ['Cell path, video ',num2str(Cell_number_video),' ',(Cell_video_position),' cell ', num2str(Cell_name_boolean), ' frame = ', num2str(steps)];
    title(t, titleString)
    xlabel(t,'cX')
    ylabel(t,'cY')


    %Plot of the completed path
    nexttile
    plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX, ...
          Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY )

    %Plot of the animated path in the frame 350x350
    nexttile
    h = animatedline;
    %axis([0,350,0,350])

    for k = 1:length(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX)

        addpoints( h, Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(k), ...
                      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(k) );
        drawnow

    end

    hold on

else
    
    titleString = ['Cell path, video ', num2str(Cell_number_video), ' ',Cell_video_position, ' cell ', num2str(Cell_name_boolean), ' frame = ', num2str(steps)];
    title( titleString)
    xlabel('cX')
    ylabel('cY')
    plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX, ...
          Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY )
    hold on
end
