%% attempt to estimate the mitosis process

% load the workspace
addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Workspace\All_data');
load('data_processed.mat','Cell','Cell_number_video','Cell_video_position','Cell_name_boolean','number_of_cells');

%C^* threshold
C_threshold = 0.85;

expected_time_mitosis = zeros(1,number_of_cells);

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1

        mitosis_time = 0;
        
        Circ = Cell.(['video',num2str(Cell_number_video(j))]). ...
                    ([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).Circ(end:-1:1);

        %trim the time of mitosis
        while Circ(1) < C_threshold

            Circ(1) = [];
            mitosis_time = mitosis_time + 1;
        end

        value = Circ(1);        
        c     = 1; %count for mitosis time
        r     = 0;

        % chances for the cell to be below threshold 
        reset_time = 6;
        
        while reset_time ~= 0

            while value >= C_threshold && c+r < length(Circ)

                value        = Circ(c + r);
                mitosis_time = mitosis_time + 1;
                c            = c + 1;
            end

            reset_time = reset_time - 1;
            r          = r + 1;

            if c + r > length(Circ)
                value = 0;
            else
            value        = Circ(c + r) ;
            end
            
        end

        if c == length(Circ)

            Cell.(['video',num2str(Cell_number_video(j))]). ...
                ([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).mitosis_time = mitosis_time*1000;
            expected_time_mitosis(j) = mitosis_time*1000;
        else

            Cell.(['video',num2str(Cell_number_video(j))]). ...
                ([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).mitosis_time = mitosis_time;
            expected_time_mitosis(j) = mitosis_time;
        end
    end
end