function One_big_plot(Cell, Cell_name_boolean, Cell_Steps, Cell_number_video, Cell_video_position, interval, slope_info, save_images)

% Define the desired figure name and dimensions
figureName = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean)];
figureWidth = 1200; % in pixels
figureHeight = 800; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

% Create the first subplot
subplot(2, 2, 1);
t = linspace(1,Cell_Steps-1,Cell_Steps-1);
loglog(t, Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).MSD, 'bo');
%xlim([0 10^4])
%ylim([0 10^5])
xlabel('time steps');
ylabel('MSD');
grid on;
if slope_info(3,1) > 0 
    hold on 
    t    = linspace(1,slope_info(3,1), 1000);
    MSD  = slope_info(2,1).*t.^slope_info(1,1);
    loglog(t, MSD, 'r')
    legend('\gamma = ', num2str(slope_info(1,1)),', points used: ', num2str(slope_info(3,1)))
end
if slope_info(3,3) > 0 
    hold on 
    t    = linspace(Cell_Steps-slope_info(3,3)+1, Cell_Steps, 1000);
    MSD  = slope_info(2,3).*t.^slope_info(1,3);
    loglog(t, MSD, 'g','LineWidth', 2)
    legend('\gamma = ', num2str(slope_info(1,3)),', points used: ', num2str(slope_info(3,3)))
end

if slope_info(3,1) > 0 && slope_info(3,3) > 0 
    legend('Data',['\gamma = ', num2str(slope_info(1,1)), ', points used: ', num2str(slope_info(3,1))], ['\gamma = ', num2str(slope_info(1,3)),', points used: ', num2str(slope_info(3,3))], 'Location', 'southeast')
elseif slope_info(3,1) > 0
    legend('Data',['\gamma = ', num2str(slope_info(1,1)),', points used: ', num2str(slope_info(3,1))],'Location', 'southeast')
elseif slope_info(3,3) > 0 
    legend('Data',['\gamma = ' num2str(slope_info(1,3)), ', points used: ', num2str(slope_info(3,3))],'Location', 'southeast')
end


% Create the second subplot
subplot(2, 2, 2);
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX, ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY, 'o');
hold on
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(1), ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(1), 'r*');
xlim([0 380]);
ylim([0 380]);
xlabel('x');
ylabel('y');
grid on;

% Create the third subplot
subplot(2, 2, 3);
histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V, interval);
ylim([0 200]);
ylabel("frequency");
xlabel('V');
grid on;

% Create the forth subplot
subplot(2, 2, 4);
loglog( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V_frequency, ...
        Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V_speed, 'o');
xlim([0 200]);
xlabel("log(frequency)")
ylabel('log(V)')
grid on;

StrTitle = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean), ' (n° frames: ', num2str(Cell_Steps), ')'];

% Add a title above all the subplots
sgtitle(hFig, StrTitle);
if save_images == 1
StrTitle = ['video_', num2str(Cell_number_video), '_', Cell_video_position, '_cell_', num2str(Cell_name_boolean)];
%Example: Saving the figure
saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\One_big_plot\',StrTitle,'.png']); % Save the figure as an image
end


