function [Cell, number_of_cells, Cell_Steps, Cell_name_boolean, Cell_number_video, Cell_video_position, filenames] = Cells_centroid_info_acquirer()


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%SELECTING CELLS' FILES OF INTEREST%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Open a file selection dialog for multiple files
[filenames, filepath] = uigetfile('*.xlsx*', 'Select multiple files', 'MultiSelect', 'on');

% Check if the user canceled the operation
if isequal(filenames, 0)
    disp('User canceled the operation.');
    return;
end

%When the case study is one single cell
single_cell_case = (sum(class(filenames) == 'char') == 4);


% Display the full paths of the selected files
if ~single_cell_case
    for i = 1:length(filenames)
        disp( ['Selected file ' num2str(i) ': ' fullfile(filepath, filenames{i})] );
    end
else 
    disp( ['Selected file : ' fullfile(filepath, filenames)] );
end
% Save the filenames into variables
%for i = 1:length(filenames)
%    eval(['selectedFilename' num2str(i) ' = filenames{i};']);
%end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%DATA EXTRACTIION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Number of cells interested
if single_cell_case
    number_of_cells = 1;
else
    number_of_cells = length(filenames);
end

%Getting info
Cell_Steps          = zeros(number_of_cells,1);
Cell_name_boolean   = zeros(number_of_cells,1);
Cell_number_video   = zeros(number_of_cells,1);
Cell_video_position = cell(number_of_cells,1);

if single_cell_case

    boolean_string    = regexp(filenames(11:end), '\d+', 'match');
    Cell_name_boolean = str2double(boolean_string);

    n_video = regexp(filenames(6:7), '\d+', 'match');
    Cell_number_video = str2double(n_video);

    Cell_video_position = filenames(9:10);
else
    for i = 1:number_of_cells

        boolean_string = regexp(filenames{i}(11:end), '\d+', 'match');
        Cell_name_boolean(i) = str2double(boolean_string);

        n_video = regexp(filenames{i}(6:7), '\d+', 'match');
        Cell_number_video(i) = str2double(n_video);

        Cell_video_position{i} = filenames{i}(9:10);
    end
end

Cell = struct();

%Data extraction from excel

if single_cell_case
    Centroids = table2array( importfile( fullfile( filepath, filenames ), "sheet1", [5, Inf] ) );
    Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX   = (Centroids(:,1))';
    Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY   = (Centroids(:,2))';
    Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).Area = (Centroids(:,3))';
    Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).Circ = (Centroids(:,5))';
    Cell_Steps = length(Centroids(:,1));
else
    for i= 1:number_of_cells
        Centroids = table2array( importfile( fullfile( filepath, filenames{i} ), "sheet1", [5, Inf] ) );
        Cell.(['video',num2str(Cell_number_video(i))]).([Cell_video_position{i}]).( ['cell_', num2str(Cell_name_boolean(i)), '_info'] ).cX   = (Centroids(:,1))';
        Cell.(['video',num2str(Cell_number_video(i))]).([Cell_video_position{i}]).( ['cell_', num2str(Cell_name_boolean(i)), '_info'] ).cY   = (Centroids(:,2))';
        Cell.(['video',num2str(Cell_number_video(i))]).([Cell_video_position{i}]).( ['cell_', num2str(Cell_name_boolean(i)), '_info'] ).Area = (Centroids(:,3))';
        Cell.(['video',num2str(Cell_number_video(i))]).([Cell_video_position{i}]).( ['cell_', num2str(Cell_name_boolean(i)), '_info'] ).Circ = (Centroids(:,5))';
        Cell_Steps(i) = length(Centroids(:,1));
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%






