
%Acquisition of data, 1 if it's needed 0 if it is not necessary
Acquisition_Data = 0;

% Clear and close everything before compile (avoid any errors due to possibile overwritings)
%Boolean needed:
%Acquisition_Data

if Acquisition_Data
    clc
    close all
    clear
    Acquisition_Data = 1;
end


if Acquisition_Data
    %Script for acquiring the cells' centroid
    [Cell, number_of_cells, Cell_Steps, Cell_name_boolean, Cell_number_video, Cell_video_position, filenames] = Cells_centroid_info_acquirer();
    disp('Structure Cell has been created and all the data of the centroids has been acquired and ready to be used');
else
    % load the workspace
    addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Workspace\All_data');
    load('data_processed.mat');
    disp('Structure Cell has been loaded, all the data of the centroids has been loaded and ready to be used');
end

clear Acquisition_Data

%% Application of correction due to camera movement

Apply_correction = 1;

% Plot of the Centroids of the cell acquired from the Excel files, set 1 if one want the plots, 0 otherwise. Animation is the boolean for the optional plot of the path animated from the start to the end of the cell movement (time is referred as time unit)

plot_centroids = 1;
Animation = 1;

%% %%%%%%%%%%%%%%%%%%Booleans for the Beauchemin section%%%%%%%%%%%%%%%%%%%%%

%% Strings of all the statistics present that can be computed
Str_statistics = {'MD', 'MSD', 'V', 'Vx', 'Vy'};

% Acquisition of statistics: 1 means will acquire, 0 will not
A_MD  = 0;
A_MSD = 1;
A_V   = 1;
A_Vx  = 0;
A_Vy  = 0;
% Acquisition of Vx or Vy with only the modulus
A_V_abs = 0;
% IF any of speeds (Vx, Vy or V) are acquired then histogram are needed for the analysis it/them.

% Value for how many subclasses one want for the hystogra
interval = 45;
vector_of_bins = linspace(0,25,interval);

% Section needed IF you want to plot all the graphs of a particular
% statistic of all the cell (set plot_all_graphs to 1, set it to 0 if it's 
% not needed)
%
% Possible choice of feature are 'MD', 'MSD', 'Vx', 'Vy', 'V'
%
%Furthermore, you can choose to visualize in a plot or in loglog scale
plot_all_graphs = 1;
feature = 'V'; 
plot_feature_loglog = 1;


% Section neeeded If you want to plot all the graphs of all the statistics desired of a particular cell (put the cell number in terms of how it is saved in the Workspace). 
% 
% Ex: if 1st cell is cell_1, 2nd cell is cell_11 and 3rd cell is cell_101
% If you want all the info of statistics of your interest on cell_101 SET 
% Cell_of_choice = 3, if these plots are not needed, just set Cell_ofchoice = 0)
Cell_of_choice = 1; 

%plot_feature_loglog = 1;

%% Plot of the centroids
%Boolean needed:
plot_centroids = 1;
Animation = 1;

if plot_centroids
    for j = number_of_cells
        figure(j)
        plot_centroids_path(Cell, Cell_name_boolean(j), Cell_number_video(j), Cell_video_position{j}, Animation);

    end
end

%% Post process films
%Count how many times the data has been corrected
correction_times = 0;

if correction_times == 0
    if Apply_correction == 1
        Cell = Correction_from_camera_drift(Cell, Cell_number_video, Cell_video_position, Cell_name_boolean);
         correction_times = correction_times + 1;
    end
else 
    disp('The correction as being already applied, make sure that the correction was not made previously in oder to post process');
end

%% Plot of all the points in one plot

figure(888)
for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        plot( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cX(2:end), ...
              Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cY(2:end), ...
              'b*');
        hold on
    end
end

Initial_points = zeros(2,sum(Cell_name_boolean == 1));
i = 1;

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        plot( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cX(1), ...
              Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cY(1), ...
               'r*');
        hold on
        Initial_points(1,i) = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cX(1);
        Initial_points(2,i) = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cY(1);
        hold on
        plot( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cX(end), ...
              Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cY(end), ...
              'g*');
        i = i+1;
    end
end

%saveas(gcf, 'All_positions_in_one_plot');

%% Density along x and y
save_images = 0;
cX = [];
cY = [];
for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        cX = [cX, Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cX];
        cY = [cY, Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).cY];
    end
end
bins = linspace(1,380,380);
figureName = 'Distribution of centroid along x-axis';
figure('Name', figureName,'NumberTitle', 'off')
histogram(cX,bins)
xlabel('x')
if save_images == 1
    saveas(gcf, 'C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Density_along_x&y\Distribution of centroid along x-axis.png');
end

figureName = 'Distribution of centroid along y-axis';
figure('Name', figureName,'NumberTitle', 'off')
histogram(cY,bins)
xlabel('y')
saveas(gcf, 'Distribution of centroid along y-axis');
if save_images == 1
    saveas(gcf, 'C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Density_along_x&y\Distribution of centroid along y-axis.png');
end
%% Round the initial points for the DTRW in 380x380
Initial_points = round(Initial_points);

%% Acquisition of the features MD and/or MSD
%boolean needed:
%A_MD
%A_MSD

if A_MD && A_MSD 

    for j = 1:number_of_cells

        if Cell_name_boolean(j) == 1

          [Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MD, ...
           Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MSD] = Calculate_MD_MSD( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...
                                                                                                                                                                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY );
        end
    end

else
    if A_MD
        for j = 1:number_of_cells

            if Cell_name_boolean(j) == 1

             Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MD = Calculate_MD( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...
                                                                                                                                                                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY );
       
            end
        end
   
    elseif A_MSD % Acquisition of only MSD
        for j = 1:number_of_cells

            if Cell_name_boolean(j) == 1
               Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MSD = Calculate_MSD(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...
                                                                                                                                                                   Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY );
            end
        end
    else %otherwise
    end
end
disp('Acquisition of the displacement has been completed, check Cell.video01.NW.cell_1_info to see if the features of MD or MSD are present');


%% Acquisition of the features Vx and/or Vy or V+Vx+Vy
%Boolean needed:
%A_Vx
%A_Vy
%A_V

if A_V 

    for j = 1:number_of_cells

       if Cell_name_boolean(j) == 1
        [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).Vx, ...
          Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).Vy, ...
          Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).V ] = Calculate_V( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...
                                                                                                                                                             Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY, ...
                                                                                                                                                            A_V_abs );
       end
    end

else
    if A_Vx || A_Vy
        if A_Vx
            for j = 1:number_of_cells

                if Cell_name_boolean(j) == 1
                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).Vx = Calculate_Vx( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...
                                                                                                                                                                   Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY, ...
                                                                                                                                                                   A_V_abs)
                end
            end
        end
        if A_Vy % Acquisition of only Vy
            for j = 1:number_of_cells

                if Cell_name_boolean(j) == 1
                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).Vy = Calculate_Vy( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...
                                                                                                                                                                   Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ). cY, ...
                                                                                                                                                                   A_V_abs)
                end
            end
        end
    end
end

disp('Acquisition of the velocity has been completed, check Cell.video01.NW.cell_1_info to see if the features of V, Vy or Vx are present');

%% Estimate the values for a possible power law of the features for MSD and MD, while we get frequency for V of the first generation
%String needed:
%Str_statistics = {'MD', 'MSD', 'Vx', 'Vy', 'V'};
%interval = 45;
vector_of_bins = linspace(0,70,interval);

slope           = struct();
slope.one_slope = struct();

slope.one_slope.alpha_MD  = zeros(1,number_of_cells);
slope.one_slope.alpha_MSD = zeros(1,number_of_cells);
slope.one_slope.gamma_MD  = zeros(1,number_of_cells);
slope.one_slope.gamma_MSD = zeros(1,number_of_cells);

for i = 1:length(Str_statistics)

    if eval(['A_',Str_statistics{i}])

        for j = 1:number_of_cells

            if Cell_name_boolean(j) == 1

                if i<=2
                    
                   [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([Str_statistics{i},'_gamma']), ...
                     Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([Str_statistics{i},'_alpha']) ...
                   ] = ...
                       linear_regression(Cell, Cell_name_boolean(j), Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, Str_statistics{i});

                   slope.one_slope.(['gamma_',Str_statistics{i}])(j) = ...
                   Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([Str_statistics{i},'_gamma']);

                   slope.one_slope.(['alpha_',Str_statistics{i}])(j) = ...
                   Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([Str_statistics{i},'_alpha']);

               elseif i==3  % mettere abs?

                   [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_frequency']), ...
                     Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_speed']) ...
                   ] = hist(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i}),vector_of_bins);

                   [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+1},'_frequency']), ...
                     Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+1},'_speed']) ...
                   ] = hist(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i+1}),vector_of_bins);

                   [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+2},'_frequency']), ...
                     Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+2},'_speed']) ...
                   ] = hist(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i+2}),vector_of_bins);


               elseif i==4 % mettere abs?

                   [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_frequency']), ...
                     Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_speed']) ...
                   ] = hist(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i}),vector_of_bins);

               elseif i==5 % mettere abs?

                   [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_frequency']), ...
                     Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_speed']) ...
                       ] = hist(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i}),vector_of_bins);

                end
            end
        end
    end
end

disp('The computation of the power-law-features has been completed, check Cell.video01.NW.cell_1_info to see if the features of frequency, speed or gamma and alpha are present')
%% Plot of all the graphs of a particular feature

%Boolean value needed:
interval = 60;
vector_of_bins = linspace(0,70,interval);
plot_all_graphs = 1;
plot_feature_loglog = 1;
feature = 'MSD';

if plot_all_graphs

    for j = 1:number_of_cells

        if Cell_name_boolean(j) == 1

            figure(j)

            if strcmp(feature, 'V')
                plot_one_statistic( Cell, Cell_name_boolean(j),Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, feature,  plot_feature_loglog , ...
                    0, 0,  vector_of_bins);
            end
            if strcmp(feature, 'Vx')
                plot_one_statistic( Cell, Cell_name_boolean(j),Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, feature,  plot_feature_loglog , ...
                    0, 0,  vector_of_bins);
            end
            if strcmp(feature, 'Vy')
                plot_one_statistic( Cell, Cell_name_boolean(j),Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, feature,  plot_feature_loglog , ...
                    0, 0,  vector_of_bins);
            end
            if strcmp(feature, 'MD')
                plot_one_statistic( Cell, Cell_name_boolean(j),Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, feature,  plot_feature_loglog , ...
                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([feature,'_gamma']), ...
                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([feature, '_alpha']), vector_of_bins ...
                    );
            end
            if strcmp(feature, 'MSD')
                plot_one_statistic( Cell, Cell_name_boolean(j),Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, feature,  plot_feature_loglog ,  ...
                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([feature,'_gamma']), ...
                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_', num2str(Cell_name_boolean(j)), '_info']).([feature, '_alpha']), vector_of_bins ...
                    );
            end
        end
        hold on
    end

end
disp('All the plots has been processed, please wait for the display.')

%% Plots of all the calculated statistics of a particular cell of choice
%Boolean value needed:
%Cell_of_choice = 1; 
%plot_feature_loglog = 1;

if Cell_of_choice>=1
    if Cell_name_boolean(Cell_of_choice) == 1
        fig = 1;
        for i = 1:length(Str_statistics)      %Check of all the statistics were calculated
            if eval(['A_',Str_statistics{i}]) %Check if the statistic of interest was calculated
                fig = fig + 1;
                figure(fig)

            if i>=3
               Cell.(['video',num2str(Cell_number_video(Cell_of_choice))]).([Cell_video_position{Cell_of_choice}]).(['cell_', num2str(Cell_name_boolean(Cell_of_choice)), '_info']).([Str_statistics{i},'_gamma'])  = 0;
               Cell.(['video',num2str(Cell_number_video(Cell_of_choice))]).([Cell_video_position{Cell_of_choice}]).(['cell_', num2str(Cell_name_boolean(Cell_of_choice)), '_info']).([Str_statistics{i}, '_alpha']) = 0;
            end

            plot_one_statistic( Cell, Cell_name_boolean(Cell_of_choice), Cell_Steps(Cell_of_choice), Cell_number_video(Cell_of_choice), Cell_video_position{Cell_of_choice}, Str_statistics{i}, plot_feature_loglog, ...
                                Cell.(['video',num2str(Cell_number_video(Cell_of_choice))]).([Cell_video_position{Cell_of_choice}]).(['cell_', num2str(Cell_name_boolean(Cell_of_choice)), '_info']).([Str_statistics{i},'_gamma']), ...
                                Cell.(['video',num2str(Cell_number_video(Cell_of_choice))]).([Cell_video_position{Cell_of_choice}]).(['cell_', num2str(Cell_name_boolean(Cell_of_choice)), '_info']).([Str_statistics{i}, '_alpha']), vector_of_bins ...
                                );

            end
        end
    else
        disp('The cell of choice is not a cell of type 1');
        return;
    end
else
    disp('There is no choice of the cell, change the value Cell_of_choice into a positive integer');
end


%% Display of the plots in a more visual pleasing way
save_images = 0;
interval = 60;
vector_of_bins = linspace(0,70,interval);
% there is the analysis of the slope in Analysis_of_MSD_and_MD needed for
% this section: 
%addpath('C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Analysis_of_statistics');
%Analysis_of_MSD_and_MD();

for j = 1:number_of_cells
    
    if Cell_name_boolean(j) == 1
        
        One_big_plot(Cell, Cell_name_boolean(j), Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, vector_of_bins, [0 0 0; 0 0 0; 0 0 0], save_images) %[slope.first_third_phase.gamma(j,:); slope.first_third_phase.alpha(j,:); slope.first_third_phase.points(j,:) ], save_images)

    end

end

disp('All the plots has been processed and saved, please wait for the display.')


%% Calculus of the angles 

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        for i = 1:Cell_Steps(j)
            Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta(i) = ...
                Calculate_angle( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).Vx(i), ...
                                 Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).Vy(i));
        end
    end
end

disp("The calculus of the displacements of angles are done. Check Cell.video_1.NE.cell_1_info.thera to see if it is non empty")

%% plot of angles and frequencies of such angles

displacement_angle = 10;

save_images = 1;

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        % Define the desired figure name and dimensions
        figureName = ['video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j)), ' interval length = ', num2str(displacement_angle)];
        figureWidth = 600; % in pixels
        figureHeight = 400; % in pixels

        % Create the figure with the specified dimensions
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [150, 150, figureWidth, figureHeight]);
        polarhistogram( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta, ...
                        'BinEdges', 0:pi/180*displacement_angle:2*pi, 'Normalization', 'count');

        %histogram(abs(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta), vector_of_bins_angles)
        %xticks(0:pi/2:2*pi);
        %xticklabels({'0', '\pi/2', '\pi', '3\pi/2', '2\pi'});

        %xlabel('\theta');
        %ylabel('frequency');
        StrTitle = ['video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j)), ' (n° frames: ', num2str(Cell_Steps(j)), '), inverval length = ', num2str(displacement_angle)];
        title(StrTitle)
        if save_images == 1
            StrTitle = ['video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Angles\Angles\',StrTitle,'.png']); % Save the figure as an image
        end
    end
end
%% put every angle into one variable
theta = [];
for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1

        theta = [theta Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta ];

    end
end

%% plot of all angles in a single plot
displacement_angle = 10;

figureName = ['All angles in one plot, intervals length = ', num2str(displacement_angle)];
figureWidth = 600; % in pixels
figureHeight = 400; % in pixels
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [150, 150, figureWidth, figureHeight]);
polarhistogram( theta, 'BinEdges', 0:pi/180*displacement_angle:2*pi, 'Normalization', 'count');
title(figureName)

%% Calculus of the displacement of angles 

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        for i = 1:Cell_Steps(j)-1
            Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i) = ...
                            Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta(i+1) - ...
                            Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).theta(i);
            
            if  abs(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i)) > pi
                      Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i) =  ...
                      Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i)- 2*pi;
            end
        end
    end
end

disp("The calculus of the displacements of angles is done. Check Cell.video_1.NE.cell_1_info.var_thera to see if it is non empty")

%% plot of angles and frequencies of the displacement of such angles
abs_angle   = 0;

if abs_angle
    interval_for_angles   = 45;
    vector_of_bins_angles = linspace(0,2*pi,interval_for_angles);
else
    interval_for_angles   = 90;
    vector_of_bins_angles = linspace(-2*pi,2*pi,interval_for_angles);    
end
save_images = 1;


for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        % Define the desired figure name and dimensions
        figureName = ['video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
        figureWidth = 600; % in pixels
        figureHeight = 400; % in pixels

        % Create the figure with the specified dimensions
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [150, 150, figureWidth, figureHeight]);
if abs_angle
        histogram(abs(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta), vector_of_bins_angles)
        xticks(0:pi/2:2*pi);
        xticklabels({'0', '\pi/2', '\pi', '3\pi/2', '2\pi'});
else
        histogram(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta, vector_of_bins_angles)
        xticks(-2*pi:pi/2:2*pi);
        xticklabels({'-2\pi', '-3\pi/2','-\pi','-\pi/2','0', '\pi/2', '\pi', '3\pi/2', '2\pi'});    
end
        xlabel('\Delta\theta');
        ylabel('frequency');
        StrTitle = ['video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j)), ' (n° frames: ', num2str(Cell_Steps(j)), '), inverval = ', num2str(interval_for_angles)];
        title(StrTitle)
        if save_images == 1
            if abs_angle
            StrTitle = ['video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Angles\displacement\abs\',StrTitle,'.png']); % Save the figure as an image
            else
            StrTitle = ['video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Angles\displacement\no_abs\',StrTitle,'.png']); % Save the figure as an image
                           
            end
        end
    end
end

%% Plot a single displacement of angles among all the cells

abs_angle   = 1;

if abs_angle
    interval_for_angles   = 45;
    vector_of_bins_angles = linspace(0,2*pi,interval_for_angles);
else
    interval_for_angles   = 90;
    vector_of_bins_angles = linspace(-2*pi,2*pi,interval_for_angles);    
end

save_images = 1;

Var_theta = [];

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        Var_theta = [Var_theta Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta];
    end
end

% Define the desired figure name and dimensions
figureName = 'All displacement of angles in one plot';
figureWidth = 600; % in pixels
figureHeight = 400; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [150, 150, figureWidth, figureHeight]);

if abs_angle
        histogram(abs(Var_theta), vector_of_bins_angles)
        xticks(0:pi/2:2*pi);
        xticklabels({'0', '\pi/2', '\pi', '3\pi/2', '2\pi'});
else
        histogram(Var_theta, vector_of_bins_angles)
        xticks(-2*pi:pi/2:2*pi);
        xticklabels({'-2\pi', '-3\pi/2','-\pi','-\pi/2','0', '\pi/2', '\pi', '3\pi/2', '2\pi'});    
end

xlabel('\Delta\theta');
ylabel('frequency');
StrTitle = 'All displacement of angles in one plot';
title(StrTitle)

if abs_angle
    StrTitle = 'All displacement of angles (abs) in one plot ';
else
    StrTitle = 'All displacement of angles (no abs) in one plot';
end

%Example: Saving the figure
saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Angles\displacement\All_in_one_plot\',StrTitle,'.png']); % Save the figure as an image


%% Attempt to measure Persistency %%%%%%% need a revision %%%%%%%%%%%%

for j =1:number_of_cells
    if Cell_name_boolean(j) == 1

        Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length = ...
            zeros(1,length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta));

        %Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_angle = [];
    end
end

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1

        c = 1;

        variation = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(1);

        Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(1) = 1;

        for i = 2:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta)

            %if the overall variation is less or equal than pi/2 OR the speed is less than 10 frames (to consider the cell shape's movement) we increased one 1 the persistence length and increase the variation  
            if abs(variation) <= pi/2 %|| Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).V(i-1) < 6
                
                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(c) = ...
                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(c) + 1;

                variation = variation + Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i);

            else % there is an overall variation that is greater to pi/2 so we stop increasing the length persistency and move to the next one

                c = c + 1;

                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(c) = 1;

                %Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_angle = ...
                %    ...
                %    [Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_angle, ...
                %    variation - Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i)];

                variation = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).var_theta(i);
            end
        end
        %eliminate the 0 value from the length, which are irrelevant
        Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length == 0) = [];

        %recover the last var_theta
        if abs(variation)<= pi/2 %|| Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).V(end) < 6
            Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(c) = ...
                    Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length(c) + 1;
        end

    end
end

%% plot of percistency as a histogram
save_images = 0;

for j = 91:91%number_of_cells

    if Cell_name_boolean(j) == 1

        % Define the desired figure name and dimensions
        figureName = ['video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
        figureWidth = 600; % in pixels
        figureHeight = 400; % in pixels

        % Create the figure with the specified dimensions
        hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [150, 150, figureWidth, figureHeight]);

        max_percistency = max(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length);
        vector_of_bins = 1:1:max_percistency;

        %counts = histcounts(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length, vector_of_bins);
        hist(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).persistence_length, vector_of_bins);
        xlabel('Percistency Length');
        ylabel('frequency');
        StrTitle = ['video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j)), ' (n° frames: ', num2str(Cell_Steps(j)), '), percistency'];
        title(StrTitle)

        if save_images == 1

            StrTitle = ['video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
            %Example: Saving the figure
            saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Percistency\',StrTitle,'.fig']); % Save the figure as an image

        end
    end


end

%% Clearance of unnecessary variables
clear i j Apply_correction Cell_of_choice correction_times feature plot_all_graphs plot_feature_loglog



%%%% Need to estimate v_free, t_free, t_pause via fitting of the mean
%%%% displacement data, maybe look at the Beauchemin's article...