function [Vx,Vy,V] = Calculate_V(cX,cY,A_V_abs)

Vx = zeros(1,length(cX));

Vy = zeros(1,length(cX));

V   = zeros(1,length(cX));

if A_V_abs

    for i = 2:length(cX)

        %%%%%%%Speed along the x axis of the j-th cell on the i-th time (since we have only unit time, it is the same as the displacement along the x-axis)
        Vx(i) = abs( cX(i) - cX(i-1)) ;
        
        %%%%%%%Speed along the y axis of the j-th cell on the i-th time (since we have only unit time, it is the same as the displacement along the y-axis)
        Vy(i) = abs( cY(i) - cY(i-1)) ; 
        
        %%%%%%%Speed of the cell on the i-th time
        V(i) = sqrt( Vx(i)^2 + Vy(i)^2 );  
    end
    
else
    for i = 2:length(cX)

        %%%%%%%Speed along the x axis of the j-th cell on the i-th time (since we have only unit time, it is the same as the displacement along the x-axis)
        Vx(i) =  cX(i) -cX(i-1) ;
        
        %%%%%%%Speed along the y axis of the j-th cell on the i-th time (since we have only unit time, it is the same as the displacement along the y-axis)
        Vy(i) =  cY(i) - cY(i-1) ; 
        
        %%%%%%%Speed of the cell on the i-th time
        V(i) = sqrt( Vx(i)^2 + Vy(i)^2 );  
    end 
end
