function One_big_plot_third_phase(Cell, Cell_name_boolean, Cell_Steps, Cell_number_video, Cell_video_position, interval, abs_speed, starting_points_third, save_images)

% Define the desired figure name and dimensions
figureName = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean)];
figureWidth = 1200; % in pixels
figureHeight = 800; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

% Create the first subplot
subplot(2, 2, 1);
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX, ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY, 'o');
hold on
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(starting_points_third:Cell_Steps), ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(starting_points_third:Cell_Steps), 'g*');
hold on
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(1), ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(1), 'r*');
xlim([0 380]);
ylim([0 380]);
xlabel('x');
ylabel('y');
grid on;


% Create the second subplot
subplot(2, 2, 2);
if abs_speed
    histogram(abs(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V(starting_points_third:Cell_Steps)), interval);
else
    histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V(starting_points_third:Cell_Steps), interval);
end
ylim([0 200]);
ylabel("frequency");
xlabel('V');
grid on;

% Create the third subplot
subplot(2, 2, 3);
if abs_speed
    histogram(abs(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vx(starting_points_third:Cell_Steps)), interval);
else
    histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vx(starting_points_third:Cell_Steps), interval);
end
ylim([0 200]);
ylabel("frequency");
xlabel('Vx');
grid on;

% Create the forth subplot
subplot(2, 2, 4);
if abs_speed
    histogram(abs(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vy(starting_points_third:Cell_Steps)), interval);
else
    histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vy(starting_points_third:Cell_Steps), interval);
end
ylim([0 200]);
ylabel("frequency");
xlabel('Vy');
grid on;

StrTitle = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean), ' third phase (n° frames: ', num2str(Cell_Steps - starting_points_third), ')'];

% Add a title above all the subplots
sgtitle(hFig, StrTitle);
if save_images == 1
StrTitle = ['video_', num2str(Cell_number_video), '_', Cell_video_position, '_cell_', num2str(Cell_name_boolean), ];
%Example: Saving the figure
if abs_speed
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\One_big_plot_speeds\Third_phase\abs\',StrTitle,'.png']); % Save the figure as an image
else
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\One_big_plot_speeds\Third_phase\no_abs\',StrTitle,'.png']); % Save the figure as an image
end

end