function One_big_plot_first_phase(Cell, Cell_name_boolean, Cell_number_video, Cell_video_position, interval, abs_speed, ending_points_first, save_images)

% Define the desired figure name and dimensions
figureName = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean)];
figureWidth = 1200; % in pixels
figureHeight = 800; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

% Create the first subplot
subplot(2, 2, 1);
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX, ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY, 'o');
hold on
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(1:ending_points_first), ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(1:ending_points_first), 'r*');
hold on
plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(1), ...
      Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(1), 'y*');
xlim([0 380]);
ylim([0 380]);
xlabel('x');
ylabel('y');
grid on;



% Create the second subplot
subplot(2, 2, 2);
if abs_speed
    histogram(abs(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V(1:ending_points_first)), interval);
else
    histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).V(1:ending_points_first), interval);
end
ylim([0 100]);
ylabel("frequency");
xlabel('V');
grid on;

% Create the third subplot
subplot(2, 2, 3);
if abs_speed
    histogram(abs(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vx(1:ending_points_first)), interval);
else
    histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vx(1:ending_points_first), interval);
end
ylim([0 100]);
ylabel("frequency");
xlabel('Vx');
grid on;

% Create the forth subplot
subplot(2, 2, 4);
if abs_speed
    histogram(abs(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vy(1:ending_points_first)), interval);
else
    histogram(Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).Vy(1:ending_points_first), interval);
end
ylim([0 100]);
ylabel("frequency");
xlabel('Vy');
grid on;

StrTitle = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean), ' first phase (n° frames: ', num2str(ending_points_first), ')'];

% Add a title above all the subplots
sgtitle(hFig, StrTitle);
if save_images == 1
StrTitle = ['video_', num2str(Cell_number_video), '_', Cell_video_position, '_cell_', num2str(Cell_name_boolean), ];
%Example: Saving the figure
if abs_speed
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials_for_final_thesis\T_cells\Images\One_big_plot_speeds\First_phase\abs\',StrTitle,'.png']); % Save the figure as an image
else
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials_for_final_thesis\T_cells\Images\One_big_plot_speeds\First_phase\no_abs\',StrTitle,'.png']); % Save the figure as an image
end

end