function One_big_plot_acf(autocovariance, autocovariance_inverse, Cell, Cell_name_boolean, Cell_Steps, Cell_number_video, Cell_video_position, feature, save_images)

% Define the desired figure name and dimensions
figureName = ['video ', num2str(Cell_number_video), ' ', Cell_video_position, ' cell ', num2str(Cell_name_boolean)];
figureWidth = 1200; % in pixels
figureHeight = 800; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

% % Create the first subplot
% subplot(2, 2, 1);
% t = linspace(1,Cell_Steps,Cell_Steps);
% loglog(t, Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_', num2str(Cell_name_boolean), '_info']).MSD, 'bo');
% xlim([0 10^4])
% ylim([0 10^5])
% xlabel('time steps');
% ylabel('MSD');
% grid on;
% 
% % Create the second subplot
% subplot(2, 2, 2);
% plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX, ...
%       Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY, 'o');
% hold on
% plot( Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cX(1), ...
%       Cell.(['video',num2str(Cell_number_video)]).(Cell_video_position).( ['cell_', num2str(Cell_name_boolean), '_info'] ).cY(1), 'r*');
% xlim([0 380]);
% ylim([0 380]);
% xlabel('x');
% ylabel('y');
% grid on;

% Create the third subplot

subplot(2, 2, 1); % subplot(2, 2, 3);
plot(autocovariance.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).lags, ...
     autocovariance.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).aut_cor, 'bo')
xlabel('time (lags)')
stringy = ['Acf of ', feature];
ylabel(stringy)
xlim([0 length(autocovariance.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).lags)])
grid on;

% Create the forth subplot

subplot(2, 2, 2); % subplot(2, 2, 4);

% Define the path to the figure
figure_path = ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials_for_final_thesis\T_cells\Images\Loglog_autocorrelation_functions/' ...
               'Loglog_Autocorrelation_function_of_video_',num2str(Cell_number_video),'_',Cell_video_position,'_cell_', num2str(Cell_name_boolean),'.fig'];
% Load the figure
fig = openfig(figure_path);
% Extract the axes from the loaded figure
axes_from_fig = findobj(fig, 'type', 'axes');
% Plot the extracted axes in the subplot
copyobj(get(axes_from_fig, 'children'), gca);
xlabel('time (lags)')
stringy = ['Acf of ', feature];
ylabel(stringy)
xlim([0 length(autocovariance.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).lags)])
grid on;

% Create the fifth subplot
subplot(2, 2, 3); %subplot(2, 2, 5);
plot(autocovariance_inverse.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).lags, ...
    autocovariance_inverse.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).aut_cor, 'bo')
xlabel('time (lags)')
stringy = ['Inverse Acf of ', feature];
ylabel(stringy)
xlim([0 length(autocovariance_inverse.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).lags)])
grid on;

% Create the sixth subplot
subplot(2, 2, 4);%subplot(2, 2, 6);

% Define the path to the figure
figure_path = ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials_for_final_thesis\T_cells\Images\Loglog_inverse_autocorrelation_functions/' ...
               'Loglog_Inverse_autocorrelation_function_of_video_',num2str(Cell_number_video),'_',Cell_video_position,'_cell_', num2str(Cell_name_boolean),'.fig'];
% Load the figure
fig = openfig(figure_path);
% Extract the axes from the loaded figure
copyobj(get(axes_from_fig, 'children'), gca);
% Plot the extracted axes in the subplot
copyobj(axes_from_fig, gca);
xlabel('time (lags)')
stringy = ['Inverse Acf of ', feature];
ylabel(stringy)
xlim([0 length(autocovariance_inverse.(['video',num2str(Cell_number_video)]).(Cell_video_position).(['cell_',num2str(Cell_name_boolean),'_info']).lags)])
grid on;



% Add a title above all the subplots
sgtitle(hFig, StrTitle);
if save_images == 1
StrTitle = ['video_', num2str(Cell_number_video), '_', Cell_video_position, '_cell_', num2str(Cell_name_boolean)];
%Example: Saving the figure
saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials_for_final_thesis\T_cells\Images\One_big_plot_acf\',StrTitle,'.png']); % Save the figure as an image
end