function slope = First_and_third_phase_slopes(Cell, Cell_number_video, Cell_video_position, Cell_name_boolean)

%Let's analyse the slopes of possible power-law of the MSD and time in the 3
%different phases of the cells:
%
% First phase: Cell is starting its life as a single cell in the well (sometimes is not worth looking at it)
%
% Second phase: such phase is yet to be understood, so it is fair not to do
% any analysis for the time being
%
% Third phase: it is the phase of the cell to be ready for the mytosis,
% positioning itself very close to the wall (joined effect?)


%The structure slope.first_third_phase has been used:
%
%               MSD = \alpha*t^\gamma           (formula used)
%
% slope.alpha(j,:) is a vector of 3 values for the j-th
% cell, where each position is the alpha for the respecting phase.
%
% slope.gamma(j,:) is a vector of 3 values for the j-th
% cell, where each position is the gamma for the respecting phase.
%
% slope.first_third_phase.n_points(j,:) is a vector of 3 values for the j-th
% cell, where each position is the number of points used to calculate the
% gamma and alpha.


%When is not calculated, a NaN is placed in the respecting positions, with
%and expection of 5 cases: 
%
%  No second phase: if no second phase is present, a value of -1 is placed
%  in the respecting positions
%
%  Only third phase: the record of such cell is its division phase already,
%  so it is reasonable to place NaN for such cases. However, to keep it
%  traceble, a value of -1 is placed istead
%
%  Negative slope: a value of -1 is placed to acknowledge its
%  existence in the third positions.
%
%  Anchoring: a value of 1000 is placed to acknowledge such fenomena in the
%  third position
%
% Non considerated: if a j-th cell is not considerated, the whole raw of
% numbers will be zeroes

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 01 NE Cell 1, ANCHORING (case where the anchorig happened "far" from the cell division in term of time)
j = 1;

%Analysis of the third phase
starting_point_third_phase = 1395;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));
 
% save the info of the alphasf
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 01 NW Cell 1, negative slope
j = 2;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 01 SE Cell 1 negative slope
j = 3;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1 ;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 01 SW Cell 1
% Cell 1
j = 4;

%Analysis of the third phase
starting_point_third_phase = 300;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));
 
% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 02 NE Cell 1 ANCHORING
% Cell 1
j = 5;
 
% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = 1000;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = 1000;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 02 NW Cell 1
% Cell 1
j = 20;

%Analysis of the third phase
starting_point_third_phase = 200;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));
 
% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 02 SE Cell 1
j = 35;

%Analysis of the first phase
ending_point_first_phase = 400;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);
 
p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 500;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 02 SW Cell 1
j = 50;

%Analysis of the first phase
ending_point_first_phase = 326;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 327;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 03 NE Cell 1 ALL
j = 51;

%analysis of the third phase
starting_point_third_phase = 2;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = -1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = -1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 03 NW Cell 1 ALL
j = 52;

%analysis of the third phase
starting_point_third_phase = 2;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = -1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = -1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 03 SE Cell 1
j = 53;

%Analysis of the first phase
ending_point_first_phase = 200;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 900;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 03 SW Cell 1 NEGATIVE SLOPE
j = 54;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 04 NE Cell 1 ANCHORING
j = 55;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = 1000;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = 1000;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 04 NW Cell 1
j = 56;

%Analysis of the first phase
ending_point_first_phase = 100;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 101;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 04 SE Cell 1 Anchoring (case where the anchoring happened "far" from the cell division in term of time)
j = 57;

%analysis of the third phase
starting_point_third_phase = 600;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 04 SW Cell 1
j = 58;

%analysis of the third phase
starting_point_third_phase = 600; %provare con 100
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 05 NE Cell 1 NEGATIVE SLOPE
j = 59;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 05 NW Cell 1 NEGATIVE SLOPE
j = 60;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 05 SE Cell 1 NEGATIVE SLOPE
j = 61;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 05 SW Cell 1
j = 62;

%Analysis of the first phase
ending_point_first_phase = 100;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 101;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 06 NE Cell 1 NEGATIVE SLOPE
j = 63;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 06 NW Cell 1
j = 64;

%Analysis of the first phase
ending_point_first_phase = 200;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 201;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 06 SE Cell 1
j = 65;

%Analysis of the first phase
ending_point_first_phase = 75;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 76;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 06 SW Cell 1
j = 66;

%analysis of the third phase
starting_point_third_phase = 200;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 07 NE Cell 1
j = 67;

%Analysis of the first phase
ending_point_first_phase = 40;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 41;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 07 NW Cell 1
j = 68;

%Analysis of the first phase
ending_point_first_phase = 40;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 41;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 07 SE Cell 1 There is a bit of waving
j = 69;

%analysis of the third phase
starting_point_third_phase = 150;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 07 SW Cell 1
j = 70;

%Analysis of the first phase
ending_point_first_phase = 200;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 201;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 11 NE Cell 1 ALL
j = 77;

%analysis of the third phase
starting_point_third_phase = 2;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = -1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = -1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 11 NW Cell 1
j = 78;

%analysis of the third phase
starting_point_third_phase = 100;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 1 SE Cell 1
j = 79;

%Analysis of the first phase
ending_point_first_phase = 42;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 43;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 11 SW Cell 1
j = 80;

%Analysis of the first phase
ending_point_first_phase = 100; %?
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 428;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 12 NE Cell 1 NEGATIVE SLOPE
j = 81;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 12 NW Cell 1 NEGATIVE SLOPE
j = 82;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 12 SE Cell 1 NEGATIVE SLOPE
j = 83;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 12 sw Cell 1 NEGATIVE SLOPE
j = 84;

% save the info of the alphas
slope.alpha(j,1) = NaN;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = -1;
% save the info of the gammas
slope.gamma(j,1) = NaN;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = -1;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 16 NE Cell 1
j = 85;

%Analysis of the first phase
ending_point_first_phase = 50;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 100;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 16 NW Cell 1
j = 86;

%Analysis of the first phase
ending_point_first_phase = 261;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 1000; %1661;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 16 SE Cell 1
j = 87;

%Analysis of the first phase
ending_point_first_phase = 112;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 180;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 16 SW Cell 1
j = 88;

%Analysis of the first phase
ending_point_first_phase = 47;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 175;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 41 NE Cell 1 ALL
j = 89;

%analysis of the third phase
starting_point_third_phase = 2;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = -1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = -1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 41 NW Cell 1 ALL
j = 90;

%analysis of the third phase
starting_point_third_phase = 2;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);

p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = -1;
slope.alpha(j,2) = -1;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = -1;
slope.gamma(j,2) = -1;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 41 SE Cell 1
j = 91;

%Analysis of the first phase
ending_point_first_phase = 75;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(2:ending_point_first_phase);
t   = 2:1:ending_point_first_phase;

n_points_first_phase = length(MSD);

p_1     = polyfit(log(t),log(MSD),1);
gamma_1 = p_1(1);
alpha_1 = exp(p_1(2));

%analysis of the third phase
starting_point_third_phase = 600;
MSD = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD(starting_point_third_phase:end);
t   = starting_point_third_phase:1:length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD);

n_points_third_phase = length(MSD);
 
p_3     = polyfit(log(t),log(MSD),1);
gamma_3 = p_3(1);
alpha_3 = exp(p_3(2));

% save the info of the alphas
slope.alpha(j,1) = alpha_1;
slope.alpha(j,2) = NaN;
slope.alpha(j,3) = alpha_3;
% save the info of the gammas
slope.gamma(j,1) = gamma_1;
slope.gamma(j,2) = NaN;
slope.gamma(j,3) = gamma_3;
% save the info of the points
slope.points(j,1) = n_points_first_phase;
slope.points(j,2) = NaN;
slope.points(j,3) = n_points_third_phase;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Video 41 SW Cell 1 ALL
j = 92;

% save the info of the alphas
slope.alpha(j,1) = 0;
slope.alpha(j,2) = 0;
slope.alpha(j,3) = 0;
% save the info of the gammas
slope.gamma(j,1) = 0;
slope.gamma(j,2) = 0;
slope.gamma(j,3) = 0;
% save the info of the points
slope.points(j,1) = NaN;
slope.points(j,2) = NaN;
slope.points(j,3) = NaN;

