%Section for a futher analysis of V, Vx and Vy while considering the
%existence of the first and third phase

%% load the workspace
addpath('C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Workspace\All_data');
load('data_processed.mat');

%% create plots of each single video with 4 subplot: MSD, position, frequency over Vx and frequency of Vy (the speeds have signs)

save_images = 1;

interval       = 60;
vector_of_bins = linspace(-25,25,interval);
abs_speed      = 0;

for j = 1:number_of_cells
    
    if Cell_name_boolean(j) == 1
        
        One_big_plot_speeds(Cell, Cell_name_boolean(j), Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, vector_of_bins, [ 0 0 0; 0 0 0; 0 0 0 ], save_images, abs_speed)

    end

end

disp('All the plots has been processed and saved, please wait for the display.')

%% create plots of each single video with 4 subplot: MSD, position, frequency over Vx and frequency of Vy (the speeds are in abss value)

save_images = 1;

interval       = 45;
vector_of_bins = linspace(0,25,interval);
abs_speed      = 1;

for j = 1:number_of_cells
    
    if Cell_name_boolean(j) == 1
        
        One_big_plot_speeds(Cell, Cell_name_boolean(j), Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, vector_of_bins, [ 0 0 0; 0 0 0; 0 0 0 ], save_images, abs_speed)

    end

end

disp('All the plots has been processed and saved, please wait for the display.')


%% Creation of hystograms based on only the speeds V, Vx and Vy of the first and third phase

%vector of index of cell whose first phase is hypotesysed to exist
index_first_phase   = [  35,  50,  53,  56,  62,  64, 65, 67, 68,  70, 79,  80, 85,  86,  87, 88, 91 ];
ending_points_first = [ 400, 326, 200, 100, 100, 200, 75, 40, 40, 200, 42, 100, 50, 261, 112, 47, 75 ];

%vector of index of cell whose third phase is hypotesysed to exist
index_third_phase     = [    1,   4 , 20,  35,  50, 51, 52,  53,  56,  57,  58,  62,  64, 65,  66, 67, 68,  69,  70, 77,  78, 79,  80,  85,   86,  87,  88, 89, 90,  91 ];
starting_points_third = [ 1395, 300, 200, 500, 327,  1,  1, 900, 101, 600, 600, 101, 201, 76, 200, 41, 41, 150, 201,  1, 100, 43, 428, 100, 1000, 180, 175,  1,  1, 600 ];


%% Plot of hystograms of V, Vx and Vy in the first phase

abs_speed   = 0;

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end
save_images = 1;


for j = 1:length(index_first_phase)

    One_big_plot_first_phase( Cell, Cell_name_boolean(index_first_phase(j)), Cell_number_video(index_first_phase(j)), Cell_video_position{index_first_phase(j)}, ...
                              vector_of_bins, abs_speed, ending_points_first(j), save_images);

end


%% One plot for all the first phase V, Vx and Vy

abs_speed   = 0;

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end
save_images = 1;

V_first_phase  = [];
Vx_first_phase = [];
Vy_first_phase = [];


for j = 1:length(index_first_phase)

    V_first_phase  = [V_first_phase,  Cell.(['video',num2str(Cell_number_video(index_first_phase(j)))]).([Cell_video_position{index_first_phase(j)}]).( ['cell_', num2str(Cell_name_boolean(index_first_phase(j))), '_info'] ).V(1:ending_points_first(j)) ];
    Vx_first_phase = [Vx_first_phase, Cell.(['video',num2str(Cell_number_video(index_first_phase(j)))]).([Cell_video_position{index_first_phase(j)}]).( ['cell_', num2str(Cell_name_boolean(index_first_phase(j))), '_info'] ).Vx(1:ending_points_first(j))];
    Vy_first_phase = [Vy_first_phase, Cell.(['video',num2str(Cell_number_video(index_first_phase(j)))]).([Cell_video_position{index_first_phase(j)}]).( ['cell_', num2str(Cell_name_boolean(index_first_phase(j))), '_info'] ).Vy(1:ending_points_first(j))];

end

% Define the desired figure name and dimensions
figureName = 'Speeds in one plot';
figureWidth = 1200; % in pixels
figureHeight = 800; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

% Create the second subplot
subplot(2, 2, 1);
if abs_speed
    histogram(abs(V_first_phase), interval);
else
    histogram(V_first_phase, interval);
end
ylim([0 700]);
ylabel("frequency");
xlabel('V');
grid on;

% Create the third subplot
subplot(2, 2, 2);
if abs_speed
    histogram(abs(Vx_first_phase), interval);
else
    histogram(Vx_first_phase, interval);
end
ylim([0 700]);
ylabel("frequency");
xlabel('Vx');
grid on;

% Create the third subplot
subplot(2, 2, 3);
if abs_speed
    histogram(abs(Vy_first_phase), interval);
else
    histogram(Vy_first_phase, interval);
end
ylim([0 700]);
ylabel("frequency");
xlabel('Vy');
grid on;

if abs_speed
    StrTitle = 'Speeds in one plot (abs)' ;
else
    StrTitle = 'Speeds in one plot (no abs)' ;
end
% Add a title above all the subplots
sgtitle(hFig, StrTitle);

if save_images == 1

    StrTitle = 'Speeds in one plot' ;

    %Example: Saving the figure
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\One_big_plot_speeds\First_phase\one_plot\',StrTitle,'.png']); % Save the figure as an image
end
%% Plot of hystograms of V, Vx and Vy in the third phase

abs_speed   = 1;

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end
save_images = 1;

for j = 1:length(index_third_phase)

    One_big_plot_third_phase( Cell, Cell_name_boolean(index_third_phase(j)), Cell_Steps(index_third_phase(j)), Cell_number_video(index_third_phase(j)), Cell_video_position{index_third_phase(j)}, ...
                              vector_of_bins, abs_speed, starting_points_third(j), save_images);

end

%% One plot for all the third phase V, Vx and Vy

abs_speed   = 0;

if abs_speed
    interval_speed   = 25;
    vector_of_bins = linspace(0,25,interval_speed);
else
    interval_speed   = 50;
    vector_of_bins = linspace(-25,25,interval_speed);    
end
save_images = 1;

V_third_phase  = [];
Vx_third_phase = [];
Vy_third_phase = [];


for j = 1:length(index_third_phase)

    V_third_phase  = [V_first_phase, Cell.(['video',num2str(Cell_number_video(index_third_phase(j)))]).([Cell_video_position{index_third_phase(j)}]).( ['cell_', num2str(Cell_name_boolean(index_third_phase(j))), '_info'] ).V(starting_points_third(j):end)];
    Vx_third_phase = [Vx_first_phase, Cell.(['video',num2str(Cell_number_video(index_third_phase(j)))]).([Cell_video_position{index_third_phase(j)}]).( ['cell_', num2str(Cell_name_boolean(index_third_phase(j))), '_info'] ).Vx(starting_points_third(j):end)];
    Vy_third_phase = [Vy_first_phase, Cell.(['video',num2str(Cell_number_video(index_third_phase(j)))]).([Cell_video_position{index_third_phase(j)}]).( ['cell_', num2str(Cell_name_boolean(index_third_phase(j))), '_info'] ).Vy(starting_points_third(j):end)];

end

% Define the desired figure name and dimensions
figureName = 'Speeds in one plot';
figureWidth = 1200; % in pixels
figureHeight = 800; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

% Create the second subplot
subplot(2, 2, 1);
if abs_speed
    histogram(abs(V_third_phase), interval);
else
    histogram(V_third_phase, interval);
end
ylim([0 900]);
ylabel("frequency");
xlabel('V');
grid on;

% Create the third subplot
subplot(2, 2, 2);
if abs_speed
    histogram(abs(Vx_third_phase), interval);
else
    histogram(Vx_third_phase, interval);
end
ylim([0 900]);
ylabel("frequency");
xlabel('Vx');
grid on;

% Create the third subplot
subplot(2, 2, 3);
if abs_speed
    histogram(abs(Vy_third_phase), interval);
else
    histogram(Vy_third_phase, interval);
end
ylim([0 900]);
ylabel("frequency");
xlabel('Vy');
grid on;

if abs_speed
    StrTitle = 'Speeds in one plot (abs)' ;
else
    StrTitle = 'Speeds in one plot (no abs)' ;
end
% Add a title above all the subplots
sgtitle(hFig, StrTitle);

if save_images == 1

    StrTitle = 'Speeds in one plot' ;

    %Example: Saving the figure
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\One_big_plot_speeds\Third_phase\one_plot\',StrTitle,'.png']); % Save the figure as an image
end







