%% load the workspace
addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Workspace\All_data');
load('data_processed.mat');
%%fast cell vs slow cell

Cell_speed_average = zeros(number_of_cells,1);

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        Cell_speed_average(j) = sum(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).V)/Cell_Steps(j);
    end

end
sorted_average_speed = sort(Cell_speed_average);

%% relation between average_speed and frames
average_speed_filtered = [];
Cell_steps_filtered    = [];

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        average_speed_filtered = [average_speed_filtered, Cell_speed_average(j)];
        Cell_steps_filtered    = [Cell_steps_filtered,    Cell_Steps(j)];
    end
end
plot(Cell_steps_filtered(Cell_steps_filtered>1000),average_speed_filtered(Cell_steps_filtered>1000), 'go');
hold on 
plot(Cell_steps_filtered(Cell_steps_filtered<1000),average_speed_filtered(Cell_steps_filtered<1000), 'ro');
hold on 
p = polyfit(Cell_steps_filtered(Cell_steps_filtered>1000),average_speed_filtered(Cell_steps_filtered>1000),1);
x = linspace(1000,3100,500);
y = p(1).*x + p(2);
plot(x,y,'b--')
xlabel('Cell life (time steps)')
ylabel('average speed (pixels/time step)')

%% Feature of the analysis
feature = 'Vx';

%% Parte per la correlazione tra le V

if strcmp(feature, 'V')
    V_mean      = zeros(1,number_of_cells);
    V_variance  = zeros(1,number_of_cells);
end

if strcmp(feature, 'Vx')
    Vx_mean     = zeros(1,number_of_cells);
    Vx_variance = zeros(1,number_of_cells);
end

if strcmp(feature, 'Vy')
    Vy_mean     = zeros(1,number_of_cells);
    Vy_variance = zeros(1,number_of_cells);
end

% mean
for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_mean']) =  ...
            mean(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature));

        if strcmp(feature, 'V')
            V_mean(j) = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_mean']);
        end
        if strcmp(feature, 'Vx')
            Vx_mean(j) = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_mean']);
        end
        if strcmp(feature, 'Vy')
            Vy_mean(j) = Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_mean']);
        end
    end
end

%variance
for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_variance']) = ...
            var(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature),0);

        if strcmp(feature, 'V')
            V_variance(j) =  Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_variance']);
        end
        if strcmp(feature, 'Vx')
            Vx_variance(j) =  Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_variance']);
        end
        if strcmp(feature, 'Vy')
            Vy_variance(j) =  Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).([feature,'_variance']);
        end
    end
end

% %% Autocorrelation by Matlab
% % autocorrelazion
% for j = 1:number_of_cells
%     if Cell_name_boolean(j) == 1
%         [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(['acf_', feature]), ...
%           Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(['lags_', feature]) ...
%         ] = autocorr( ( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature) ...
%                        + V_mean(j)*ones(1,Cell_Steps(j))) ...
%                     );
%     end
% end
% 
% %% plot of the correlations with the lags of matlab
% 
% for j = 1:2
%     if Cell_name_boolean(j) == 1
%         figure(j);
%         stem( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(['lags_', feature]), ...
%               Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(['acf_', feature]) ...
%             )
%         titleString = ['cell ', num2str(Cell_name_boolean(j))];
%         title(titleString);
%         xlabel('lag');
%         titleString = ['Acf of ',feature];
%         ylabel(titleString);
%         hold on
%     end
% end

%% Autocorrelation calculated manually

autocovariance = struct();

autocovariance_inverse = struct();

max_lag = zeros(1,number_of_cells);

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        max_lag(j) = ceil(2/3*Cell_Steps(j));
    end
end

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov = zeros(1,max_lag(j));
        autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags = 0:1:max_lag(j);

        %inverse
        autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov = zeros(1,max_lag(j));
        autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags = 0:1:max_lag(j);        
    end
end

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature) = ...
            Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature)(end:-1:1);
    end
end

Speed_mean = eval(([feature,'_mean']));

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        for k = 1:max_lag(j)
            for i = 1:(Cell_Steps(j)-autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(k))

                autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) = ...
                    autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) ...
                    + (Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature)(i+autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(k))- Speed_mean(j)) ...
                    * (Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature)(i)- Speed_mean(j));
            %inverse
                autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) = ...
                    autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) ...
                    + (autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature)(i+autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(k))- Speed_mean(j)) ...
                    * (autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).(feature)(i)- Speed_mean(j));

            end
            autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) = ...
                autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k)/Cell_Steps(j);

            %inverse
            autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) = ...
                autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k)/Cell_Steps(j);
        
        end
    end
end

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        for k = 1:max_lag(j)
            autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor(k) = ...
                 autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) ...
                /autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(1);

            %inverse
            autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor(k) = ...
                 autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(k) ...
                /autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cov(1);
        end
        autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(end) = [];

        %inverse
        autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(end) = [];
    end
end

% %% video 1 NE
% figure(12)
% j = 1;
% stem(autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(1:21), ...
%      autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor(1:21))
% 
% 
% %% video 1 NW
% figure(13)
% j = 2;
% stem(autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(1:21), ...
%      autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor(1:21))

%% plot autocovariance made by hand

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
    figureName = ['Autocorrelation function of video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    figure('Name', figureName,'NumberTitle', 'off')
    plot(autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(1:20), ...
           autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor(1:20), 'bo')
    xlabel('time (lags)')
    stringy = ['Acf of ', feature];
    ylabel(stringy)
    titleString = ['autocorrelation function of video ', num2str(Cell_number_video(j)), ' ',Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    title(titleString)
    %xlim([0 max_lag(j)])
    hold on
    StrTitle = ['Autocorrelation_function_of_video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
    %saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Autocorrelation_functions\',StrTitle])
    end
end

%% plot autocovariance made by hand loglog
for j = 1:40%number_of_cells
    if Cell_name_boolean(j) == 1
    figureName = ['Loglog Autocorrelation function of video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    figure('Name', figureName,'NumberTitle', 'off')
    loglog(autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags(1:150), ...
           autocovariance.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor(1:150), 'bo')
    xlabel('time (lags)')
    stringy = ['Acf of ', feature];
    ylabel(stringy)
    titleString = ['Loglog autocorrelation function of video ', num2str(Cell_number_video(j)), ' ',Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    title(titleString)
    %xlim([0 max_lag(j)])
    hold on
    StrTitle = ['Loglog_Autocorrelation_function_of_video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
    %saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Loglog_autocorrelation_functions\',StrTitle])
    end
end

%% plot inverse autocovariance made by hand

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
    figureName = ['Inverse autocorrelation function of video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    figure('Name', figureName,'NumberTitle', 'off')
    plot(autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags, ...
         autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor, 'bo')
    xlabel('time (lags)')
    stringy = ['Inverse Acf of ', feature];
    ylabel(stringy)
    titleString = ['Inverse autocorrelation function of video ', num2str(Cell_number_video(j)), ' ',Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    title(titleString)
    xlim([0 max_lag(j)])
    hold on
    StrTitle = ['Inverse_autocorrelation_function_of_video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, '_cell_', num2str(Cell_name_boolean(j))];
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Inverse_autocorrelation_functions\',StrTitle]);
    end
end

%% plot inverse autocovariance made by hand loglog
for j = 1:60%number_of_cells
    if Cell_name_boolean(j) == 1
    figureName = ['Loglog Inverse autocorrelation function of video ', num2str(Cell_number_video(j)), ' ', Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    figure('Name', figureName,'NumberTitle', 'off')
    loglog(autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).lags, ...
           autocovariance_inverse.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).aut_cor, 'bo')
    xlabel('time (lags)')
    stringy = ['Inverse acf of ', feature];
    ylabel(stringy)
    titleString = ['Loglog inverse autocorrelation function of video ', num2str(Cell_number_video(j)), ' ',Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
    title(titleString)
    xlim([0 max_lag(j)])
    hold on
    StrTitle = ['Loglog_Inverse_autocorrelation_function_of_video_', num2str(Cell_number_video(j)), '_', Cell_video_position{j}, ' _cell_', num2str(Cell_name_boolean(j))];
    saveas(gcf, ['C:\Users\huang\OneDrive - Politecnico di Torino\Desktop\Materials for final thesis\T_cells\Images\Loglog_inverse_autocorrelation_functions\',StrTitle]);
    end
end

%% Display of the plots in a more visual pleasing way
save_images = 1;
%There is an error in the loading

% for j = 1:2%number_of_cells
% 
%     if Cell_name_boolean(j) == 1
% 
%         One_big_plot_acf(autocovariance, autocovariance_inverse, Cell, Cell_name_boolean(j), Cell_Steps(j), Cell_number_video(j), Cell_video_position{j}, feature, save_images)
% 
%     end
% 
% end
% 
% disp('All the plots has been processed and saved, please wait for the display.')
% 
% 


%% one single histograms for the speed
interval = 40;

V_all  = [];
Vx_all = [];
Vy_all = [];

if strcmp(feature, 'V')
    vector_of_bins = linspace(0, interval, interval-1);
    clear Vx_all Vy_all
end
if strcmp(feature, 'Vx')
    vector_of_bins = linspace(-interval, interval, interval);
    clear V_all Vy_all
end
if strcmp(feature, 'Vy')
   vector_of_bins = linspace(-interval, interval, interval);
    clear V_all Vx_all
end


for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        if strcmp(feature, 'V') 
            V_all   = [V_all,  Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).V];
            
        end
        if strcmp(feature, 'Vx')
            Vx_all  = [Vx_all, Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).Vx];
        end
        if strcmp(feature, 'Vy')
            Vy_all  = [Vy_all, Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).Vy];
        end
    end

end


if strcmp(feature, 'V')
    %V_all(V_all>25)= [];
    [frequency_all_vector,V_all_vector] = hist(V_all, vector_of_bins);
    V_all_mean = mean(V_all_vector);
    V_all_var = var(V_all_vector);

end
if strcmp(feature, 'Vx')
    Vx_all(Vx_all>25)= [];
    [frequency_all_vector,Vx_all_vector] = hist(Vx_all, vector_of_bins);
    Vx_all_mean = mean(Vx_all_vector);
    Vx_all_var = var(Vx_all_vector);

end
if strcmp(feature, 'Vy')
    Vy_all(Vy_all>25)= [];
    [frequency_all_vector,Vy_all_vector] = hist(Vy_all, vector_of_bins);
    Vy_all_mean = mean(Vy_all_vector);
    Vy_all_var = var(Vy_all_vector);

end


% if strcmp(feature, 'V')
%     V_all_vector = V_all_vector/max(V_all_vector);
% elseif strcmp(feature, 'Vx')
%     Vx_all_vector = Vx_all_vector/max(Vx_all_vector);
% elseif strcmp(feature, 'Vy')
%     Vy_all_vector = Vy_all_vector/max(Vy_all_vector);
% end

pdf_real_data = frequency_all_vector/sum(frequency_all_vector);

cdf_real_data = zeros(1,length(frequency_all_vector));

for j = 1:length(frequency_all_vector)
    cdf_real_data = cdf_real_data + [zeros(1,j-1), pdf_real_data(j)*ones(1,length(frequency_all_vector)-(j-1))];
end

if strcmp(feature, 'V')
    plot(V_all_vector,  pdf_real_data,'b*')
elseif strcmp(feature, 'Vx')
    plot(Vx_all_vector, pdf_real_data,'b*')
elseif strcmp(feature, 'Vy')
    plot(Vy_all_vector, pdf_real_data,'b*')
end
%%
 plot(Vy_all_vector, pdf_real_data,'b')
 hold on
 X = linspace(-interval,interval,10*interval);
 Y = normpdf(X,0,2.1);
plot(X,Y,'r')

%%
plot(V_all_vector, pdf_real_data,'b*')
hold on
X = linspace(-interval,2,10*interval);
Y = normpdf(X,3.8,1.7);
plot(X,Y,'r--')
hold on
X_1 = linspace(3,interval,10*interval);
a = 2;
Y_1 = a./X_1;
plot(X_1(30:end),Y_1(30:end),'r--')
hold on
b = 2;
Y_2 = b./X_1.^2;
plot(X_1,Y_2,'g--');
hold on
 c = 4.3;
 Y_3 =  c./(X_1+1.6).^2;
 plot(X_1,Y_3,'m--');
xlim([0,25]);
legend('real data','normal distribution', '2/V', '2/V^2', '4.3/(V+1.6)^2')
%% Plot of the feature 
 if strcmp(feature, 'V')
    figureName = 'Distribution of the frequency of V';
    figure('Name', figureName,'NumberTitle', 'off')
    plot(V_all_vector, pdf_real_data);
    ylabel("frequency");
    xlabel('V');
    grid on;
    StrTitle = ['Distribution of the frequency of V n° of bins ', num2str(interval)];
    title(StrTitle);
    %saveas(gcf, StrTitle)

end
if strcmp(feature, 'Vx')
    figureName = 'Distribution of the frequency of Vx';
    figure('Name', figureName,'NumberTitle', 'off')
    plot(Vx_all_vector, pdf_real_data);
    ylabel("frequency");
    xlabel('Vx');
    grid on;
    StrTitle = ['Distribution of the frequency of Vx n° of bins ', num2str(interval)];
    %saveas(gcf, StrTitle)
end
if strcmp(feature, 'Vy')
    figureName = 'Distribution of the frequency of Vy';
    figure('Name', figureName,'NumberTitle', 'off')
    plot(Vy_all_vector, pdf_real_data);
    ylabel("frequency");
    xlabel('Vy');
    grid on;
    StrTitle = ['Distribution of the frequency of Vy n° of bins ', num2str(interval)];
    %saveas(gcf, StrTitle)
end

 if strcmp(feature, 'V')
    figureName = 'Distribution loglog of the frequency of V';
    figure('Name', figureName,'NumberTitle', 'off')
    loglog(V_all_vector, pdf_real_data, 'bo');
    ylabel("frequency");
    xlabel('V');
    grid on;
    StrTitle = ['Distribution loglog of the frequency of V n° of bins ', num2str(interval)];
    title(StrTitle);
    %saveas(gcf, StrTitle)

end
if strcmp(feature, 'Vx')
    figureName = 'Distribution loglog of the frequency of Vx';
    figure('Name', figureName,'NumberTitle', 'off')
    loglog(Vx_all_vector, pdf_real_data,'bo');
    ylabel("frequency");
    xlabel('Vx');
    grid on;
    StrTitle = ['Distribution loglog of the frequency of Vx n° of bins ', num2str(interval)];
    title(StrTitle);
    %saveas(gcf, StrTitle)
end
if strcmp(feature, 'Vy')
    figureName = 'Distribution of the frequency of Vy';
    figure('Name', figureName,'NumberTitle', 'off')
    loglog(Vy_all_vector, pdf_real_data,'bo');
    ylabel("frequency");
    xlabel('Vy');
    grid on;
    StrTitle = ['Distribution loglog of the frequency of Vy n° of bins ', num2str(interval)];
    title(StrTitle);
    %saveas(gcf, StrTitle)
end

%% log-normal?
% Value for how many subclasses one want for the hystogram


X = linspace(0,70,1000); %[linspace(0,0.001,1000),0.001:0.001:1];  % Example values

MU = log(V_all_mean^2/sqrt(V_all_mean^2+V_all_var^2));      % Mean of the natural log of the distribution
SIGMA = log(1 + (V_all_var/V_all_mean)^2);                  % Standard deviation of the natural log of the distribution
Y =   lognpdf(X, MU, SIGMA); %lognpdf(X, 1.5, 0.8);

plot(X, Y, 'b'); 
%hold on
%plot(V_all_vector, pdf_real_data, 'r*')


%plot(V_all_vector/max(V_all_vector), frequency_all_vector/sum(frequency_all_vector), 'r*')

%% gamma ??
figure(100)
% Parameters of the gamma distribution
shape_parameter = V_all_mean^2/V_all_var;
scale_parameter = V_all_var/V_all_mean;

% Define values at which to compute the PDF
x_values = 0:0.1:100;

% Compute the PDF of the gamma distribution
pdf_values = gampdf(x_values, 2.77, 2.6);%gampdf(x_values, shape_parameter, scale_parameter);

%x_values_normalized = x_values/x_values(end);

plot(x_values, pdf_values, 'b')
hold on

plot(V_all_vector, pdf_real_data, 'r*')
%plot(V_all_vector/max(V_all_vector), frequency_all_vector/sum(frequency_all_vector), 'r*')
%% Fit model 
% Define the model function
f = fittype(@(a, b, c, x) a * x.^b .* exp(-x./c));

% Transpose the row vectors to column vectors
speed_sample = speed_sample(:); % Transpose to make it a column vector
frequency_sample = frequency_sample(:); % Transpose to make it a column vector

% Check the size and format of the transposed data
disp(size(speed_sample));
disp(size(frequency_sample));


% Fit the model to the data
mdl = fit(speed_sample, frequency_sample, f);

% Evaluate the fitted model
y_fit = feval(mdl, speed_sample); % Corrected typo

% Plot the original data and the fitted curve
plot(speed_sample, frequency_sample, 'b.', speed_sample, y_fit, 'r');
xlabel('Speed');
ylabel('Frequency');
legend('Data', 'Fitted Curve');
title('Curve Fitting');


%% Polarization ?

for j = 1:number_of_cells
   Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).Phi = zeros(1,2);
end

Phi = zeros(1,number_of_cells);

for j = 1:number_of_cells

    for i = 1:Cell_Steps(j) 

        if Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).V(i) > 0 %there are cases where the V is zero
        
           Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).Phi =   Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).Phi ...
                                                                        + [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).Vx(i), ...
                                                                            Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).Vy(i) ]...
                                                                        /  (Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).V(i)*Cell_Steps(j));
        end

    end
    
    Phi(j) = norm(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).Phi);%/Cell_Steps(j);
   
end



%% datasets of V are distributed as a log-normal ??

for j = 1:number_of_cells
    figure(j)
    plot(log(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).V_speed),Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).V_frequency, 'bo')
    hold on
end

%% All datasets of V as log normal??

interval = 35;


for i = 1:length(Str_statistics)

    if eval(['A_',Str_statistics{i}])

        for j = 1:number_of_cells

            if i<=2

                Cell.(['gamma_',Str_statistics{i}]) = zeros(1,number_of_cells);



                [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_gamma']), ...
                  Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_alpha']) ...
                ] = ...
                    linear_regression(Cell, Cell_name_boolean(j), Cell_Steps(j), Str_statistics{i});

                Cell.(['gamma_',Str_statistics{i}])(j) = ...
                Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_gamma']);

            elseif i==3  % mettere abs?

                [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_frequency']), ...
                  Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_speed']) ...
                ] = hist(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i}),interval);

                [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+1},'_frequency']), ...
                  Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+1},'_speed']) ...
                ] = hist(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i+1}),interval);

                [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+2},'_frequency']), ...
                  Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i+2},'_speed']) ...
                ] = hist(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i+2}),interval);


            elseif i==4 % mettere abs?

                [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_frequency']), ...
                  Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_speed']) ...
                ] = hist(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i}),interval);

            elseif i==5 % mettere abs?

                [ Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_frequency']), ...
                  Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).([Str_statistics{i},'_speed']) ...
                    ] = hist(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).(Str_statistics{i}),interval);

            end
        end

    end
end

[frequency_sample, speed_sample] =hist(v_sample,interval);


figure(100)
plot(log(speed_sample), frequency_sample, 'bo')
xlabel('log(speed)')
ylabel('frequency')
