%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Analysis of MSD and MD %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% load the workspace
addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Workspace\All_data');
load('data_processed.mat');

%% Analysis of the MSD of all the cells 1

% Pre-part for the mean and variance of the MSD (since all the cells were recorded from different stages of their life, it is safe to assume
% the frame right before mytosis is the same.)
addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Info_centroidi_da_Excel')
[average_steps_No_Cell1, average_steps_cell1, counter_Steps_No_Cell1, index_over_threshold_Cell_1, Cell_Steps_filtered, filename_filtered] = Average_Cell1_Steps();

numbers_of_cell_1 =  length(index_over_threshold_Cell_1); %sum(Cell_name_boolean==1);
Cell_1_steps      = zeros(1,numbers_of_cell_1);

i = 1;
for j = index_over_threshold_Cell_1 %1:number_of_cells %
    if Cell_name_boolean(j) == 1
        Cell_1_steps(i) = Cell_Steps(j);
        i = i+1;
    end
end

Cell_1_steps_sorted = sort(Cell_1_steps);


%Matrix for counting the repetition of each cell's steps
n = length(Cell_1_steps_sorted) * ones(1,Cell_1_steps_sorted(end));

sorting_matrix      = ones(length(unique(Cell_1_steps_sorted)),2);
sorting_matrix(:,1) = unique(Cell_1_steps_sorted);

for j = 1:length(sorting_matrix(:,1)) - 1
    
    while Cell_1_steps_sorted(j) == Cell_1_steps_sorted(j+1)
        Cell_1_steps_sorted(j) = [];
        sorting_matrix(j,2) = sorting_matrix(j,2) + 1;
    end

end

%Trim of the largest numbers if there are more than 1
while Cell_1_steps_sorted(end) == Cell_1_steps_sorted(end-1)
    Cell_1_steps_sorted(end) = [];
    sorting_matrix(end,2) = sorting_matrix(end,2) + 1;
end

n = sum(sorting_matrix(:,2)) * ones(1,sorting_matrix(1,1));
n_decreasing = sum(sorting_matrix(:,2));

for j = 2:length(sorting_matrix(:,1))

    n_decreasing = n_decreasing - sorting_matrix(j-1,2);
    n = [n, n_decreasing * ones(1,sorting_matrix(j,1)-sorting_matrix(j-1,1))];
    
end

%% calculus for the dMSD distribution MSD that will come later

for j = 1:number_of_cells
    if Cell_name_boolean(j) == 1
        Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).dMSD = Calculate_dMSD(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX, ...                                 
                                                                                                                                                              Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY );
 
    end
end


%%  mean and variance of the dMSDs, try for initiating at the same time and have different end

clear Trace_of_dMSD
Matrix_dMSD_cell_0 = zeros(numbers_of_cell_1,length(n));

t = linspace(1,length(n)-1,length(n)-1);

i = 1;

for j = index_over_threshold_Cell_1 %1:number_of_cells
    if Cell_name_boolean(j) == 1
        Matrix_dMSD_cell_0(i,:) = [ Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).dMSD(1:end), ...
                                   zeros(1, Cell_1_steps_sorted(end) - Cell_Steps(j))];
        Trace_of_dMSD(i,:) =      [ zeros(1, Cell_1_steps_sorted(end) - Cell_Steps(j)), ...
            ones(1, length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).dMSD(1:end)))];

        i = i + 1;
    end
end

dMSD_mean = zeros(1,length(n)-1);
dMSD_var  = zeros(1,length(n)-1);


for i = 1:length(n)-1

    dMSD_mean(1,i) = sum(Matrix_dMSD_cell_0(:,i))/n(i);
    if n(i) ~= 1
        dMSD_var(1,i) = sum((Trace_of_dMSD(:,i).*(Matrix_dMSD_cell_0(:,i) - dMSD_mean(1,i)*Trace_of_dMSD(:,i))).^2)/(n(i)-1);
    end

end

% gamma of the dMSD
min_steps = min(Cell_Steps_filtered);
p = polyfit(log(t(2:round(0.66*min_steps))), log(dMSD_mean(2:round(0.66*min_steps))),1);    %polyfit(log(t(1:0.5*min_steps)), log(MSD_mean(1:0.5*min_steps)),1);
gamma_MSD_mean = p(1);
alpha_MSD_mean = exp(p(2));

sigma_MSD = sqrt(dMSD_var);

y = alpha_MSD_mean.*t(2:round(0.66*min_steps)).^gamma_MSD_mean;

%% plot of MSD
figureName = ['<MSD> over t'];
figureWidth = 600; % in pixels
figureHeight = 400; % in pixels
% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [150, 150, figureWidth, figureHeight]);

t = linspace(1,length(n)-1,length(n)-1);
loglog(t(2:round(0.66*min_steps)), dMSD_mean(2:round(0.66*min_steps)), 'bo')
hold on
%plot(t(1:min(Cell_Steps_filtered)) , MSD_mean(1:min(Cell_Steps_filtered))  + sigma_MSD(1:min(Cell_Steps_filtered)) , 'r*');
%hold on
%plot(t(1:min(Cell_Steps_filtered)) , MSD_mean(1:min(Cell_Steps_filtered))  - sigma_MSD(1:min(Cell_Steps_filtered)) , 'r*');
loglog(t(2:round(0.66*min_steps)),y, 'r')
xlabel('t');
ylabel('MSD')
strTitle = '<MSD> over t';
title(strTitle);
string = ['Power-law with \gamma = ',num2str(round(gamma_MSD_mean,2))];
legend('<MSD> in time', string,'Location', 'northwest');

%% mean and variance of the MSDs, same ends, different start
%get the correct number of n for the mean and var

n = sort(n);
i = 1;

%length(n)-1 is used and not length(n) because the first point of MSD is
%zero and it gives many numberical errors
Matrix_MSD_cell_1 = zeros(numbers_of_cell_1,length(n)-1);
%Trace_of_MSD is needed for the calculus of variance, in case the MSD(i) = 0
Trace_of_dMSD      = zeros(numbers_of_cell_1,length(n)-1);

for j = index_over_threshold_Cell_1 %1:number_of_cells %
    if Cell_name_boolean(j) == 1
        Matrix_MSD_cell_1(i,:) = [ zeros(1, Cell_1_steps_sorted(end) - Cell_Steps(j)), ...
                                   Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MSD(1:end)];
        Trace_of_dMSD(i,:) =      [ zeros(1, Cell_1_steps_sorted(end) - Cell_Steps(j)), ...
                                   ones(1, length(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MSD(1:end)))];
        i = i + 1;
    end
end

dMSD_mean = zeros(1,length(n)-1);
dMSD_var  = zeros(1,length(n)-1);


for i = 1:length(n)-1

    dMSD_mean(1,i) = sum(Matrix_dMSD_cell_0(:,i))/n(i);
    if n(i) ~= 1
        dMSD_var(1,i) = sum((Trace_of_dMSD(:,i).*(Matrix_dMSD_cell_0(:,i) - dMSD_mean(1,i)*Trace_of_dMSD(:,i))).^2)/(n(i)-1);
    end

end
max_steps = max(Cell_Steps_filtered);
min_steps = min(Cell_Steps_filtered);
p = polyfit(log(t(max_steps-0.5*min_steps+1:end-100)), log(dMSD_mean(max_steps-0.5*min_steps+1:end-100)),1);
gamma_MSD_mean = p(1);
alpha_MSD_mean = exp(p(2));

sigma_MSD = sqrt(dMSD_var);

%% Plot of the MSD

t = linspace(1,length(n)-1,length(n)-1);
plot(t(max_steps-0.5*min_steps+1:end-100), dMSD_mean(max_steps-0.5*min_steps+1:end-100), 'bo')
hold on
plot(t , dMSD_mean  + sigma_MSD , 'r*');
hold on
plot(t , dMSD_mean  - sigma_MSD , 'r*');


%%
loglog(t(2000:end), dMSD_mean(2000:end), 'bo')
p = polyfit(t(2000:end), log(dMSD_mean(2000:end)),1);


%% Mitosis MSD

addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Info_centroidi_da_Excel')
[average_steps_No_Cell1, average_steps_cell1, counter_Steps_No_Cell1, index_over_threshold_Cell_1, Cell_Steps_filtered, filename_filtered] = Average_Cell1_Steps();
estimation_mitosis_life_time();

starting_point_mitosis = Cell_Steps - expected_time_mitosis';

% TAMSD
 slope.mitosis.gamma_MSD = zeros(1,number_of_cells);
 slope.mitosis.alpha_MSD = zeros(1,number_of_cells);
for j = 1:number_of_cells

            if Cell_name_boolean(j) == 1
                if starting_point_mitosis(j) <= 0
                    starting_point_mitosis(j) = 1;
                end
                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MSD_mithosis = Calculate_MSD( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX(starting_point_mitosis(j):end), ...
                                                                                                                                                                              Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY(starting_point_mitosis(j):end));

            if expected_time_mitosis(j) < 4000
            expected_time = expected_time_mitosis(j);
            else 
                expected_time = expected_time_mitosis(j)/1000;
            end
            p = polyfit(log(1:1:expected_time), log(Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).MSD_mithosis),1);
            slope.mitosis.gamma_MSD(j) = p(1);
            slope.mitosis.alpha_MSD(j)  = exp(p(2));
            end
end

%% dMSD
addpath('C:\Users\HUAWEI\Desktop\Materials for final thesis\T_cells\Codici_Matlab\Analysis_of_statistics')
for j = 1:number_of_cells

            if Cell_name_boolean(j) == 1
                if starting_point_mitosis(j) <= 0
                    starting_point_mitosis(j) = 1;
                end
                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).dMSD_mithosis = Calculate_dMSD( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cX(starting_point_mitosis(j):end), ...
                                                                                                                                                                                Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).cY(starting_point_mitosis(j):end));
            end
end

%dMSD just for the suitable candidates

min_time_mitosis  = min(expected_time_mitosis(index_over_threshold_Cell_1));
dMSD_mean_mitosis = zeros(1,min_time_mitosis);

for j = index_over_threshold_Cell_1
    dMSD_mean_mitosis = dMSD_mean_mitosis + Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).( ['cell_', num2str(Cell_name_boolean(j)), '_info'] ).dMSD_mithosis(end-min_time_mitosis+1:end);
end

dMSD_mean_mitosis = dMSD_mean_mitosis/length(index_over_threshold_Cell_1);

%find the possible power-law of the dMSD of the mitosis
p = polyfit(log(2:1:min_time_mitosis), log(dMSD_mean_mitosis(2:end)),1);
gamma_MSD_mean_mitosis = p(1);
alpha_MSD_mean_mitosis = exp(p(2));

t = linspace(3,min_time_mitosis,1000);
y = alpha_MSD_mean_mitosis.*t.^gamma_MSD_mean_mitosis;

% Define the desired figure name and dimensions
figureName = 'Distributional MSD of the Mitosis over the chosen Cell1s';
figureWidth = 600; % in pixels
figureHeight = 400; % in pixels

% Create the figure with the specified dimensions
hFig = figure('Name', figureName, 'NumberTitle', 'off', 'Position', [0, 0, figureWidth, figureHeight]);

loglog(1:1:min_time_mitosis,dMSD_mean_mitosis,'bo')
hold on
loglog(t,y,'r')
xlabel('time');
ylabel('<MSD>');
string = ['Power-law with \gamma = ',num2str(round(gamma_MSD_mean_mitosis,2))];
legend('<MSD> in time', string,'Location', 'northwest');

%%
clear i j n_decreasing sorting_matrix  cell_1_steps number_of_cells_1


%% Plot of the rooted MSD with sqrt(t) and MD with sqrt t 

% for j =1:number_of_cells
% 
%     t = linspace(1,Cell_Steps(j),Cell_Steps(j));
%     t_sqrt = sqrt(t);
% 
%     figure(j)
%     plot(t_sqrt,sqrt(Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).MSD), 'r*')
%     hold on
% 
%     plot(t_sqrt,Cell.(['cell_', num2str(Cell_name_boolean(j)), '_info']).MD, 'bo')
% 
%     titleString = ['cell ', num2str(Cell_name_boolean(j))];
%     title(titleString)
%     xlabel('sqrt(time)')
%     %ylabel('MD')
%     xlim([0,t_sqrt(end)])
%     legend('sqrt(MSD)', 'MD')
%     hold on
% 
% end



%% plot of the singular MSD 

for j = 1:number_of_cells
    t = linspace(1,Cell_Steps(j),Cell_Steps(j));
    if Cell_name_boolean(j) == 1 
        figure(j)
        plot(t,Cell.(['video',num2str(Cell_number_video(j))]).(Cell_video_position{j}).(['cell_', num2str(Cell_name_boolean(j)), '_info']).MSD)
        titleString = ['video ', num2str(Cell_number_video(j)), ' ',Cell_video_position{j}, ' cell ', num2str(Cell_name_boolean(j))];
        title(titleString)
        xlabel('time')
        ylabel('MSD') 
        xlim([0,Cell_Steps(j)])
    end
end

%% Analysis of the slopes in the first and third phase

% slope.first_third_phase = struct();
% 
% slope.first_third_phase = First_and_third_phase_slopes(Cell, Cell_number_video, Cell_video_position, Cell_name_boolean);


% %% Post Analysis of the slopes AFTER the previous one (it is important since the code will be running based on the structure slope.first_third_phase):
% 
% n_points_considered = 400;
% slope.third_phase_old_MSD = struct();
% 
% for j = 1:number_of_cells
%     if slope.first_third_phase.points(j,3)> 0
%         [ slope.third_phase_old_MSD.gamma(j,1), ...
%           slope.third_phase_old_MSD.alpha(j,1) ] = Third_phase_old_MSD( Cell.(['video',num2str(Cell_number_video(j))]).([Cell_video_position{j}]).(['cell_',num2str(Cell_name_boolean(j)),'_info']).MSD, ...
%                                                                       n_points_considered);
%     %else slope.third_phase_old_MSD.gamma(j,1) = NaN;
%     %     slope.third_phase_old_MSD.alpha(j,1) = NaN;
%     end
% end
% 
% slope.third_phase_old_MSD.gamma(92,1) = 0;
% slope.third_phase_old_MSD.alpha(92,1) = 0;

