function [] = Sketch2D(Lb,theta_f,Dbe,Mach,x_lesuLb,lambda_mezzi,Wspan,...
    lambda,croot,theta_r,air_intakesuWspan,i)

        % unità di misura
        Lb=Lb*0.3048; % [m]
        Dbe=Dbe*0.3048; % [m]
        Wspan=Wspan*0.3048; % [m]
        
       if i>=5
          air_inflow=Wspan*air_intakesuWspan;

          % punti
          y1=air_inflow/2;
          x1=Lb;
          y2=Wspan/2;

          % Sketch

          figure
          % presa d'aria
          plot([0,0],[0,y1],[0,0],-[0,y1],'-','Color','black')
          hold on
          % wing
          plot([0,x1],[y1,y2],[0,x1],-[y1,y2],'-','Color','black')
          hold on
          % apparato propulsivo
          plot([0,x1],[y1,y1],[0,x1],-[y1,y1],'-','Color','black')
          hold on
          % poppa
          plot([x1,x1],[y2,0],[x1,x1],-[y2,0],'-','Color','black')
          axis([0 Lb -Lb/2 Lb/2])
          xlabel('m')
          ylabel('m')

          if i==5
          title('2D StratoFly MR5 config')
          end
          if i==6
           title('2D StratoFly MR3 config')
          end


       else
                
        % cono di Mach
        cone=@(x) x*tan(asin(1/Mach));
        x_cone=linspace(0,x_lesuLb*Lb,10000);
        % prua fusoliera
        fore=@(x) tan(theta_f)*x;
        x1=Dbe/(2*tan(theta_f));
        x_fore=linspace(0,x1,10000);
        y1=fore(x1);
        % fusoliera
        x2=x_lesuLb*Lb;
        y2=y1;
        x_fus=linspace(x1,x2,1000);
        y_fus=ones(length(x_fus),1)*y2;
        % WING
        % leading edge
        y3=(Wspan)/2;
        x3=(y3-y2)/tan(lambda_mezzi)+x2;
        x_lead_edge=linspace(x2,x3,1000);
        lead_edge=@(x) x*tan(lambda_mezzi)+y2-tan(lambda_mezzi)*x2;
        % tip
        x4=x3+croot*lambda;
        y4=y3;
        x_tip=linspace(x3,x4,1000);
        y_tip=ones(length(x_tip),1)*y4;
        % trailing edge
        x5=x2+croot;
        y5=y1;
        x_trail_edge=linspace(x4,x5,1000);
        trail_edge=@(x) (x-x4)*(y5-y4)/(x5-x4)+y4;
        % tail
        x7=Lb;
        f_check=@(x) (x-x7)*-tan(theta_r);
        if f_check(x5)<= y5
           x6=x7;
           y6=y5-f_check(x5);
           x_tail1=linspace(x5,x6,1000);
           tail1=@(x) (x-x5)*(y6-y5)/(x6-x5)+y5;
           tail1=tail1(x_tail1);
           x_tail2=[x6,x7];
           tail2=[y6,0];
        else
            y6=y5;
            x6=y6/-tan(theta_r)+x7;
            x_tail1=linspace(x5,x6,1000);
            tail1=ones(length(x_tail1),1)*y6;
            x_tail2=linspace(x6,x7,1000);
            tail2=@(x) (x-x7)*-y6/(x7-x6);
            tail2=tail2(x_tail2);
        end




        figure
        plot(x_cone,cone(x_cone),x_cone,-cone(x_cone),'-','Color','blue')
        hold on
        plot(x_fore,fore(x_fore),x_fore,-fore(x_fore),'-','Color','black')
        hold on
        plot(x_fus,y_fus,x_fus,-y_fus,'-','Color','black')
        hold on
        plot(x_lead_edge,lead_edge(x_lead_edge),x_lead_edge,-lead_edge(x_lead_edge),'-','Color','black')
        hold on
        plot(x_tip,y_tip,x_tip,-y_tip,'-','Color','black')
        hold on
        plot(x_trail_edge,trail_edge(x_trail_edge),x_trail_edge,-trail_edge(x_trail_edge),'-','Color','black')
        hold on
        plot(x_tail1,tail1,x_tail1,-tail1,'-','Color','black')
        hold on
        plot(x_tail2,tail2,x_tail2,-tail2,'-','Color','black')
        axis([0 Lb -Lb/2 Lb/2])
        if i==1
            title('2D Sketch Rockwell config')
        end
        if i==2
            title('2D Sketch Hycat-1A config')
        end
        if i==3
            title('2D Sketch Hycat-1 config')
        end
        if i==4
            title('2D Sketch Hycat-4 config')
        end
        
        xlabel('m')
        ylabel('m')
        legend('Mach Angle')
       end
end  
