function plot_solutions3D(V_i,H_i,Mach,HT_stagnation,gamma_i,P_dynamic,Re,heat_load,t_i,r_i,a)

%Velocity vs. Altitude
fig1 = figure('Name', 'Velocity vs. Altitude');
hold on;
set(fig1, 'Position', [15 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Velocity vs. Altitude}')
plot(V_i, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Velocity $\left( \mathrm{m} / \mathrm{s} \right)$");
grid on;
grid minor;
hold off;

% Acceleration vs. Altitude
fig2 = figure('Name', 'Acceleration vs. Altitude');
hold on;
set(fig2, 'Position', [400 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Acceleration vs. Altitude}')
plot(-a, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("\textbf{Altitude} $\left( \mathrm{km} \right)$");
xlabel("\textbf{Acceleration} [g]");
ylim([0 120])
% xlim([0 1.6])
grid on;
grid minor;
box on;
hold off;

%Mach vs. Altitude
fig3 = figure('Name', 'Mach vs. Altitude');
hold on;
set(fig3,'Position', [785 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Mach Number vs. Altitude}')
plot(Mach, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Mach");
ylim([0 120])
grid on;
grid minor;
hold off;


%Stagnation Point Heat Transfer vs. Altitude
fig4 = figure('Name', 'Stagnation Point Heat Transfer vs. Altitude');
hold on;
title('\textbf{Stagnation Point Heat Transfer vs. Altitude}')
set(fig4, 'Position', [1170 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(HT_stagnation, H_i/1e3, 'LineWidth',2,'Color','r');
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Stagnation Point Heat Transfer $\left( \mathrm{W} / \mathrm{m}^2 \right)$");
grid on;
grid minor;
hold off;

%Flight Path Angle vs. Altitude
fig5 = figure('Name', 'Flight Path Angle vs. Altitude');
hold on;
title('\textbf{Flight Path Angle vs. Altitude}')
set(fig5,'Position', [15 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(-gamma_i*180/pi, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Flight Path Angle $\left( \mathrm{deg} \right)$");
grid on;
grid minor;
hold off;
ylim([0 120])

% Dynamic Pressure vs. Altitude
fig6 = figure('Name', 'Dynamic Pressure vs. Altitude');
hold on;
title('\textbf{Dynamic Pressure vs. Altitude}')
set(fig6, 'Position', [400 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(P_dynamic, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Dynamic Pressure $\left( \mathrm{Pa} \right)$");
grid on;
grid minor;
hold off;
ylim([0 120])


%Reynolds vs. Altitude
fig7 = figure('Name', 'Reynolds vs. Altitude');
hold on;
title('\textbf{Reynolds vs. Altitude}')
set(fig7, 'Position', [785 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Reynolds vs. Altitude}')
plot(Re, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Reynolds number ");
grid on;
grid minor;
hold off;

%Heat Load
fig8 = figure('Name', 'Heat Load');
hold on;
title('\textbf{Heat Load}')
set(fig8, 'Position', [1170 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Heat Load}')
plot(t_i,heat_load, 'Color','r', 'LineWidth',1.5)
ylabel("Heat Load $\left( \mathrm{J} / \mathrm{m}^2 \right)$");
xlabel("Time [s] ");
grid on;
grid minor;
hold off;

%Range vs. Altitude
fig9 = figure('Name', 'Range vs. Altitude');
hold on;
set(fig9,'Position', [15 45 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Range vs. Altitude}')
plot(r_i/1e3, H_i/1e3, 'LineWidth',2,'Color',[0.4940 0.1840 0.5560]);
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Range $\left( \mathrm{km} \right)$");
grid on;
grid minor;
hold off;