function plot_results_gamma(gamma_values, results)

colors = lines(length(gamma_values)); % Genera un array di colori per differenziare le curve
lineWidth = 0.8; % Imposta lo spessore delle linee

legend_str = {sprintf('$\\gamma_0 = %.1f \\ %s$', gamma_values(1), '^\circ')};
for i = 2:length(gamma_values)
     legend_str(end+1) = {sprintf('$\\gamma_0 = %.1f \\ %s$', gamma_values(i), '^\circ')}; %#ok<AGROW>
end

% Velocity vs. Altitude
fig1 = figure('Name', 'Velocity vs. Altitude');
hold on;
set(fig1, 'Position', [15 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Velocity vs. Altitude}');
for i = 1:length(gamma_values)
    plot(results{i}.V_i, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Velocity $\left( \mathrm{m} / \mathrm{s} \right)$");
legend(legend_str, 'location', 'northwest');
grid on;
grid minor;
hold off;

% Acceleration vs. Altitude
fig2 = figure('Name', 'Acceleration vs. Altitude');
hold on;
set(fig2, 'Position', [400 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Acceleration vs. Altitude}');
for i = 1:length(gamma_values)
    plot(-results{i}.a, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("\textbf{Altitude} $\left( \mathrm{km} \right)$");
xlabel("\textbf{Acceleration} [g]");
ylim([0 120]);
grid on;
grid minor;
box on;
legend(legend_str, 'location', 'northeast');
hold off;

% Mach vs. Altitude
fig3 = figure('Name', 'Mach vs. Altitude');
hold on;
set(fig3,'Position', [785 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Mach Number vs. Altitude}');
for i = 1:length(gamma_values)
    plot(results{i}.Mach, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Mach");
ylim([0 120]);
grid on;
grid minor;
legend(legend_str, 'location', 'northwest');
hold off;

% Stagnation Point Heat Transfer vs. Altitude
fig4 = figure('Name', 'Stagnation Point Heat Transfer vs. Altitude');
hold on;
title('\textbf{Stagnation Point Heat Transfer vs. Altitude}');
set(fig4, 'Position', [1170 565 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
for i = 1:length(gamma_values)
    plot(results{i}.HT_stagnation, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Stagnation Point Heat Transfer $\left( \mathrm{W} / \mathrm{m}^2 \right)$");
grid on;
grid minor;
legend(legend_str, 'location', 'southeast');
hold off;

% Flight Path Angle vs. Altitude
fig5 = figure('Name', 'Flight Path Angle vs. Altitude');
hold on;
title('\textbf{Flight Path Angle vs. Altitude}');
set(fig5,'Position', [15 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
for i = 1:length(gamma_values)
    plot(-results{i}.gamma_i*180/pi, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Flight Path Angle $\left( \mathrm{deg} \right)$");
ylim([0 120]);
grid on;
grid minor;
legend(legend_str, 'location', 'northwest');
hold off;

% Dynamic Pressure vs. Altitude
fig6 = figure('Name', 'Dynamic Pressure vs. Altitude');
hold on;
title('\textbf{Dynamic Pressure vs. Altitude}');
set(fig6, 'Position', [400 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
for i = 1:length(gamma_values)
    plot(results{i}.P_dynamic, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Dynamic Pressure $\left( \mathrm{Pa} \right)$");
ylim([0 120]);
grid on;
grid minor;
legend(legend_str, 'location', 'southwest');
hold off;

% Reynolds vs. Altitude
fig7 = figure('Name', 'Reynolds vs. Altitude');
hold on;
title('\textbf{Reynolds vs. Altitude}');
set(fig7, 'Position', [785 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
for i = 1:length(gamma_values)
    plot(results{i}.Re, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Reynolds number ");
ylim([0 120]);
grid on;
grid minor;
legend(legend_str, 'location', 'northwest');
hold off;

% Heat Load
fig8 = figure('Name', 'Heat Load');
hold on;
title('\textbf{Heat Load}');
set(fig8, 'Position', [1170 305 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
for i = 1:length(gamma_values)
    plot(results{i}.t_i, results{i}.heat_load, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Heat Load $\left( \mathrm{J} / \mathrm{m}^2 \right)$");
xlabel("Time [s] ");
grid on;
grid minor;
legend(legend_str, 'location', 'northwest');
hold off;

% Range vs. Altitude
fig9 = figure('Name', 'Range vs. Altitude');
hold on;
set(fig9,'Position', [15 45 375 170]);
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Range vs. Altitude}');
for i = 1:length(gamma_values)
    plot(results{i}.r_i/1e3, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Range $\left( \mathrm{km} \right)$");
ylim([0 120]);
grid on;
grid minor;
legend(legend_str, 'location', 'southwest');
hold off;


% Velocity vs. Altitude
fig10 = figure('Name', 'Altitude');
hold on;
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Altitude vs. Time}');
for i = 1:length(gamma_values)
    plot(results{i}.t_i, results{i}.H_i/1e3, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("\textbf{Altitude} $\left( \mathrm{km} \right)$");
xlabel("\textbf{Time} $\left( \mathrm{s}  \right)$");
legend(legend_str, 'location', 'northwest');
grid on;
grid minor;
hold off;


% Mach vs. Altitude
fig11 = figure('Name', 'Mach vs. Altitude');
hold on;
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title('\textbf{Mach Number vs. Altitude}');
for i = 1:length(gamma_values)
    plot(results{i}.t_i, results{i}.Mach, 'LineWidth', lineWidth, 'Color', colors(i,:));
end
ylabel("Mach ");
xlabel("Time $\left( \mathrm{s}  \right)$");
grid on;
grid minor;
legend(legend_str, 'location', 'northwest');
hold off;

end