function plotVsTime3D(t_i,H_i,V_i,gamma_i,Mach)

%Plot Altitude vs Time
figure('Name','Altitude vs Time');
set(groot,'defaultAxesTickLabelInterpreter','latex');  
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(t_i,H_i/1e3,'LineWidth',1.5)
ylabel("Altitude $\left( \mathrm{km} \right)$");
xlabel("Time $\left( \mathrm{s} \right)$");
title("\textbf{Altitude vs. Time}");
grid on;
grid minor;
hold off;

figure('Name','Velocity vs Time')
set(groot,'defaultAxesTickLabelInterpreter','latex');  
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(t_i,V_i,'LineWidth',1.5)
ylabel("Velocity $\left( \mathrm{m} / \mathrm{s} \right)$");
xlabel("Time $\left( \mathrm{s} \right)$");
title("\textbf{Velocity vs. Time}");
grid on;
grid minor;
hold off;

figure('Name','Flight Path angle vs Time')
set(groot,'defaultAxesTickLabelInterpreter','latex');  
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(t_i,-gamma_i*180/pi,'LineWidth',1.5)
ylabel("Flight Path angle $\left( \mathrm{deg} \right)$");
xlabel("Time $\left( \mathrm{s} \right)$");
title("\textbf{Flight Path Angle vs. Time}");
grid on;
grid minor;
hold off;

figure('Name','Mach vs Time')
set(groot,'defaultAxesTickLabelInterpreter','latex');  
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
plot(t_i,Mach,'LineWidth',1.5)
ylabel("Mach");
xlabel("Time $\left( \mathrm{s} \right)$");
title("\textbf{Mach vs. Time}");
grid on;
grid minor;
hold off;


