function plotAtmosphere3D(H_layer_E, lambda_layer_E, Tb, Pb, R, g0_E, Mm_E)

% Plot Temperature vs. Altitude
figure(1);
hold on;
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title("\textbf{Temperature vs. Altitude}");
for i = 1:length(H_layer_E)-1
    plot([Tb(i) Tb(i+1)], [H_layer_E(i) H_layer_E(i+1)]/1e3, 'r','LineWidth',1.5);
end
xlabel("Temperatura $\left( \mathrm{K} \right)$");
ylabel("Altitude $\left( \mathrm{km} \right)$");
grid on;
grid minor;
hold off;

% Plot Pressure vs. Altitude (until 20 km)
DeltaH = 1000; %[m]
H_plot = 0:DeltaH:max(H_layer_E); %0:1000:120000 [m]
P_plot = zeros(1, length(H_plot));
index_20 = 20e3/DeltaH + 1;
for i = 1:length(H_plot)
    P_plot(i) = getPressure3D(Tb, Pb, H_layer_E, lambda_layer_E, R, g0_E, Mm_E, H_plot(i));
    P_plot(i) = abs(P_plot(i));
end

figure(2);
hold on;
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title("\textbf{Pressure vs. Altitude}");
plot(P_plot(1:index_20)/1e2, H_plot(1:index_20)/1e3, 'b','LineWidth',1.5);
xlabel("Pressure $\left( \mathrm{kPa} \right)$");
ylabel("Altitude $\left( \mathrm{km} \right)$");
grid on;
grid minor;
hold off;

% % Plot Pressure vs. Altitude (from 20 km)
figure(3);
hold on;
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title("\textbf{Pressure vs. Altitude}");
plot(P_plot(index_20+1:end)/1e2, H_plot(index_20+1:end)/1e3, 'b','LineWidth',1.5);
xlabel("Pressure $\left( \mathrm{kPa} \right)$");
ylabel("Altitude $\left( \mathrm{km} \right)$");
grid on;
grid minor;
hold off;

% Plot Density vs. Altitude
rho_plot = zeros(1, length(H_plot));
for i = 1:length(H_plot)
    rho_plot(i) = getDensity3D(Tb, Pb, H_layer_E, lambda_layer_E, R, g0_E, Mm_E, H_plot(i));
    rho_plot(i) = abs(rho_plot(i));
    %fprintf("%15d %15.2f %15.2f\n", i, H_plot(i), P_plot(i));
end

figure(4);
hold on;
set(groot,'defaultAxesTickLabelInterpreter','latex');
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
title("\textbf{Density vs. Altitude}");
plot(rho_plot, H_plot/1e3, 'b','LineWidth',1.5);
xlabel("Density $\left( \mathrm{kg} / \mathrm{m}^3 \right)$");
ylabel("Altitude $\left( \mathrm{km} \right)$");
grid on;
grid minor;
hold off;

end