function P = getPressure3D(Tb, Pb, H_layer_E, lambda_layer_E, R, g0_E, Mm_E, H)



P = 0;
found = 0;
layer = 1;
while (layer <= length(H_layer_E)-1) && (found == 0)
    if (H_layer_E(layer) <= H) && (H < H_layer_E(layer+1))
        found = 1;        
    else        
        layer = layer + 1;
    end
end

if found == 1
    if lambda_layer_E(layer) == 0
        P = Pb(layer)*exp(-g0_E * Mm_E * (H-H_layer_E(layer)) / (R*Tb(layer))); %Barometric Law for isothermal layer
    else
        P = Pb(layer)*((Tb(layer)/(Tb(layer) + lambda_layer_E(layer)*(H-H_layer_E(layer))))^(g0_E*Mm_E/(R*lambda_layer_E(layer))));
    end
end

end