function [t_sol, V_sol, gamma_sol, heading_sol, H_sol, r_sol, lat_sol, lon_sol] = ...
    Integration_noRotation(G, Mp, Rp, g0, R, Mm, Tb, Pb, H_layer, lambda, ...
    CL, CD, beta, H0, V0, gamma0, lat0, lon0, heading0, t_max, Delta_t)

       
    % Solution vectors
    t_sol = 0:Delta_t:t_max;
    H_sol = zeros(1, length(t_sol));
    V_sol = zeros(1, length(t_sol));
    gamma_sol = zeros(1, length(t_sol));
     r_sol = zeros(1, length(t_sol));
    lat_sol = zeros(1, length(t_sol));
    lon_sol = zeros(1, length(t_sol));
    heading_sol = zeros(1, length(t_sol));

    % Initial conditions
    H_sol(1) = H0;
    V_sol(1) = V0;
    gamma_sol(1) = deg2rad(gamma0);
    lat_sol(1) = deg2rad(lat0);
    lon_sol(1) = deg2rad(lon0);
    heading_sol(1) = deg2rad(heading0);

    
    % Runge-Kutta
    i = 1;

    while (i <= length(t_sol)-1) && (H_sol(i) >= 0)
     
        
        
        % Eq (3) Velocity 
        F1 = @(t, V, gamma, heading, H, r, lat, lon) ((G*Mp)/(Rp+H)^2)*(sin(gamma)-((1/2)*getDensity3D(Tb, Pb, H_layer, lambda, R, g0, Mm, H)*V^2)/beta);
        
        % Eq (4) path angle 
        F2 = @(t, V, gamma, heading, H, r,lat, lon)  ((-(1/2)*getDensity3D(Tb, Pb, H_layer, lambda, R, g0, Mm, H)*V^2)*((G*Mp)/(Rp+H)^2)*(1/beta)*(CL/CD) + ...
       (((G*Mp)/(Rp+H)^2)-(V^2/(Rp+H)))*cos(gamma))/V; 
        
        % Eq (5) heading angle 
        F3 = @(t, V, gamma, heading, H, r,lat, lon) -((V^2/(Rp+H))*cos(gamma)*cos(heading)*tan(lat))/V;
        
        % Eq (6) altitude
        F4 = @(t, V, gamma, heading, H, r,lat, lon) -V*sin(gamma);
        
        % Eq (7) range
         F5 = @(t, V, gamma, heading, H, r,lat, lon) (Rp/(Rp+H))*V*cos(gamma);
        
        % Eq (8) Latitudine
        F6 = @(t, V, gamma, heading, H, r,lat, lon) (V * cos(gamma) * sin(heading)) / (Rp + H);
        
        % Eq (9) longitude
        F7 = @(t, V, gamma, heading, H, r,lat, lon) (V * cos(gamma) * cos(heading)) / ((Rp + H) * cos(lat));

        % Coefficients 1
        i1 = F1(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i),lat_sol(i), lon_sol(i));
        j1 = F2(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i),lat_sol(i), lon_sol(i));
        k1 = F3(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i),lat_sol(i), lon_sol(i));
        l1 = F4(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i),lat_sol(i), lon_sol(i));
         m1 = F5(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i),lat_sol(i), lon_sol(i));
        n1 = F6(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i),lat_sol(i), lon_sol(i));
        o1 = F7(t_sol(i), V_sol(i), gamma_sol(i), heading_sol(i), H_sol(i), r_sol(i), lat_sol(i), lon_sol(i));
        
        % Coefficients 2
        i2 = F1(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);
        j2 = F2(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);
        k2 = F3(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);
        l2 = F4(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);
         m2 = F5(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);        
        n2 = F6(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);
        o2 = F7(t_sol(i)+Delta_t/2, V_sol(i)+i1*Delta_t/2, gamma_sol(i)+j1*Delta_t/2, heading_sol(i)+k1*Delta_t/2, H_sol(i)+l1*Delta_t/2, r_sol(i)+m1*Delta_t/2,lat_sol(i)+n1*Delta_t/2, lon_sol(i)+o1*Delta_t/2);
        

        % Coefficients 3
        i3 = F1(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, heading_sol(i)+k2*Delta_t/2, H_sol(i)+l2*Delta_t/2, r_sol(i)+m2*Delta_t/2, lat_sol(i)+n2*Delta_t/2, lon_sol(i)+o2*Delta_t/2);
        j3 = F2(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, heading_sol(i)+k2*Delta_t/2, H_sol(i)+l2*Delta_t/2, r_sol(i)+m2*Delta_t/2,lat_sol(i)+n2*Delta_t/2, lon_sol(i)+o2*Delta_t/2);
        k3 = F3(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, heading_sol(i)+k2*Delta_t/2, H_sol(i)+l2*Delta_t/2, r_sol(i)+m2*Delta_t/2,lat_sol(i)+n2*Delta_t/2, lon_sol(i)+o2*Delta_t/2);
        l3 = F4(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, heading_sol(i)+k2*Delta_t/2, H_sol(i)+l2*Delta_t/2, r_sol(i)+m2*Delta_t/2,lat_sol(i)+n2*Delta_t/2, lon_sol(i)+o2*Delta_t/2);
         m3 = F5(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, H_sol(i)+k2*Delta_t/2, lat_sol(i)+m2*Delta_t/2, lon_sol(i)+n2*Delta_t/2, heading_sol(i)+o2*Delta_t/2);
        n3 = F6(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, heading_sol(i)+k2*Delta_t/2, H_sol(i)+l2*Delta_t/2, r_sol(i)+m2*Delta_t/2,lat_sol(i)+n2*Delta_t/2, lon_sol(i)+o2*Delta_t/2);
        o3 = F7(t_sol(i)+Delta_t/2, V_sol(i)+i2*Delta_t/2, gamma_sol(i)+j2*Delta_t/2, heading_sol(i)+k2*Delta_t/2, H_sol(i)+l2*Delta_t/2, r_sol(i)+m2*Delta_t/2,lat_sol(i)+n2*Delta_t/2, lon_sol(i)+o2*Delta_t/2);

        % Coefficients 4
        i4 = F1(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t, lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);
        j4 = F2(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t,lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);
        k4 = F3(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t,lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);
        l4 = F4(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t,lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);
         m4 = F5(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t,lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);
        n4 = F6(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t,lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);
        o4 = F7(t_sol(i)+Delta_t, V_sol(i)+i3*Delta_t, gamma_sol(i)+j3*Delta_t, heading_sol(i)+k3*Delta_t, H_sol(i)+l3*Delta_t, r_sol(i)+m3*Delta_t,lat_sol(i)+n3*Delta_t, lon_sol(i)+o3*Delta_t);

        % Compute next step
        V_sol(i+1) = V_sol(i) + (Delta_t/6)*(i1 + 2*i2 + 2*i3 + i4);
        gamma_sol(i+1) = gamma_sol(i) + (Delta_t/6)*(j1 + 2*j2 + 2*j3 + j4);
        heading_sol(i+1) = heading_sol(i) +(Delta_t/6)*(k1 + 2*k2 + 2*k3 + k4);
        H_sol(i+1) = H_sol(i) + (Delta_t/6)*(l1 + 2*l2 + 2*l3 + l4);
         r_sol(i+1) = r_sol(i) + (Delta_t/6)*(m1 + 2*m2 + 2*m3 + m4);
        lat_sol(i+1) = lat_sol(i) + (Delta_t/6)*(n1 + 2*n2 + 2*n3 + n4);
        lon_sol(i+1) = lon_sol(i) + (Delta_t/6)*(o1 + 2*o2 + 2*o3 + o4);


        i = i + 1;
    end
end


% Reference:
% [1] Dynamics of Atmospheric Re-Entry,Frank J. Regan, Satya M. Anandakrishnan
% Equations - pag 59 hicks