function [T_sol, P_sol, rho_sol] = CalculateAtmosphere3D(Tb, Pb, H_layer, lambda, R, g0, Mm, H_sol)




T_sol = zeros(1, length(H_sol));
P_sol = zeros(1, length(H_sol));
rho_sol = zeros(1, length(H_sol));

for i = 1:length(H_sol)
    T_sol(i) = getTemperature3D(Tb, H_layer, lambda, H_sol(i));
    P_sol(i) = getPressure3D(Tb, Pb, H_layer, lambda, R, g0, Mm, H_sol(i));
    rho_sol(i) = getDensity3D(Tb, Pb, H_layer, lambda, R, g0, Mm, H_sol(i));
end

end

