function [Tb, Pb] = BaseTemperaturePressure3D(R, g0_E, T0_E, P0_E, Mm_E, H_layer_E, lambda_layer_E)


% Declare vectors of Base Temperature and Pressure
Tb = zeros(1, length(H_layer_E)); % Base Temperature  [K]
Pb = zeros(1, length(H_layer_E)); % Base Pressure     [Pa]

% Compute Base Temperatures and Pressures for each layer
Tb(1) = T0_E;
Pb(1) = P0_E;

for i = 2:length(H_layer_E)

    % Compute Base Temperature at layer i
    Tb(i) = Tb(i-1) + lambda_layer_E(i-1)*(H_layer_E(i)-H_layer_E(i-1));
    
    % Compute Base Pressure at layer i
    if lambda_layer_E(i-1) == 0 % Isothermal layer
        Pb(i) = Pb(i-1)*exp(-g0_E*Mm_E*(H_layer_E(i) - H_layer_E(i-1))/(R*Tb(i-1)));
    else   % Non-isothermal layer
        Pb(i) = Pb(i-1)*((Tb(i-1)/(Tb(i-1) + lambda_layer_E(i-1)*(H_layer_E(i) - H_layer_E(i-1))))^(g0_E*Mm_E/(R*lambda_layer_E(i-1))));
    end
    
end


end