#pragma once

#include "ofMain.h"
#include <memory>
#include "ofxLayerMask.h"

// Most of these definitions include ofGetWidth() and ofGetHeight(), so that the graphical objects scale and adapt to the dimension of the window (or screen in case of FULL_SCREEN mode)


// GENERAL DEFINITIONS - NOTE: these are values that update with the window current size, by definition of the ofGetWidth and Height functions.
#define SCREEN_WIDTH ofGetWidth()
#define SCREEN_HEIGHT ofGetHeight()
#define MIDDLE_SCREEN ofGetWidth()*0.5, ofGetHeight()*0.5 // This is useful when inputting into a function that accepts X and Y coordinates in this order, such as ofTranslate or the first two arguments of most ofDraw functions

//#define TOP_LEFT ofGetWidth() * 0.25, ofGetHeight * 0.25
//#define TOP_RIGHT ofGetWidth() * 0.75, ofGetHeight * 0.5
//#define BOTTOM_LEFT ofGetWidth() * 0.25, ofGetHeight * 0.75
//#define TOP_RIGHT ofGetWidth() * 0.75, ofGetHeight * 0.75

// UNITS CONVERSION - NOTE: inputs are received in Metric System. These conversions get applied only if the enum "units" is initialized to "IMPERIAL" (1). Default value for "units" is "METRIC" (0)
#define PA_TO_HG_INCH 0.000295f
#define M_S_TO_KNOTS 1.94384449f
#define M_TO_FEET 3.2808399f

#define M_S_TO_FEET_MIN 196.850f

#define	PITCH_DEG_TO_PIXEL (ofGetHeight() / 99.0f)
















