close all

%%Scelta Tipo Simulazione
iteorico = 1; %Caso Teorico
ireale = 0; %2-Caso 2 Tiri Catena; 3-Caso 3 Tiri Catena
%%Scelta Segnale Ingresso di Pgambe-Ru-Iv-VGmin-Nx
iplot = 0; %0-No Plot; 1-Plot
iPg = 1; %Prova 1-2-3-4
iRu = 4; %Prova 1-2-3-4
iIv = 3; %Valori 1-6, Ottimale = 3
VGmin = 17; %[V]
N1 = 54; %Numero Denti Corona 1
N2 = 11; %Numero Denti Corona 2
N3 = 54; %Numero Denti Corona 3
N4 = 11; %Numero Denti Corona 4
N5 = 1; %Numero Denti Corona 5
N6 = 1; %Numero Denti Corona 6
%%Varie
radsrpm = 60/(2*pi); %[rad/s->rpm]
ngambemin = 60; %[rpm]
%%Momenti d'Inerzia
Im = 0.001; %[kg.m^2] 0.001
Ig = 0.001; %[kg.m^2] 0.001
%%Costanti Motore Elettrico
k = 0.100;
ke = k; %[V/rad/sec]
kc = k; %[N.m/Amp]
b = 0.0001; %[N.m.s] 0.0001
Rg = 1; %[Ohm] 0.1
Lg = 0.5; %[H] 0.1
VGnom = 36; %[V]
nNoLoad = 3450; %[rpm] 
%%Rapporti di Trasmissione
tau1 = N1/N2; 
tau2 = N3/N4; 
tau3 = N5/N6; 
%%Rendimenti
eta1 = 0.99;
eta2 = 0.99;
eta3 = 0.99;
if iteorico == 1
    ireale = 0;
    tautot=((nNoLoad/VGnom)*VGmin)/ngambemin;
    etatot = eta1*eta2*eta3;
else
    if ireale == 2
        tautot=tau1*tau2;
        etatot = eta1*eta2;
    elseif ireale == 3
        tautot=tau1*tau2*tau3;
        etatot = eta1*eta2*eta3;
    end
end
%%Segnale Ingresso Pgambe
if iPg == 1
    inttempoPg = 0.2; %0.01 0.1
    numintPg = 500; %1001 505 101
    tempoPg = inttempoPg*(0:numintPg-1);
    tempoPg = tempoPg';
    iPg=70;
    Pgdati = iPg*ones(numintPg,1);
    Pgdati = Pgdati';
    Pg = timeseries(Pgdati,tempoPg); %[W]
elseif iPg == 2
    Pgcost = 40;
    inttempoPg = 0.2; %0.01
    numintPg = 500; %1001 505 101
    tempoPg = inttempoPg*(0:numintPg-1);
    tempoPg = tempoPg';
    Pgint=0.2; %0.01 0.04
    Pgdati = Pgcost+Pgint*(0:numintPg-1);
   Pg = timeseries(Pgdati,tempoPg); %[W]
elseif iPg == 3
    tPg = 5;
    numintPg = 100;
    inttempoPg = [0 20 49 50 80];
    intPg = [0 0 70 0 0];
    tempointPg = [0.2 0.29 0.01 0.3 0.2];
    Pgint = [0 0 0.2 0 0];
    tempodatiPg = zeros(numintPg,tPg);
    datiPg = zeros(numintPg,tPg);
    for jPg = 1:tPg
        if jPg == 1
            iPg = 70;
            Pgdatij = iPg*ones(numintPg,1);
            datiPg(:,jPg) = Pgdatij';
            tempojPg = inttempoPg(1,jPg)+tempointPg(1,jPg)*(0:numintPg-1);
            tempodatiPg(:,jPg) = tempojPg';
        elseif jPg == 2
            iPg = 70;
            Pgdatij = iPg*ones(numintPg,1);
            datiPg(:,jPg) = Pgdatij';
            tempojPg = inttempoPg(1,jPg)+tempointPg(1,jPg)*(0:numintPg-1);
            tempodatiPg(:,jPg) = tempojPg';
        elseif jPg == 3
            Pgdatij = intPg(1,jPg)+Pgint(1,jPg)*(0:numintPg-1);
            datiPg(:,jPg) = Pgdatij';
            tempojPg = inttempoPg(1,jPg)+tempointPg(1,jPg)*(0:numintPg-1);
            tempodatiPg(:,jPg) = tempojPg';
        elseif jPg == 4
            iPg = 90;
            Pgdatij = iPg*ones(numintPg,1);
            datiPg(:,jPg) = Pgdatij';
            tempojPg = inttempoPg(1,jPg)+tempointPg(1,jPg)*(0:numintPg-1);
            tempodatiPg(:,jPg) = tempojPg';
        else
            iPg = 90;
            Pgdatij = iPg*ones(numintPg,1);
            datiPg(:,jPg) = Pgdatij';
            tempojPg = inttempoPg(1,jPg)+tempointPg(1,jPg)*(0:numintPg-1);
            tempodatiPg(:,jPg) = tempojPg';
        end
    end
    Pgdati = reshape(datiPg,[],1);
    tempoPg = reshape(tempodatiPg,[],1);
    Pg = timeseries(Pgdati,tempoPg); %[W]
else
    Pgcost = 70;
    Pgprec = 10;
    inttempoPg = 0.2;
    numintPg = 500;
    tempoPg = inttempoPg*(0:numintPg-1);
    tempoPg = tempoPg';
    Pgdati = Pgcost+Pgprec*sin(2*pi/18*tempoPg);
    Pg = timeseries(Pgdati,tempoPg); %[W]   
end
%%Segnale Ingresso Ru
if iRu == 1
    inttempoRu = 0.2; %0.01 0.1
    numintRu = 500; %1001 505 101
    tempoRu = inttempoRu*(0:numintRu-1);
    tempoRu = tempoRu';
    iRu=5;
    Rudati = iRu*ones(numintRu,1);
    Rudati = Rudati';
    Ru = timeseries(Rudati,tempoRu); %[Ohm]
elseif iRu == 2
    inttempoRu = 0.2; %0.01
    numintRu = 500; %1001 505 101
    tempoRu = inttempoRu*(0:numintRu-1);
    tempoRu = tempoRu';
    Ruint=0.01; %0.01 0.04
    Rudati = Ruint*(0:numintRu-1);
    Ru = timeseries(Rudati,tempoRu); %[Ohm]
elseif iRu == 3
    tRu = 5;
    numintRu = 100;
    inttempoRu = [0 20 49 50 80];
    intRu = [0 0 5 0 0];
    tempointRu = [0.2 0.29 0.01 0.3 0.2];
    Ruint = [0 0 0.02 0 0];
    tempodatiRu = zeros(numintRu,tRu);
    datiRu = zeros(numintRu,tRu);
    for jRu = 1:tRu
        if jRu == 1
            iRu = 5;
            Rudatij = iRu*ones(numintRu,1);
            datiRu(:,jRu) = Rudatij';
            tempoj = inttempoRu(1,jRu)+tempointRu(1,jRu)*(0:numintRu-1);
            tempodatiRu(:,jRu) = tempoj';
        elseif jRu == 2
            iRu = 5;
            Rudatij = iRu*ones(numintRu,1);
            datiRu(:,jRu) = Rudatij';
            tempoj = inttempoRu(1,jRu)+tempointRu(1,jRu)*(0:numintRu-1);
            tempodatiRu(:,jRu) = tempoj';
        elseif jRu == 3
            Rudatij = intRu(1,jRu)+Ruint(1,jRu)*(0:numintRu-1);
            datiRu(:,jRu) = Rudatij';
            tempoj = inttempoRu(1,jRu)+tempointRu(1,jRu)*(0:numintRu-1);
            tempodatiRu(:,jRu) = tempoj';
        elseif jRu == 4
            iRu = 7;
            Rudatij = iRu*ones(numintRu,1);
            datiRu(:,jRu) = Rudatij';
            tempoj = inttempoRu(1,jRu)+tempointRu(1,jRu)*(0:numintRu-1);
            tempodatiRu(:,jRu) = tempoj';
        else
            iRu = 7;
            Rudatij = iRu*ones(numintRu,1);
            datiRu(:,jRu) = Rudatij';
            tempoj = inttempoRu(1,jRu)+tempointRu(1,jRu)*(0:numintRu-1);
            tempodatiRu(:,jRu) = tempoj';
        end        
    end
    Rudati = reshape(datiRu,[],1);
    tempoRu = reshape(tempodatiRu,[],1);
    Ru = timeseries(Rudati,tempoRu); %[Ohm]
else
    Rucost = 5;
    Ruprec = 2;
    inttempoRu = 0.2;
    numintRu = 500;
    tempoRu = inttempoRu*(0:numintRu-1);
    tempoRu = tempoRu';
    Rudati = Rucost+Ruprec*sin(2*pi/18*tempoRu);
    Ru = timeseries(Rudati,tempoRu); %[Ohm]
end
if iplot == 0
    zIv = 0;    
elseif iplot == 1
    figure
    subplot(2,1,1)
    plot(Pg,'LineWidth',4),grid
    xlabel('Tempo [sec]') 
    ylabel('Potenza [W]')
    legend('Potenza Gambe, Pg')
    title('Caratteristica della Potenza Pgambe')
    set(gca,'FontSize',22)
    subplot(2,1,2)
    plot(Ru,'LineWidth',4),grid
    xlabel('Tempo [sec]') 
    ylabel('Resistenza Ru [ohm]')
    legend('Resistenza, Ru')
    title('Caratteristica della Resistenza Ru')
    set(gca,'FontSize',22)
elseif iplot == 2
    figure
    plot(Pg,'LineWidth',6),grid
    xlabel('Tempo [sec]') 
    ylabel('Potenza [W]')
    legend('Potenza Gambe, Pg')
    title('Caratteristica della Potenza Pgambe')
    set(gca,'FontSize',40)
else
    figure
    plot(Ru,'LineWidth',6),grid
    xlabel('Tempo [sec]') 
    ylabel('Resistenza Ru [ohm]')
    legend('Resistenza, Ru')
    title('Caratteristica della Resistenza Ru')
    set(gca,'FontSize',40)
end
%%Tipologia Volano
if iIv == 1
    Iv = 0; %[kg.m^2] rv = 0 [m]
    jIv = 1;
elseif iIv == 2
    Iv = 0.00405; %[kg.m^2] rv = 0.1 [m]
    jIv = 2;
elseif iIv == 3
    Iv = 0.0648; %[kg.m^2] rv = 0.2 [m]
    jIv = 3;
elseif iIv == 4
    Iv = 0.328; %[kg.m^2] rv = 0.3 [m]
    jIv = 4;
elseif iIv == 5
    Iv = 1.04; %[kg.m^2] rv = 0.4 [m]
    jIv = 5;
else
    Iv = 2.53; %[kg.m^2] rv = 0.5 [m]
    jIv = 6;
end