


% the first case

clear
close all
clc

%% load losses
train_loss = readNPY("train_losses.npy");
test_loss = readNPY("test_losses.npy");

%% ecdf

figure('Name','train_loss')

[train_loss_ecdf,train_loss_] = ecdf(train_loss);
ecdf(train_loss)



%% ecdf   (1:390)
test_loss_ecdf = fun(train_loss_(1:395), train_loss_ecdf, test_loss);

save("test_loss_ecdf.mat","test_loss_ecdf")

%% 
close all
codes = test_loss_ecdf;
normal_max = test_loss_ecdf(1:51);
anomaly_max = test_loss_ecdf(52:end);

%% EVALUATE 

normal = codes(1:51);
anomaly = codes(52:end);

for i = 1:floor(499/20)
    test_codes(i,:) = [normal, anomaly((i-1)*20+1:i*20)];
end

labels = [zeros(1,51), ones(1,20)];
for i=1:floor(499/20)
    auc_lstm(i) = 0;
    [~, ~, ~, auc_lstm(i)] = perfcurve(labels, test_codes(i,:), 1);

end
auc_lstm_mean = mean(auc_lstm)

sorted_codes = sort(test_codes,2);

for i=1:floor(499/20)
    a(i) = 0;
    a_f(i) = 0;
    n(i) = 0;
    n_f(i) = 0;
    TNR(i) = 0;
    FNR(i) = 0;
    TPR(i) = 0;
    FPR(i) = 0;
    
    for j = 52:71
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) > 51
            a(i) = a(i) + 1;
        else
            a_f(i) = a_f(i) + 1;
        end
        TNR(i) = a(i)/20;
        FPR(i) = a_f(i)/20;
    end
    for j = 1:51
        index = find(test_codes(i,:) == sorted_codes(i,j));
        test_codes(i,index(end)) = nan;
        if index(end) < 52
            n(i) = n(i) + 1;
        else
            n_f(i) = n_f(i) + 1;
        end
        TPR(i) = n(i)/51;
        FNR(i) = n_f(i)/51;

    end
end
tolal_TNR = mean(TNR)
tolal_FNR = mean(FNR)
tolal_TPR = mean(TPR)
tolal_FPR = mean(FPR)

acc = (a+n)/71;
acc_LSTM = mean(acc)


return

% a = 0;
% a_f = 0;
% n = 0;
% n_f = 0;
% 
% for i = 52:550
%     if test_loss_ecdf(i) == 1
%         a = a + 1;
%     else
%         a_f = a_f + 1;
%     end
% end
% 
% TNR = a/499
% FNR = a_f/499
% 
% for i = 1:51
%     if test_loss_ecdf(i) < 1
%         n = n + 1;
%     else
%         n_f = n_f + 1;
%     end
% end
% 
% TPR = n/51
% FPR = n_f/51
% 
% acc_max = (TNR+TPR)/2
% 
